/*	install.cmd - REXX script for ScreenSaver installation
	(C) 1993-95 Siegfried Hanisch
*/

call RxFuncAdd "SysLoadFuncs", "RexxUtil", "SysLoadFuncs"
call SysLoadFuncs

say "ScreenSaver 2.0 installation."

rc = SysFileTree("SSaver.EXE", fspec, "FO")
if rc=0 then
do
	filename=filespec("Name", fspec.1)
	filepath=filespec("Path", fspec.1)
	filedrive=filespec("Drive", fspec.1)
	if SysCreateObject("WPProgram", "ScreenSaver",,
	  "<WP_DESKTOP>", "EXENAME="filedrive||filepath||filename,
	  ";STARTUPDIR="||filedrive||filepath, "replace") then
	do
		say "ScreenSaver program object created."
		say "If you want ScreenSaver to be automatically started at boot"
		say "time, move the program object to the startup folder."
		say "-----"
		say "Make sure the latest version of the emx-DLLs (version 0.9a supplied
		say "with ScreenSaver) are somewhere in your LIBPATH"
		say "-----"
		say "Please read the online help topic on 'low priority' if"
		say "saver animation is not smooth enough."
		say "-----"
		say "ScreenSaver is Shareware. Some functions are available only to registered"
		say "users. See online help or the file REGISTER.DOC for how to register."
		say "-----"
		say "Since version 1.3 there is password protection (for default "
		say "password, see online help)."
		say "-----"
		say "Version 2.0 has support for 'Green' monitors now. See online help."
		say "-----"
		say "There exists a little utility called SSKICK which starts a module when"
		say "executed. You can add this utility to the Desktop menu (see online help)."
		say "For available command line switches, see online help."
		say "In this distribution, I have included foreign modules. For"
		say "copyright information see the README file".
	end
	else
		say "ERROR: program object could not be created."
end
else
	say "ERROR: ScreenSaver program file SSaver.EXE not found."
	exit
end
