#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "mtypes.h"
#include "mloader.h"


BOOL UNI_Test(void)
{
	char id[4];

	rewind(modfp);
	if(!fread(id,4,1,modfp)) return 0;
	if(!memcmp(id,"UN04",4)) return 1;
	return 0;
}


BOOL UNI_Init(void)
{
	return 1;
}


void UNI_Cleanup(void)
{
	;
}


char *StrRead(void)
{
	char *s;
	UWORD len=0;

	fread(&len,sizeof(UWORD),1,modfp);

	if(!len) return NULL;

	s=malloc(len+1);
	fread(s,len,1,modfp);
	s[len]=0;

	return s;
}


UBYTE *TrkRead(void)
{
	UBYTE *t;
	UWORD len;

	fread(&len,sizeof(UWORD),1,modfp);
	t=malloc(len);
	fread(t,len,1,modfp);
	return t;
}



BOOL UNI_Load(void)
{
	int t,u;

	fseek(modfp,4,SEEK_SET);

	// try to read module header

	if(!fread(&of,sizeof(UNIHEADER),1,modfp)){
		myerr=ERROR_LOADING_HEADER;
		return 0;
	}

	of.songname=StrRead();
	of.modtype=StrRead();
	of.comment=StrRead();   // <- new since UN01

	if(!AllocInstruments()) return 0;

	if(!AllocTracks()) return 0;
	if(!AllocPatterns()) return 0;

	// Read sampleinfos

	for(t=0;t<of.numins;t++){

		INSTRUMENT *i=&of.instruments[t];

		fread(i,sizeof(UNIINSTRUMENT),1,modfp);
		i->insname=StrRead();

		if(!AllocSamples(i)) return 0;

		for(u=0;u<i->numsmp;u++){

			SAMPLE *s=&i->samples[u];

			fread(s,sizeof(UNISAMPLE),1,modfp);
			s->samplename=StrRead();
			s->seekpos=0;
		}
	}

	// Read patterns

	fread(of.pattrows,sizeof(UWORD),of.numpat,modfp);
	fread(of.patterns,sizeof(UWORD),of.numpat*of.numchn,modfp);

	// Read tracks

	for(t=0;t<of.numtrk;t++){
		of.tracks[t]=TrkRead();
	}

	return 1;
}





LOADER uniload={
	NULL,
	"UNI",
	"UNI loader v0.2",
	UNI_Init,
	UNI_Test,
	UNI_Load,
	UNI_Cleanup
};
