#include <stdio.h>
#include <stdlib.h>
#include "mtypes.h"
#include "extern.h"
#include "ultraerr.h"
#include "ultraext.h"

#include "forte.h"
#include "gf1proto.h"
#include "osproto.h"
#include "gf1hware.h"
#include "gf1os.h"
#include "extern.h"
#include "ultraerr.h"
#include "mdriver.h"

extern ULTRA_DATA _gf1_data;

ULTRA_CFG config;


// extern ULTRA_DATA _gf1_data;


int UltraNumVoices(int voices)
{
	int temp;

	_gf1_data.voices = voices;

	UltraDisableLineIn();
	UltraDisableMicIn();
	UltraDisableOutput();

	temp=UltraReset(voices);
	if(temp!=ULTRA_OK) return(temp);

	UltraSetInterface(_gf1_data.dram_dma_chan,_gf1_data.adc_dma_chan,
					  _gf1_data.gf1_irq_num,_gf1_data.midi_irq_num);

	SetIrqs(_gf1_data.gf1_irq_num,_gf1_data.midi_irq_num);

	UltraEnableOutput();
	return(ULTRA_OK);
}




int UltraGetCfg(ULTRA_CFG *config)
{
	char *ptr;

	config->base_port = 0x220;
	config->dram_dma_chan = 1;
	config->adc_dma_chan = 1;
	config->gf1_irq_num = 11;
	config->midi_irq_num = 5;

	if((ptr=getenv("ULTRASND"))==NULL) return FALSE;

	if(sscanf(ptr,"%x,%d,%d,%d,%d"
				,&config->base_port,
				&config->dram_dma_chan,
				&config->adc_dma_chan,
				&config->gf1_irq_num,
				&config->midi_irq_num)!=5) return FALSE;

	return(TRUE);
}



UBYTE UltraPeek(ULONG address)
{
	return(UltraPeekData(config.base_port,address));
}


void UltraPoke(ULONG address,UBYTE val)
{
	UltraPokeData(config.base_port,address,val);
}
