*********************************************************************
* RECDX.PRG                                               FoxPro 2.5
* Generate index commands to recreate all of the tags in a CDX file.
*
* Sample call: DO RECDX WITH cRetable, cRecdx, cReprg
* where cRetable is the DBF associated with the CDX
*       cRecdx is the CDX file whose tags will be recreated
*       cReprg is the file for the generated source code
*
*********************************************************************
PARAMETER cRetable, cRecdx, cReprg
IF EMPTY(cRetable) OR EMPTY(cRecdx) OR EMPTY(cReprg)
   ? "RECDX - Generate code to recreate existing tags"
   ? "Example: DO GENCDX WITH cGentable, cGencdx, cGenprg"
   RETURN
ENDIF
SET TEXTMERGE ON                 && Turn on textmerge
SET TEXTMERGE TO (cReprg)        && Send merged output to
SET TEXTMERGE NOSHOW             && Disable screen display of output

nWorkarea = SELECT(0)            && Save the current work area number
SELECT 0                         && Select a work area
USE (cRetable) AGAIN             && Open table
SET INDEX TO (cRecdx)            && Open cdx

\\********************************************************************
\* <<cReprg>>
\* Program to recreate index tags for the table named <<cRetable>>,
\* stored in the CDX file named <<cRecdx>>
\********************************************************************
\USE <<cRetable>> EXCLUSIVE      && Open table
\SET INDEX TO <<cRecdx>>         && Open cdx
\DELETE TAG ALL                  && Delete all existing tags
*
* Generate INDEX command for each existing tag
*
FOR x = 1 TO 9999999             && Loop for each tag
  IF "" = TAG(x)                 && Empty tag means we're done
     EXIT
  ENDIF
  \INDEX ON << SYS(14,x) >> TAG << TAG(x) >> OF <<cRecdx>>
ENDFOR
\FLUSH
\USE
\RETURN

USE                              && Close database and cdx file
SET TEXTMERGE OFF                && Turn off textmerge
SET TEXTMERGE TO
FLUSH
SELECT (nWorkarea)               && Return to the proper work area
RETURN
