;*****************************************************************
;* SCR v1.1 - (c) Jani Halme 1995 - Freeware!                    *
;*                                                               *
;* Compile with TASM 2.0 or higher and link with 'TLINK /T SCR'  *
;*****************************************************************

.286
code    segment public 'code'
assume  cs:code
        org     100h                    ;.COM header = 256 byte space for PSP

@@go:   xor     ax, ax
        mov     dx, cs:[82h]            ;get cmd. line parameter from PSP

@@g12:  cmp     dx, '21'                ;set 80x12 character mode?
        jnz     short @@g14
        call    @@s200
        call    @@3h
        jmp     @@f16
       
@@g14:  cmp     dx, '41'                ;set 80x14 character mode?
        jnz     short @@g21
        call    @@s200
        call    @@3h
        jmp     @@f14

@@g21:  cmp     dx, '12'                ;set 80x21 character mode?
        jnz     short @@g25
        call    @@s350
        call    @@3h
        jmp     @@f16

@@g25:  cmp     dx, '52'                ;set 80x25 character mode?
        jnz     short @@g27
        call    @@s400
        call    @@3h
        jmp     @@f16

@@g27:  cmp     dx, '72'                ;set 80x27 character mode?
        jnz     short @@g43
        call    @@s400
        call    @@3h
        jmp     @@f14

@@g43:  cmp     dx, '34'                ;set 80x43 character mode?
        jnz     short @@g50
        call    @@s350
        call    @@3h
        jmp     @@f08

@@g50:  cmp     dx, '05'                ;set 80x50 character mode?
        jnz     @@hlp
        call    @@s400
        call    @@3h
        jmp     @@f08

@@hlp:  mov     ax, cs                  ;display a little help message
        mov     ds, ax
        mov     dx, offset hlp
        mov     ah, 9
        int     21h
@@end:  mov     ah, 4ch                 ;terminate program
        int     21h

@@3h:   mov     ax, 3                   ;set bios mode 03h (80x25)
        int     10h
        xor     ax, ax
        ret

@@f16:  add     al, 2                   ;load 8x16 character set
@@f08:  inc     al                      ;load 8x8 character set
@@f14:  inc     al                      ;load 8x14 character set
        add     ax, 1110h
        xor     bx, bx
        int     10h
        jmp     @@end

@@s400: inc     al                      ;select 400 scanlines
@@s350: inc     al                      ;select 350 scanlines
@@s200: inc     al                      ;select 200 scanlines
        add     ax, 11ffh
        mov     bl, 30h
        int     10h
        ret

hlp     db      'SCR <12/14/21/25/27/43/50>',13,10,'$'
code    ends
        end @@go
