/***
*init.c - disked keyword and parameter initialize/set/display
*
*Copyright (c) 1991-1995, Gregg Jennings.  All wrongs reserved.
*   P O Box 200, Falmouth, MA 02541-0200
*
*Purpose:
*   Configuration handling.
*
*Notice:
*   This progam may be freely used and distributed.  Any distrubution
*   with modifications must retain the above copyright statement and
*   modifications noted.
*   No pulp-publication, in whole or in part, permitted without
*   permission (magazines or books).
*******************************************************************************/

/*
   Versions:

   1.1   04-Sep-1994    save/restore now has a structure
   1.0   18-Apr-1994

   Release Notes:

   Programming Notes:
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

#include "disked.h"
#include "init.h"
#include "keys.h"
#include "console.h"
#include "diskio.h"
#include "arrays.h"

/* global data defined here */

enum ARG_TYPE { BOOL_ARG, NUM_ARG, TEXT_ARG };

KEYWORDS kw[] = {
   { ALTD, 1, "display", BOOL_ARG },         // 0
   { ALTG, 0, "get", BOOL_ARG},              // 1
   { ALTH, 1, "home", BOOL_ARG },            // 2
   { ALTM, 1, "mask", BOOL_ARG },            // 3
   { ALTV, 1, "verify", BOOL_ARG },          // 4
   { ALTW, 0, "write", BOOL_ARG },           // 5
   { ALTS, 1, "strip", BOOL_ARG },           // 6
   { ALTC, 1, "convert", BOOL_ARG },         // 7
   { ALTF, 0, "files", BOOL_ARG },           // 8
   {    0, 0, "Debug", BOOL_ARG },           // 9
   { ALTA, 0, "ascii", BOOL_ARG },           // 10
   { ALTP, 1, "partial", BOOL_ARG },         // 11
   { ALTL, 1, "logical", BOOL_ARG },         // 12
   { ALTT, 0, "translate", BOOL_ARG },       // 13
   {    0, 0, NULL, 0},                      // 14    Note: THIS MUST BE NUL
   { ALTR,10, "radix", NUM_ARG },            // 15
   {    0, 1, "signon", BOOL_ARG },          // 16
   { ALTI, 2, "i/o", NUM_ARG },              // 17
   {    0, 1, "viewer", BOOL_ARG },          // 18
   {    0, 0, "filter", BOOL_ARG },          // 19
   {    0, 0, NULL, 0}                       //
};


/* internal data */

typedef struct {
   int argsize;
   void *value;
} SAVE_STATE;

static SAVE_STATE save_state[] = {
   { sizeof(int), &disk },
   { sizeof(long), &log_sector},
   { sizeof(tagged), &tagged},
   { sizeof(char) * SEARCH, findstr},
   { 0 }
};

/* internal functions */

static int lookup(char *t, KEYWORDS *kw, int num);
static int boolarg(char *);
static int numarg(char *);
#if 0
static int keyarg(char *arg,int key);
static unsigned long longarg(char *arg);
#endif
static int (*setup_func[])(char *) = {boolarg,numarg};


/*
   Read DISKED.INI and set the world.

   3.0   09-Apr-1994    completely re-written
   2.1   02-Apr-1994    forgot the fclose()
   ver   2.0   removed "boot" and "video" 02-Dec-1993
   ver   1.1   added "Expert"
*/

extern int initialize(char *filename)
{
int i;
char string[100], *seps = " \t\n,:=";
char *p,*arg;
FILE *file;

   if (stricmp(filename,"none")==0 || filename[0]=='\0')
      return 0;

   if ((file = fopen(filename,"r"))==NULL)
      return -1;

   while (!feof(file))
   {
      if (fgets(string,100,file) == NULL)
         break;

      if ((p = strtok(string,seps)) == NULL)
         continue;

      if (strchr(";/[",*p))
         continue;

      if (strcmp("Expert",p) == 0)
      {
         write_to = Write = Files = Translate = 1;
         Display = Verify = Home = Strip = Signon = 0;
         continue;
      }
      if ((arg = strtok(NULL,seps)) != NULL)
         if ((i = lookup(p,kw,sizeof(kw)/sizeof(KEYWORDS))) != -1)
            kw[i].value = setup_func[kw[i].type](arg);
   }

   /* Now deal with all of the special cases and do range checking */

   if (Write)
   {
      write_to = 1;
      Write = 0;        /* and make user turn it on */
   }

   if (Radix < 1 || Radix > 26)
      Radix = 10;

   if (Output < STDIO || Output > BIOS)
      Output = STDIO;

   fclose(file);
   return 1;
}

/* restore position, tagged sectors, find string */

extern int saveinit(char *filename)
{
SAVE_STATE *ss = save_state;
FILE *file;

   if ((file = fopen(filename,"w")) == NULL)
   {
      perror(filename);
      return 0;
   }
   fprintf(file,"; DISKED.SAV %s %s\n",Version,__DATE__);
   for (; ss->value; ss++)
      fwrite(ss->value,ss->argsize,1,file);
   fclose(file);
   return 1;
}

extern int getinit(char *filename, int arg)
{
SAVE_STATE *ss = save_state;
char string[100];
FILE *file;

   if ((file=fopen(filename,"r"))==NULL)
   {
      if (errno != ENOENT)
         perror(filename);
      return 0;
   }

   if (fgets(string,100,file) != NULL)
   {
      if (arg == INIT_RESTORE)
      {
         for (; ss->value; ss++)
            fread(ss->value,ss->argsize,1,file);
      }
      else if (arg == INIT_VIEW)
      {
         print("\n%s",string);
         fread(string,ss[0].argsize,1,file);             /* disk */
         print("\ndisk: %c:",*(int *)string + 'A'-1);
         fread(string,ss[1].argsize,1,file);             /* sector */
         print("\nsector: %ld",*(long *)string);
         fread(string,ss[2].argsize,1,file);             /* tags */
         print("\ntagged: ");
         plist((long *)string,sizeof(tagged)/sizeof(long),Radix);
         fread(string,ss[3].argsize,1,file);             /* findstr */
         print("\nfind: %s",string);
         output('\n');
      }
      fclose(file);
      return 1;
   }
   fclose(file);
   return 0;
}

/* display keywords */

extern void dkey(KEYWORDS *kw)
{
KEYWORDS *tkw = kw;

   print("\nON:  ");

   for (;kw->keyword;kw++)
      if (kw->value)
         print("%s ",kw->keyword);

   print("\nOFF: ");

   for (;tkw->keyword;tkw++)
      if (!tkw->value)
         print("%s ",tkw->keyword);
}

/* display keyword */

extern void psw(char c, KEYWORDS *kw)
{
   for (; kw->keyword; kw++)
   {
      if (kw->keyword[0] == c)
      {
        print("%s%s ",kw->keyword,(kw->value) ? ":ON" : ":OFF");
        break;
      }
   }
}

/* set keyword */

extern void ckey(char *s, KEYWORDS *kw)
{
   do
   {
      for (; kw->keyword; kw++)
      {
          if (kw->keyword[0] == *s)
          {
             kw->value++;
             if (kw->value > 1)
                kw->value -= 2;
             break;
         }
      }
   } while (*++s);
}

extern int setkeyword(unsigned int c, KEYWORDS *kw)
{
char tmpstr[2];

   tmpstr[0]='\0';

   for (; kw->keyword; kw++)
      if (c == kw->key)
      {
         tmpstr[0] = kw->keyword[0];
         break;
      }
   if (tmpstr[0] != '\0')
   {
      if (tmpstr[0] == 'w' && !write_to)
         ;
      else
      {
         tmpstr[1] = '\0';
         ckey(tmpstr,kw);
         psw(tmpstr[0],kw);
         return 1;
      }
   }
   return 0;
}

static int lookup(char *t, KEYWORDS *kw, int num)
{
int i;

   for (i = 0; i < num; i++,kw++)
      if (kw->keyword && strcmp(t,kw->keyword) == 0)
         return i;
   return -1;
}

static int boolarg(char *arg)
{
   return (arg && (stricmp("on",arg)==0 || stricmp("yes",arg)==0));
}

static int numarg(char *arg)
{
int i=0;

   if (arg)
      sscanf(arg,"%d",&i);
   return(i);
}

#if 0    /* these are not used yet */

static unsigned long longarg(char *arg)
{
unsigned long l=0L;

   if (arg)
      sscanf(arg,"%lu",&l);
   return l;
}

/***
*  assigns a key value: "^a" - "^z"  returns to 01 - 1Ah
*                       ""           returns key
*                       "off"        returns -1
****/

static int keyarg(char *arg,int key)
{
register int i;

   if (arg==NULL)
      i=key;
   else if (stricmp("off",arg)==0)
      i=-1;
   else if ((stricmp("^`",arg)+stricmp("^{",arg))==0)
      i=*(++arg)-'`';
   else
      i=*arg;
   return(i);
}

#endif   /* 0 */
