/***
*console.h - disked definitions/declarations for hardware specific functions.
*
*Copyright (c) 1991-1995, Gregg Jennings.  All wrongs reserved.
*   P O Box 200, Falmouth, MA 02541-0200
*
*Purpose:
*  BIOS Screen, BIOS Keyboard, Video memory functions, etc.
*
*Notice:
*   This progam may be freely used and distributed.  Any distrubution
*   with modifications must retain the above copyright statement and
*   modifications noted.
*   No pulp-publication, in whole or in part, permitted without
*   permission (magazines or books).
*******************************************************************************/

/*
   ver   1.1   01-Sep-1994    cleanup
   ver   0.1   27-Aug-1994    fixed clreol() bug
*/

#ifndef GENERAL_H
#include "general.h"    /* machine dependent and compiler */
#endif                  /*  specific stuff */


extern void initvideo(int iomode);

/* string printing */

extern int (*input)(void);          /* pointer to keyboard input function */
extern int (*output)(int);          /* pointer to console output function */
extern int (*print)(const char *,...);

extern void printc(const char *s);
extern void bprint(const char *s);
extern void disptext(char *text[]);
extern char *replicate(int i,int c);

#define put(i,c)  print(replicate(i,c))


/* BIOS Interrupt 10h services */

extern int int10(int _ax, int _bx, int _cx, int _dx);

extern  int getcursor(void);
extern void get_cursor(unsigned int *a, unsigned int *b);
extern void set_cursor(unsigned int a, unsigned int b);
extern  int getcursortype(void);
extern void cursor(int);

#define savecursor() cursor(1)
#define restcursor() cursor(0)

#define setvideo(m)              int10(m,0,0,0);
#define cursoron()               int10(0x0100,0,0x0B0C,0)
#define cursoroff()              int10(0x0100,0,0x2000,0)
#define setcursortype(s,e)       int10(0x0100,0,(s<<8)+(e),0)
#define setcurpos(r,c)           int10(0x0200,0,0,(r<<8)+(c))
#define gotoxy(x,y)              int10(0x0200,0,0,(((x)<<8)|(y)));
#define setcursor(c)             int10(0x0200,0,0,(c))
#define cls()                    int10(0x0600,0x0700,0,0x184f)
#define scrollup(n,ly,lx,ry,rx)  int10(0x0600+(n),7,(ly<<8)+(lx),(ry<<8)+(rx))
#define scrolldn(n,ly,lx,ry,rx)  int10(0x0700+(n),7,(ly<<8)+(lx),(ry<<8)+(rx))
#define charatcursor()           int10(0x0800,0,0,0)
#define charouta(c,a)            int10(0x0900+(c),a,1,0)
#define charouts(c,n)            int10(0x0A00+(c),0,n,0)
#define charout(c)               int10(0x0A00+(c),0,1,0)
#ifndef __BORLANDC__
#define clreol()                 int10(0x0A20,0,79,0)
#endif
#define outchar(c)               int10(0x0E00+(c),0,0,0)
#define videomode()              (int10(0x0F00,0,0,0) & 0xFF)
#define curright()               setcursor(getcursor()+1)
#define curleft()                setcursor(getcursor()-1)


/* BIOS Interrupt 16h services */

extern int int16(int _ax, int _bx, int _cx, int _dx);

#define readkey()       int16(0,0,0,0)
#define scankey()       int16(0,0,0,0)
#define keyflags()      int16(0x0200,0,0,0)
#define keyrepeat(d,r)  int16(0x0305,(d<<8)+(r),0,0)
#define putkey(s,c)     int16(0x0500,0,(s<<8)+(c),0)
#define ereadkey()      int16(0x1000,0,0,0)
#define ekeyflags()     int16(0x1200,0,0,0)
