
/*
	spot light demo -- shows 3 spot lights shining on the floor.
		The leftmost one is fully illuminated all the way
		across.  The rightmost one uses min_angle = 0 for
		a smoother effect.  The middle one shows that going
		half way leads to a great demonstration of Mach
		banding.  :-)
*/

#include color.vc

studio {
	from 0 -10 8
	at 0 0 0
	up 0 0 1
	angle 60
	res 640 480
	antialias quick
	threshold 2
	aspect 4/3
	background { greys.map }

	ambient white * .1
}

light {
	type spot
	color white * 10
	falloff 1
	position -4 0 10
	direction 0 .3 -1
	min_angle 20
	max_angle 20
}
light {
	type spot
	color white * 10
	falloff 1
	position 0 0 10
	direction 0 0 -1
	min_angle 10
	max_angle 20
}
light {
	type spot
	color white * 10
	falloff 1
	position 4 0 10
	direction 0 -.3 -1
	min_angle 0
	max_angle 20
}

surface {
	diff white
}
ring { center 0 0 0 normal 0 0 1 radius 10000 }
