//How does a stone bowl look like if it's half filled with water
//and surface has ripples..

//Created by Mika Bostrm
//Takes long time to render!!!! Water surface requires number-crunching..

#include "ior.inc"
#include "colors.inc"
#include "stones.inc"

camera {
  location <0, 5.75, -5.85>
  direction <0, 0, 1>
  up <0, 1, 0>
  right <4/3, 0, 0>
  look_at <0, 2.3, 0>
  }

//Let there be light!
light_source { <-50, 50, 50> color White }
light_source { <50, 50, -50> color White }

//How do I create a bowl?
union {
  merge {
    sphere { <0, 0, 0> 2 
      clipped_by { box { <-2, 0, -2>, <2, 2, 2> } }
      rotate x*180 
      }
    cylinder { <0, -1.825, 0>, <0, -2.15, 0>, 1.4 }
    texture { Stone15 }    //Texture by Mike Miller
    }

//There's a lot of liquid in the bowl already.
  object {
    difference {
      sphere { <0, 0, 0> 1.9999 }
      box { <-2, -0.6, -2>, <2, 2, 2> }
      texture {  
        pigment { 
          Blue filter 0.9 
          quick_color Blue
          }
        normal { 
          ripples 1.25
          frequency 6.2
          }
        finish {
          reflection 0.3
          refraction 1
          ior Water_Ior
          }
        }
      }
    }
  translate y*3.18
  }

