/*
  Find JFIF header in image
  
  Written by Jih-Shin Ho, 1994
  Copyright 1994 by Jih-Shin Ho
*/
#include <stdio.h>
#include <stdlib.h>

static int match_count;
static int num_id = 4;
static unsigned char id[] = {0xff,0xd8,0xff,0xe0};


main(int argc,char *argv[])
{
  int i,found;
  FILE *in,*out;

  if (argc != 3) {
	printf("\nUsage: findjpg input_file output_file\n\n");
	exit(0);
  }
  in = fopen(argv[1],"rb");
  if (in == NULL) {
	printf("Can't open %s\n",argv[1]);
	exit(1);
  }
  out = fopen(argv[2],"wb");
  if (out == NULL) {
	fclose(in);
	printf("Can't open %s\n",argv[2]);
	exit(1);
  }

  match_count = found = 0;
  while ((i = getc(in)) != EOF) {
	if (i == id[match_count]) {
	  match_count++;
	  if (match_count == num_id) {
		printf("JFIF header found.\n");
		found = 1;
		break;
	  }
	}
	else if (match_count) {
	  fseek(in,-match_count,SEEK_CUR);
	  match_count = 0;
	}
  }
  if (found) {
    for (i = 0; i < num_id; ++i) putc(id[i],out);
    while ((i = getc(in)) != EOF) putc(i,out);
  }
  fclose(in);
  fclose(out);
  if (found) printf("\nDone.\n\n");
  else {
	remove(argv[2]);
	printf("\nJFIF not found.\n\n");
  }
  return(0);
}

