(*****************************************************************************)
(*                                                                           *)
(*                            Concord BBS software                           *)
(*                                                                           *)
(*                  Copyright (C) 1993,97 by Pasi Talliniemi                 *)
(*                                                                           *)
(*****************************************************************************)

(* THIS FILE CONTAINS DATA STRUCTURES OF CONCORD DATA FILES.                 *)
(* All files should be opened in Filemode 66 (Read/Write, DenyNone) mode     *)
(* unless wanted to reserve them for the duration of certain processes.      *)

const

 SOFTWARE_NAME    = 'Concord';               (* Software name .............. *)
 SOFTWARE_COPYRIGHT = 'Copyright ' +         (* Copyright notice of software *)
   '(c) 1993,97 by Pasi Talliniemi';
 ID_VER           = $00001A9E;               (* Concord data file ID ....... *)
 CURRVERNUM       = 2;                       (* Version number in number fmt *)
 SOFTWARE_VERSION = 'O.O1 Gamma-5';          (* Version number in string fmt *)
 DEF_TEARLINE     = 'OOICS';             (* Tear line; x+OS2,P+x+DOS,R+x+DOS *)

(* Define tear lines for each version .. *)
{$IFDEF OS2}
         SOFTWARE_TEAR2 = '/2'; SOFTWARE_TEAR =       DEF_TEARLINE;
{$ELSE} {$IFDEF PROTMODE}
         SOFTWARE_TEAR2 = '';   SOFTWARE_TEAR = 'P' + DEF_TEARLINE + 'DOS';
{$ELSE}
         SOFTWARE_TEAR2 = '';   SOFTWARE_TEAR = 'R' + DEF_TEARLINE + 'DOS';
{$ENDIF} {$ENDIF}

         MAX_FLAG     = 10;
         MAX_LIMITBPS =  7;
         MAX_GOSUB    = 20;

type

         SmallInt     = System.Integer;               (* 16-bit   signed int *)
         SmallWord    = System.Word;                  (* 16-bit unsigned int *)

         ErrorType    = LongInt;                  (* 0 = OK, 1-65535 = ERROR *)

         (* Prepare for LONG file names *)
         PathStr      = String [79];
         DirStr       = String [67];
         ExtStr       = String [04];

         ANameStr     = String [60];
         NameStr      = String [35];
         CityStr      = String [25];
         PhoneStr     = String [20];
         PassStr      = String [15];
         DefStr       = String [15];
         QWKStr       = String [12];
         OpenStr      = String [11];
         MenuStr      = String [08];
         GroupStr     = String [03];

         DateRec      = SmallWord;                    (* Packed DOS format   *)
                                                      (* Bits 0 - 4  : Day   *)
                                                      (* Bits 5 - 8  : Month *)
                                                      (* Bits 9 - 15 : Year  *)

         TimeRec      = SmallWord;                    (* Minutes after 00:00 *)
         DateTimeRec  = LongInt;                      (* UNIX time stamp     *)

         CRC32        = LongInt;

         FlagType     = Array [1..MAX_FLAG] of Byte;     (* Flags, bitmapped *)

         LimitBpsType = Array [1..MAX_LIMITBPS] of SmallWord;

         Security     = Record
           Bpsrate  : SmallWord;                 (* Current BPS rate div 100 *)
           Age      : Byte;                      (* Age  . . . . . . . . . . *)
           SecLvl   : SmallWord;                 (* Security Level . . . . . *)
           Flags    : FlagType;                  (* Flags ON . . . . . . . . *)
           NotFlags : FlagType;                  (* Flags OFF  . . . . . . . *)
         end;                                    (* Size 25 bytes  . . . . . *)

         AddrRec      = Record
           Zone  : SmallWord;                                       (* Zone  *)
           Net   : SmallWord;                                       (* Net   *)
           Node  : SmallWord;                                       (* Node  *)
           Point : SmallWord;                                       (* Point *)
         end;

         NetRec       = Record
           NetName : DefStr;                       (* Name of current net    *)
           NetAddr : AddrRec;                      (* Address of current net *)
         end;

         FileMaskType = Array [1..11] of Char;

const

         LimitBpsrates : LimitBpsType = (
           12, 24, 96, 144, 192, 288, 1152
         );

const

         ID_LOG       = ID_VER or $00010000;
         ID_LOG_SYS   = ID_LOG or $01000000;
         ID_LOG_CHAT  = ID_LOG or $02000000;
         LOG_USERIN   = $0001;  (* User logged in (name,NEW,alias,sec,IEMSI) *)
         LOG_USEROUT  = $0002;  (* User logged off (normal,nocarrier,forced) *)
         LOG_EXEC     = $0003;  (* External program executed (cmdline)       *)
         LOG_UPLOAD   = $0004;  (* File downloaded (protocol,cps,size,name)  *)
         LOG_DOWNLOAD = $0005;  (* File uploaded (protocol,cps,size,name)    *)
         LOG_WRITE    = $0006;  (* Msg written (msgnum,area,subject,towhom)  *)
         LOG_PAGE     = $0007;  (* Sysop paged (reason)                      *)
         LOG_SCRIPT   = $0008;  (* Script executed (scriptname)              *)
         LOG_ERROR    = $0009;  (* Fatal error occurred (number, definition) *)
         LOG_OTHER    = $FFFF;  (* Other command (text)                      *)

type

         SysLogIdxRec = Record   (* LOGSYS.I?? - Log index file              *)
           StartPos : LongInt;   (* Absolute start position in log text file *)
         end;

(*****************************************************************************)
(*                                                                           *)
(*                           O T H E R   F I L E S                           *)
(*                                                                           *)
(*****************************************************************************)

const

         ID_SYS        = ID_VER or $00020000;
         ID_SYS_BBSLST = ID_SYS or $01000000;
         ID_SYS_CMNT   = ID_SYS or $02000000;
         ID_SYS_LAST   = ID_SYS or $03000000;

         BBSLIST_ACTIVE = $01;                            (* Bit 0 - Active? *)

         LAST_DOWNLOADED = $01;                  (* Bit 0 : Downloaded       *)
         LAST_UPLOADED   = $02;                  (* Bit 1 : Uploaded         *)
         LAST_READ       = $04;                  (* Bit 2 : Read messages    *)
         LAST_WROTE      = $08;                  (* Bit 3 : Wrote message(s) *)
         LAST_PAGED      = $10;                  (* Bit 4 : Paged SysOp      *)
         LAST_NEWUSER    = $20;                  (* Bit 5 : New user         *)
         LAST_QWK        = $40;                  (* Bit 6 : Used QWK system  *)
         LAST_NOCARRIER  = $80;                  (* Bit 7 : No Carrier       *)

         NODES_DOWN      = $01;                  (* Bit 0 : Node is down     *)
         NODES_NODISTURB = $02;                  (* Bit 1 : Do not disturb   *)

         NODESTAT_NOTHING  = $00;     (* Doing nothing special               *)
         NODESTAT_DOWNLOAD = $01;     (* Downloading file(s)                 *)
         NODESTAT_UPLOAD   = $02;     (* Uploading file(s)                   *)
         NODESTAT_READ     = $03;     (* Reading message(s)                  *)
         NODESTAT_WRITE    = $04;     (* Writing message                     *)
         NODESTAT_CHAT     = $05;     (* Chatting (0=Sysop,1-255=Conference) *)
         NODESTAT_DOOR     = $06;     (* Using external program              *)
         NODESTAT_LOGIN    = $07;     (* Logging in                          *)
         NODESTAT_QWK      = $08;     (* Using QWK/OMEN offline msg system   *)
         NODESTAT_FILELIST = $09;     (* Viewing file list                   *)

type

(* .............................. BBS LIST ................................. *)

         BBSlistHdr = Record    (* BBSLIST.DAT - BBS list file - List header *)
           Id       : LongInt;  (* Always ID_SYS_BBSLST                      *)
           Attrib   : Byte;     (* BBS attributes                            *)
           UnixDate : DateTimeRec;(* Adding date and time in UNIX fmt        *)
           Verified : DateTimeRec;(* Last verifying date and time in UNIX fmt*)
           AddedBy  : CRC32;    (* CRC-32 of adder's name                    *)
           ShowSec  : Security; (* Security needed to view this BBS          *)
           BBS      : NameStr;  (* BBS name                                  *)
           Sysop    : NameStr;  (* Sysop name                                *)
           Software : DefStr;   (* BBS software                              *)
           Nodes    : Byte;     (* Number of nodes in system                 *)
           Nets     : Byte;     (* Number of net addresses to system         *)
           DataLen  : SmallWord;     (* Length of other BBS data                  *)
          {Nodes}               (* Node entries                              *)
          {Nets}                (* Net entries  la NetRec                   *)
          {Data}                (* Other BBS data with fixed length          *)
         end;

         BBSlistNodeRec = Record (* BBSLIST.DAT - BBS list file - Node entry *)
           Number : PhoneStr;    (* Phone number                             *)
           Bps    : SmallWord;        (* Maximum bps rate div 100                 *)
           Open   : OpenStr;     (* Open time                                *)
           Other  : DefStr;      (* Other information about current node     *)
         end;

         BBSlistIdxRec = Record  (* BBSLIST.IDX - BBS list index file        *)
           StartPos : LongInt;   (* Absolute start position in BBS list file *)
           BBSCRC   : CRC32;     (* CRC-32 of BBS name; -1 if non-active     *)
         end;

(* ............................ LAST CALLERS ............................... *)

         LastCallerRec = Record          (* LASTCALL.DAT - Last callers list *)
           ID      : LongInt;            (* Always ID_SYS_LAST               *)
           Name    : NameStr;            (* User name                        *)
           Alias   : NameStr;            (* User alias                       *)
           City    : CityStr;            (* User city                        *)
           Bpsrate : SmallWord;               (* Bps rate div 100                 *)
           Age     : Byte;               (* Age                              *)
           Node    : Byte;               (* Node                             *)
           LogOn   : DateTimeRec;        (* Logon time in UNIX format        *)
           LogOff  : DateTimeRec;        (* Logoff time in UNIX format       *)
           ShowSec : Security;           (* Min security to see user         *)
           Attrib  : Byte;               (* Bitmapped attributes             *)
         end;

(* .......................NODE STATUS INFORMATION .......................... *)

         NodesRecord = Record
           Name     : NameStr;                 (* User name                  *)
           Alias    : NameStr;                 (* User alias                 *)
           City     : CityStr;                 (* User city                  *)
           Bpsrate  : SmallWord;                    (* Bps rate div 100           *)
           Age      : Byte;                    (* Age                        *)
           LogOn    : DateTimeRec;             (* Logon time in UNIX format  *)
           ShowSec  : Security;                (* Min security to see user   *)
           Attrib   : Byte;                    (* Attributes (see LAST...)   *)
           Status   : Byte;                    (* Currently doing            *)
           Info     : ANameStr;                (* More about status          *)
           NodeStat : Byte;                    (* Node attributes            *)
         end;

(* ..........................SYSTEM USAGE CHART............................. *)

         UsageRec = Record                 (* USAGE<node>.DAT                *)
           Date: DateRec;                  (* Date for this record           *)
           Usage: Array [1..180] of Byte;  (* Bit mapped; bit / minute / day *)
         end;

(* ........................MULTINODE CHAT .................................. *)

(* MULCHAT.TXT format :                                            *)
(* first four bytes (longint) is current write file position (WFP) *)
(* WFP wraps to 0 after 64K                                        *)
(* all lines are saved in pure ASCII after WFP                     *)
(* "<areanum> [@<notshownick>] * <nick> does something"                             *)
(* "<areanum> [@<notshownick>] /<tonick> ! <nick>: private mail"   *)
(* "<areanum> [@<notshownick>] <nick>: normal text"                *)
(* "<areanum> [@<notshownick>] #information"                       *)

  MultiChatAreaRec = Record (* commonpath\MULCHAT.DAT *)
    Attrib:  LongInt;
    Name:    NameStr;
    Users:   LongInt;
    Title:   ANameStr;
  end;

(* ........................VOTE QUESTIONS & ANSWERS FILE ................... *)

       const

         VOTEQUES_SELECT  = $00000001; (* Y: Vote can only be for or against *)
                                       (* N: Share points between answers    *)
         VOTEQUES_ADDASW  = $00000002; (* User can add answers               *)
         VOTEQUES_CHGVOTE = $00000004; (* User can change his vote later     *)
         VOTEQUES_TOTALS  = $00000008; (* User can see results before voting *)

       type

         VoteQuestionRecord = Record         (* VOTE QUESTION RECORD         *)
           Question:            String;      (* Question string              *)
           AddedBy:             NameStr;     (* Who added this question      *)
           UnixDate:            DateTimeRec; (* When added this question     *)
           Attrib:              LongInt;     (* Attributes (see VOTEQUES...) *)
           PointsToShare:       Byte;        (* Points to share              *)
           MaxAnswersToShare:   Byte;        (* Max answers to share points  *)
           CurrentAnswersCount: Byte;        (* Current answers count        *)
           CurrentUsersCount:   LongInt;     (* Number of users answered     *)
           VoteSecurity:        Security;    (* Min security to see question *)
           EmptySpace:          Array [1..168] of Byte;
         end;                                (* Size 500 bytes               *)

         VoteAnswerRecord = Record           (* VOTE ANSWER RECORD           *)
           Answer:        ANameStr;          (* Answer string                *)
           SelectedCount: LongInt;           (* Number of votes/points       *)
           Attrib:        Byte;              (* ... not yet used ...         *)
           AddedBy:       LongInt;           (* CRC-32 of adder's name       *)
           UnixDate:      DateTimeRec;       (* When added this answer       *)
           EmptySpace:    Array [1..26] of Byte;
         end;                                (* Size 100 bytes               *)

         VoteUserRecord = Record
           NameCRC32:    LongInt;            (* Who answered; CRC-32 of name *)
           VoteDateTime: DateTimeRec;        (* When answered                *)
           Attrib:       SmallWord;               (* ... not yet used ...         *)
           Points:    Array [1..99] of Byte; (* Points shared; size DYNAMIC! *)
         end;                                (* Size VARIES (see later...)   *)

           (* VUR.Points field size is equal to VQR.CurrentAnswersCount but *)
           (* rounded up to next tens; for example 5 answers -> 10 points.  *)
           (* This makes VoteUserRecord record size dynamical.              *)
           (*                                                               *)
           (* Each vote question is located in file named as VOTExxxx.DAT   *)
           (* where xxxx is question number. Also answers and users are     *)
           (* stored in the same file.                                      *)
           (*                                                               *)
           (* Vote file format :                                            *)
           (*    VoteQuestionRecord                                         *)
           (*    VoteAnswerRecord [1]                                       *)
           (*    ...                                                        *)
           (*    VoteAnswerRecord [VQR.CurrentAnswersCount]                 *)
           (*    VoteUserRecord [1]                                         *)
           (*    ...                                                        *)
           (*    VoteUserRecord [VQR.CurrentUsersCount]                     *)
           (*                                                               *)
           (* For example, a question file with 10 possible answers and     *)
           (* 1000 voted users take disk space as the following :           *)
           (* 500 + 10 * 100 + 1000 * 20 = 21500 bytes                      *)

(*****************************************************************************)
(*                                                                           *)
(*                     S Y S T E M   C O N F I G U R A T I O N               *)
(*                                                                           *)
(*****************************************************************************)

       const

         ID_CFG       = ID_VER or $00030000;
         ID_CFG_HDR   = ID_CFG or $01000000;
         ID_CFG_REC   = ID_CFG or $02000000;
         ID_CFG_DOOR  = ID_CFG or $03000000;
         ID_CFG_FAREA = ID_CFG or $04000000;
         ID_CFG_MAREA = ID_CFG or $05000000;
         ID_CFG_LIMIT = ID_CFG or $06000000;
         ID_CFG_EVENT = ID_CFG or $07000000;
         ID_CFG_PROTO = ID_CFG or $08000000;
         ID_CFG_ARC   = ID_CFG or $09000000;
         ID_CFG_EDIT  = ID_CFG or $0A000000;
         ID_CFG_VIEW  = ID_CFG or $0B000000;
         ID_CFG_CHSET = ID_CFG or $0C000000;

         ID_LNG_HDR   = ID_CFG or $10000000;

         MODEM_ANSWER_MANUAL   = $01; (* Bit 0 - Force manual answer to call *)
         MODEM_LOWERDTR_BUSY   = $02; (* Bit 1 - Lower DTR when busy         *)
         MODEM_LOWERDTR_HANGUP = $04; (* Bit 2 - Lower DTR to terminate call *)
         MODEM_LOCKED          = $08; (* Bit 3 - Locked BPS rate             *)
         MODEM_NOHANGUP        = $10; (* Bit 4 - Force no hangup             *)
         MODEM_WAIT_EACH_WRITE = $20; (* Bit 5 - Flush after write at 2400<  *)

         MSG_LOCAL_CHECK_WHOTO = $01; (* Bit 0 - Local msgs, local userbase  *)
         MSG_QUICKSCAN_CURSOR  = $02; (* Bit 1 - Msg header needed in cursor *)
         MSG_QUICKSCAN_FASTEND = $04; (* Bit 2 - Fast jump to end of msgs    *)
         MSG_ALLOW_MACROS      = $08; (* Bit 3 - Allow macro strings in msgs *)
         MSG_UPDOWN_NOCHGMSG   = $10; (* Bit 4 - Up/Down does not change msg *)
         MSG_REDRAW_HDRLINES   = $20; (* Bit 5 - Redraw headers in msg read  *)
         MSG_REMOVE_AFTER_TAG  = $40; (* Bit 6 - Remove empty lines after tag*)
         MSG_GROUP_MAIL_DATE   = $80; (* Bit 7 - Group mail date check       *)
         MSG_CREATE_PID_TEAR   =$100; (* Bit 8 - Create both PID & Tear line *)
         MSG_IGNORE_SOFTCR     =$200; (* Bit 9 - Do not touch to ASCII141    *)
         MSG_ADD_NEW_AREAS     =$400; (* Bit10 - Auto add new areas for user *)
         MSG_AUTO_QUOTE        =$800; (* Bit11 - Autoquote in internal editor*)
         MSG_SAVE_DISCONNECT  =$1000; (* Bit12 - Auto save in internal editor if disconnected *)
         MSG_KLUDGES_TO_PKT   =$2000; (* Bit13 - Put kludges to mail packet  *)
         MSG_VERIFY_NET_PKT   =$4000; (* Bit14 - Verify dest address in offline pkt netmails *)
         MSG_ECHO_ALLOW_SYSOP =$8000; (* Bit15 - Allow msgs to Sysop in echo areas *)

         FILE_CHECK_OFFLINE    = $01; (* Bit 0 - Check if files are offline  *)
         FILE_IMPORT_DIZ       = $02; (* Bit 1 - Import FILE_ID.DIZ etc      *)
         FILE_SPARE_MEMORY     = $04; (* Bit 2 - With FILES.BBS files,       *)
                                      (*         pre-scan download directory *)
                                      (*         before displaying file list *)
         FILE_SPLIT_DESC       = $08; (* Bit 3 - Allow splitting filedescs   *)
         FILE_NO_UNPACK        = $10; (* Bit 4 - Don't unpack uploaded files *)
         FILE_SCANCDROM        = $20; (* Bit 5 - Use FindFirst to CDROMs?    *)
         FILE_DL_FILEDESC      = $40; (* Bit 6 - Allow download file descs   *)
         FILE_NOUPDDLCNTR      = $80; (* Bit 7 - Don't update dl cntrl in FILES.BBS *)
         FILE_STAMP_UPLOADS    =$100; (* Bit 8 - Touch uploaded files date   *)
         FILE_DUPE_NO_EXT      =$200; (* Bit 9 - No file exts in dupe check  *)
         FILE_NO_DUPE_KILL     =$400; (* Bit10 - Don't kill dupe uploads     *)
         FILE_KEEP_TAGGED_LIST =$800; (* Bit11 - Keep user's tagged files in *)
                                      (*         UserTagsPath after logoff   *)
         FILE_CHK_DUPE_ALLAREA=$1000; (* Bit12 - Dupe check areas where user *)
                                      (*         doesn't have any rights too *)
         FILE_ASKBEFOREUPLOAD =$2000; (* Bit13 - Ask filenames&descriptions  *)
                                      (*         in upload before transfer   *)
         FILE_ADD_NEW_AREAS   =$4000; (* Bit14 - Auto add new areas for user *)
         FILE_HIDE_UPLOADS    =$8000; (* Bit15 - Mark uploads as hidden by default *)
         FILE_AUTOSTOPLISTING=$10000; (* Bit16 - Stop filelist in the end *)

         OTHERS_DORINFONDEF    = $0001; (* Bit 0-Use node number in DORINFO? *)
         OTHERS_SCREENLEN      = $0002; (* Bit 1-Try to detect screen len    *)
         OTHERS_ERASEMULCHAT   = $0004; (* Bit 2-Erase MULCHAT.DAT after use *)
         OTHERS_FORCEANSI      = $0008; (* Bit 3-Force ANSI if ASCII detected*)
         OTHERS_NODETECTVIDEO  = $0010; (* Bit 4-Do not detect user termemul *)
         OTHERS_NOCHATLOG      = $0020; (* Bit 5-Do not keep CHAT.LOG        *)
         OTHERS_NOUSERCHATEXIT = $0040; (* Bit 6-User cannot exit chat       *)
         OTHERS_ENVVAR_PATHS   = $0080; (* Bit 7-Convert $ENVVAR in paths    *)
         OTHERS_NOLOCALCALL    = $0100; (* Bit 8-Exclude local in system calls *)
         OTHERS_ECHOCHAR       = $0200; (* Bit 9-Echo pressed char in ^W;    *)
         OTHERS_CMDLINE_CTRLX  = $0400; (* Bit10-Accept Ctrl-x hotkey codes in cmdline mode *)
         OTHERS_CMNTTONEXTUSER = $0800; (* Bit11-If set, comment to next user will be shared between all nodes *)
         OTHERS_CHATLOGTOMAIN  = $1000; (* Bit12-Create chat log to system path instead of node path *)
         OTHERS_ALLOWMACROEDIT = $2000; (* Bit13-Allow ^]! sequences in ANSI files *)
         OTHERS_AUTOSETCURSOR  = $4000; (* Bit14-Automatic set cursor pos in menu to end of screen *)
         OTHERS_NODETECTIEMSI  = $8000; (* Bit15-Do not detect IEMSI         *)
         OTHERS_NEXTHIGHESTSEC =$10000; (* Bit16-If user sec is not found in limits, use next highest sec found *)

         LOG_IEMSI             = $0001; (* Bit 0 - Log IEMSI strings *)

         DOOR_ACTIVE     = $0001;        (* Bit 0 - Active?                  *)
         DOOR_JUMP       = $0002;        (* Bit 1 - CmdLine = New area list! *)
         DOOR_ALLGROUPS  = $0004;        (* Bit 2 - Visible in all groups    *)

{ok}     FAREA_ACTIVE    = $0001; (* Bit 0 - Active?                         *)
{ok}     FAREA_NEWFILES  = $0002; (* Bit 1 - Include in new files check      *)
         FAREA_DEFAULT   = $0004; (* Bit 2 - Tagged by default               *)
{ok}     FAREA_DUPECHK   = $0008; (* Bit 3 - Include upload dupe check       *)
{ok}     FAREA_VIRUSCHK  = $0010; (* Bit 4 - Include upload virus check      *)
         FAREA_FREE      = $0020; (* Bit 5 - All files are free              *)
{ok}     FAREA_CDROM     = $0040; (* Bit 6 - CD-ROM area (ie. READONLY)      *)
         FAREA_NOLISTREQ = $0080; (* Bit 7 - Allow dl files not in file list *)
{ok}     FAREA_JUMP      = $0100; (* Bit 8 - Link to another area list       *)
{ok}     FAREA_FILESBBS  = $0200; (* Bit 9 - Force FILES.BBS                 *)
{ok}     FAREA_OFFLINE   = $0400; (* Bit10 - Force all files offline         *)
         FAREA_ALLGROUPS = $0800; (* Bit11 - Visible in all groups           *)
         FAREA_COPYCDROM = $1000; (* Bit12 - Copy files to temp dir before download *)

{ok}     MAREA_ACTIVE       = $0001; (* Bit 0 - Active?                   *)
{ok}     MAREA_DELETE       = $0002; (* Bit 1 - Allow deleting messages   *)
         MAREA_TAGLINE      = $0004; (* Bit 2 - Allow tag lines           *)
         MAREA_FATTACH      = $0008; (* Bit 3 - Allow file attaches       *)
         MAREA_SELECT       = $0010; (* Bit 4 - Allow selecting from list *)
         MAREA_CTRLCHAR     = $0020; (* Bit 5 - Allow control chars       *)
         MAREA_DEFAULT      = $0040; (* Bit 6 - Tagged by default         *)
         MAREA_MAILCHK      = $0080; (* Bit 7 - Force mail check          *)
         MAREA_ORIGIN       = $0100; (* Bit 8 -                           *)
{ok}     MAREA_JUMP         = $0200; (* Bit 9 - PathName = New area list! *)
         MAREA_FORCEQUOTECR = $0400; (* Bit10 - ..temporal..              *)
         MAREA_FOLLOWAREA   = $0800; (* Bit11 - Force combined area       *)
         MAREA_RECEIPT      = $1000; (* Bit12 - Ask if user wants receipt *)
         MAREA_NOKLUDGES    = $2000; (* Bit13 - Kludges are not displayed even if user wants so *)
         MAREA_ALLGROUPS    = $4000; (* Bit14 - Visible in all groups     *)

         MAREAFMT_HMB    = $0000;                                 (* Hudson  *)
         MAREAFMT_JAM    = $0001;                                 (* JAM     *)
         MAREAFMT_MSG    = $0002;                                 (* .MSG    *)
         MAREAFMT_SQUISH = $0003;                                 (* Squish  *)

         MAREATYPE_LOCAL = $0000;                              (* Local area *)
         MAREATYPE_ECHO  = $0001;                              (* Echo area  *)
         MAREATYPE_NET   = $0002;                              (* Net mail   *)

         MAREAKIND_BOTH  = $0000;        (* Both public and private messages *)
         MAREAKIND_PRIV  = $0001;        (* Only private messages            *)
         MAREAKIND_PUB   = $0002;        (* Only public messages             *)
         MAREAKIND_RO    = $0003;        (* Read-only                        *)

         MAREAREPLY_BOTH = $0000;                   (* Net or normal replies *)
         MAREAREPLY_NET  = $0001;                   (* Only net replies      *)
         MAREAREPLY_NORM = $0002;                   (* Only normal replies   *)
         MAREAREPLY_NONE = $0003;                   (* No replies            *)

         MAREAALIAS_BOTH = $0000;                      (* Real name or alias *)
         MAREAALIAS_YES  = $0001;                      (* Only aliases       *)
         MAREAALIAS_NO   = $0002;                      (* Only real names    *)
         MAREAALIAS_ASK  = $0003;                      (* Ask for alias      *)

         LIMIT_ACTIVE    = $0001;                         (* Bit 0 - Active? *)

         EVENT_ACTIVE    = $0001;                       (* Bit 0 - Active?   *)
         EVENT_FORCED    = $0002;                       (* Bit 1 - Forced?   *)
         EVENT_TODAY     = $0004;                       (* Internal flag     *)

         EVENTDAY_SUN    = $0001;                       (* Bit 0 - Sunday    *)
         EVENTDAY_MON    = $0002;                       (* Bit 1 - Monday    *)
         EVENTDAY_TUE    = $0004;                       (* Bit 2 - Tuesday   *)
         EVENTDAY_WED    = $0008;                       (* Bit 3 - Wednesday *)
         EVENTDAY_THU    = $0010;                       (* Bit 4 - Thursday  *)
         EVENTDAY_FRI    = $0020;                       (* Bit 5 - Friday    *)
         EVENTDAY_SAT    = $0040;                       (* Bit 6 - Saturday  *)

         PROTOCOL_NONE   =    #0;

         PROTOCOL_ACTIVE = $0001;        (* Bit 0 - Active?                  *)
         PROTOCOL_BATCH  = $0002;        (* Bit 1 - Batch transfers?         *)
         PROTOCOL_BIDIR  = $0004;        (* Bit 2 - Bidirectional transfers? *)
         PROTOCOL_ALLLOG = $0008;        (* Bit 3 - Read DSZ.LOG from start  *)

         ARCHIVE_ACTIVE  = $0001;                         (* Bit 0 - Active? *)

         EDITOR_ACTIVE   = $0001;                         (* Bit 0 - Active? *)

         CHARSET_ACTIVE  = $0001;              (* Bit 0 - Active?            *)
         CHARSET_INPUT   = $0002;              (* Bit 1 - Also modify input? *)

         FILELIST_DELETED   = $01;
         FILELIST_SYSOPONLY = $02;
         FILELIST_OFFLINE   = $04;
         FILELIST_UNLISTED  = $08;

         USERCFG_ONEWORDNAMES = $01;   (* allow one word names for new users *)
         USERCFG_INCLUDESYSOP = $02;   (* in "last callers" list             *)
         USERCFG_HIDEUPPERSEC = $04;   (* in "who is on" list                *)

         (* The following flags are only used by CSETUP internally. If flag  *)
         (* is turned on, equivalent information is copied from common       *)
         (* config file when saving node config file and editing such        *)
         (* information is not possible.                                     *)

         COMMON_SYSINFO = $0001;      (* Bit 0 - System information          *)
         COMMON_MODEM   = $0002;      (* Bit 1 - Special modem settings      *)
         COMMON_PATH    = $0004;      (* Bit 2 - Paths                       *)
         COMMON_MSG     = $0008;      (* Bit 3 - Msg system                  *)
         COMMON_FILE    = $0010;      (* Bit 4 - File system                 *)
         COMMON_USER    = $0020;      (* Bit 5 - User config                 *)
         COMMON_NETADDR = $0040;      (* Bit 6 - Net addresses               *)
         COMMON_LIMIT   = $0080;      (* Bit 7 - Limits                      *)
         COMMON_EVENT   = $0100;      (* Bit 8 - Events                      *)
         COMMON_PROTO   = $0200;      (* Bit 9 - Transfer protocols          *)
         COMMON_ARCHIVE = $0400;      (* Bit10 - File archivers              *)
         COMMON_EDITOR  = $0800;      (* Bit11 - Full screen message editors *)
         COMMON_CHARSET = $1000;      (* Bit12 - Charsets                    *)
         COMMON_OTHER   = $2000;      (* Bit13 - Macros + Other settings     *)

         THREAD_FILELIST = $0001;     (* Bit 0 - Background file list scan *)
         THREAD_MAILSCAN = $0002;     (* Bit 1 - Background mail scan *)
         THREAD_OFFLINE  = $0004;     (* Bit 2 - Background create offline msg pkt *)
         THREAD_MAREASTAT= $0008;     (* Bit 3 - Background view msg area stats *)
         THREAD_SETAREAS = $0010;     (* Bit 4 - Background change area settings *)
         THREAD_UPLOAD   = $0020;     (* Bit 5 - Background upload processing *)
         THREAD_TEMPDIR  = $0040;     (* Bit 6 - Background tempdir pack/unpack *)
         THREAD_DLFLIST  = $0080;     (* Bit 7 - Background download filelist *)
         THREAD_BBSLIST  = $0100;     (* Bit 8 - Background download BBS list *)

       type

         ConfigHdr = Record      (* CONFIG.DAT - Config file - Main header   *)
           Id        : LongInt;  (* Always ID_CFG_HDR                        *)
           Version   : LongInt;  (* Version number                           *)
           CfgSize   : SmallWord;(* Size of config record in bytes           *)
           Cfg2Size  : SmallWord;(* Size of config record additions in bytes *)
           DoorSize  : SmallWord;(* Size of door record in bytes             *)
           FAreaSize : SmallWord;(* Size of file area record in bytes        *)
           MAreaSize : SmallWord;(* Size of message area record in bytes     *)
           LimitSize : SmallWord;(* Size of security limit record in bytes   *)
           EventSize : SmallWord;(* Size of event record in bytes            *)
           ProtoSize : SmallWord;(* Size of transfer protocol record in bytes*)
           ArcSize   : SmallWord;(* Size of archive record in bytes          *)
           EditSize  : SmallWord;(* Size of FS editor record in bytes        *)
           ChSetSize : SmallWord;(* Size of char set record                  *)
           Doors     : LongInt;  (* Number of doors in system                *) (* RESERVED *)
           FAreas    : LongInt;  (* Number of file areas in system           *) (* RESERVED *)
           MAreas    : LongInt;  (* Number of message areas in system        *) (* RESERVED *)
           Limits    : LongInt;  (* Number of security limits in system      *) (* RESERVED *)
           Events    : LongInt;  (* Number of events in system               *) (* RESERVED *)
           Protos    : LongInt;  (* Number of transfer protocols in system   *) (* RESERVED *)
           Archives  : LongInt;  (* Number of archivers in system            *) (* RESERVED *)
           Editors   : LongInt;  (* Number of FS editors in system           *) (* RESERVED *)
           CharSets  : LongInt;  (* Number of possible char sets             *) (* RESERVED *)
         end;

         NetAddrRec = Record
           Addr        : NetRec;
           NetmailArea : LongInt;
         end;

         RegInfoCfg = Record
           BBS         : NameStr;
           Sysop       : NameStr;
           Empty       : Array [1..8] of Byte;
           Location    : NameStr;                 (* BBS location            *)
           PhoneNumber : PhoneStr;                (* BBS phone number        *)
           BBSID       : String [8];              (* BBS ID - QWK file name  *)
           BBSID2      : String [2];              (* BBS ID - OMEN file name *)
         end;

{#chgd#} ModemCfg = Record
           ModemPort    : Byte;
           InitRate     : SmallWord;
           InitTimes    : Byte;
{#ANameStr}InitStr      : String;   (* ATZ|~~~     *)
           OnHookStr    : DefStr;   (* ATH0|       *)
           OffhookStr   : DefStr;   (* ATH1|       *)
           ResetStr     : DefStr;   (* AT|         *)
           NoCarrierStr : DefStr;   (* NO CARRIER| *)
           OkStr        : MenuStr;  (* OK|         *)
           RingStr      : MenuStr;  (* RING|       *)
           EscapeCode   : MenuStr;  (* +++         *)
           Attrib       : Byte;
{#NameStr} AswStr       : String;   (* ATA|        *)
           InitDelay    : Byte;
           EscapeDelay  : Byte;
           DialTimes    : Byte;
           DialLength   : Byte;
           DialStr      : DefStr;
           HiSpeedRep   : Byte;     (* Wait n*0.1s after ANSI req (9600>) *)
           LoSpeedRep   : Byte;     (* Wait n*0.1s after ANSI req (9600<) *)
           AswTimeFrom  : TimeRec;
           AswTimeTo    : TimeRec;
           ResponseCnt  : Byte;
          {n x ModemResponseRec}
         end;

         ModemResponseRec = Record     (* 300, 1200, 2400, 4800, 7200, 9600, *)
           Speed    : SmallWord;       (* 12000, 14400, 16800, 19200, 21600, *)
           Response : ANameStr;        (* 24000, 26400, 28800, ..., 115200   *)
           ErrLvl   : Byte;            (* If nonzero, exit with this errlvl  *)
         end;

         PathCfg = Record
           Chat            : PathStr;        (* External chat utility        *)
           FileViewer      : PathStr;        (* External file viewer         *)
           VirusScanner    : PathStr;        (* External virus scanner       *)
           CommonPath      : DirStr;         (* Multinode common directory   *)
           SwapPath        : DirStr;         (* Swap directory               *)
           TempPath        : DirStr;         (* Temp directory               *)
           WorkPath        : DirStr;         (* Work directory               *)
           NodeListPath    : DirStr;         (* Nodelist directory           *)
           LocalAttachPath : DirStr;         (* Local file attach directory  *)
           FilebasePath    : DirStr;         (* Filebase directory           *)
          {SystemPath      : DirStr;}        (* SET BBS=                     *)
          {MenuPath        : DirStr;}        (* Language File                *)
          {TextPath        : DirStr;}        (* Language File                *)
         end;

         MsgCfg = Record
           QuoteStr : GroupStr;              (* "PT>"                        *)
           Attrib   : LongInt;               (* Msg configuration attributes *)
           GroupSec : SmallWord;             (* Sec to send group messages   *)
           BadMsgs  : LongInt;               (* Bad msgs board               *)
           MinSpace : SmallWord;             (* Min space to export msgs     *)
           DefOrigin: ANameStr;              (* Default origin line          *)
           MaxMsgs  : SmallWord;             (* Max msgs to export           *)
           MaxLines : SmallWord;             (* Max lines in offline msg     *)
           DupeSize : SmallWord;             (* Max size of dupe msg list    *)
           ReadMarg : Byte;                  (* 0=default marginal           *)
           QuoteMarg: Byte;                  (* 0=default marginal           *)
           OfflineSec : Security;            (* Min sec to pack msgs offline *)
           NetArea  : LongInt;               (* Net mail area number         *)
           QuoteStr2: GroupStr;              (* quote string for quoted lines*)
           Empty    : Array [1..390] of Byte;
         end;

         FileCfg = Record
           Attrib   : LongInt;              (* File configuration attributes *)
           CheckRatioFiles : Byte;          (* Start checking ratio after n downloaded files *)
           DLcounter: Byte;                 (* Bit 0,1: 00=(, 01=[, 10=<     *)
                                            (* Bit 2,3: counter length       *)
                                            (*     00=none, 01=2, 02=3, 03=4 *)
           FiledescLines: Byte;             (* Max num of file desc lines    *)
           NukedPath: DirStr;               (* Where to move unwanted files; empty=kill file *)
           MinSpace : SmallWord;            (* Min space to allow uploads    *)
           CheckRatioFiles2 : Byte;         (* Check after every n files if  *)
                                            (* user can still DL more files  *)
                                            (* in download menutype prompt   *)
           Empty    : Array [1..422] of Byte;
         end;

         UserCfg = Record
           FlagDesc   : Array [1..MAX_FLAG, 1..8] of String [40];
           Attrib     : LongInt;
           ExpireDays : SmallWord;
           VerifyCalls: Byte;
           PasswdTries: Byte;
           PwdCRCtype : Byte; (* How to calculate password-CRC from password string: 0=uppercase, 1=lowercase, 2=normal *)
           Empty      : Array [1..491] of Byte;
         end;

         ColorCfg = Record
           DefaultColor: Byte;
           ChatHeader:   Byte;
           ChatSysop:    Byte;
           ChatUser:     Byte;
           Bottomline:   Byte;
           Empty    : Array [1..499] of Byte;
         end;

         OtherCfg = Record
           LocalColors   : Boolean;    (* TRUE if colors are shown locally . *)
           SysopSecurity : Security;   (* To access Sysop filebase functions *)
           ShellToDos    : PathStr;    (* Cmd line to shell to DOS ......... *)
           YellDevice    : Byte;       (* Yelling device, 0=none ........... *)
           MaxYellTimes  : Byte;       (* Max yell times per day ........... *)
           MaxYellLen    : Byte;       (* Max yell sound length ............ *)
           YellStart     : Array [0..6] of SmallWord; (* Yell start time ... *)
           YellStop      : Array [0..6] of SmallWord; (* Yell stop time .... *)
           LocalPassword : PassStr;    (* Local keyboard password .......... *)
           FrontEndExec  : Array [1..10] of PathStr; (* Ctrl-F1..F10 execs . *)
           TimeOut       : SmallWord;  (* Keyboard time out in seconds ..... *)
           MaxLogInTime  : Byte;       (* Max login time in minutes ........ *)
           ScrBackSize   : SmallWord;  (* Scroll back buffer size in KB .... *)
           OnlineMsgChk  : Byte;       (* Check online msgs every n seconds  *)
           NodeNumber    : Byte;       (* Current node number .............. *)
           MinLastCaller : SmallWord;  (* Minimum size of LASTCALL.DAT ..... *)
           KeyboardMacro : Array [1..10] of ANameStr; (* Sh-F1..F10 macros . *)
           AsstSysopName : NameStr;
           VerifyBBSdays : SmallWord;  (* Verify BBS every n days .......... *)
           Attrib        : LongInt;
           JAMbasePath   : DirStr;     (* Where to hold ECHO/NETMAIL.JAM ... *)
           DefLocalMovePath: DirStr;
           LoginCharSet  : Byte;
           ChkMulchatTime: Byte; (* How often check MULCHAT.DAT, 0=when chgd *)
           HiddenChar    : Char;       (* Char used in hidden fields ("*")   *)
           AnsiStopChars : MenuStr;    (* Chars to abort displaying ANSI scr *)
           LngPath       : DirStr;
           CtlPath       : DirStr;
           Own_Com_Base  : SmallWord;
           Own_Com_Irq   : SmallInt;
           Own_Com_Int   : SmallInt;
           VotePath      : DirStr;
           CheckEventCounter: Byte;
           ModemANSIbufsize: SmallWord;
           StatusLine    : Array [1..6] of String [100];
           ModemResetCnt : Byte;
           ScrSaverCnt   : Byte;
           UserTagsPath  : DirStr;
           WaitAswTime   : Byte;       (* Secs to wait for CONNECT response  *)
           CommonSetup   : LongInt;    (* bitmapped, see COMMON_xxx          *)
           ThreadOptions : LongInt;    (* bitmapped, see THREAD_xxx          *)
           CallerIDstr   : DefStr;
           SquishEchoTossLog: PathStr;
           LogPath       : DirStr;
           LogOptions    : LongInt;
           Empty         : Array [1..744] of Byte;
         end;

         ConfigRec = Record                    (* CONFIG.DAT - Config record *)
           Id        : LongInt;                (* Always ID_CFG_REC          *)
           RegInfos  : RegInfoCfg;
           Modems    : ModemCfg;
           Paths     : PathCfg;
           Msgs      : MsgCfg;
           Files     : FileCfg;
           Users     : UserCfg;
           Colors    : ColorCfg;
           Others    : OtherCfg;
           NetCnt    : Byte;
          {n x NetAddrRec}             (* Size included in ConfigHdr.CfgSize *)
         end;

         LimitRecord = Record        (* CONFIG.DAT - Sec limit entry         *)
           Id        : LongInt;      (* Always ID_CFG_LIMIT                  *)
           Attrib    : Byte;         (* Limits attributes                    *)
           SecLvl    : SmallWord;    (* Current security level               *)
           Name      : ANameStr;     (* Security limit description           *)
           ValidFrom : TimeRec;      (* Starting time in minutes after 00:00 *)
           ValidTo   : TimeRec;      (* Ending time in minutes after 00:00   *)
           RatioK    : SmallWord;    (* Maximum DL/UL KB ratio               *)
           Ratio     : SmallWord;    (* Maximum DL/UL files ratio            *)
           TmLimit   : SmallWord;    (* Time limit in minutes                *)
           ClLimit   : Byte;         (* Call limit                           *)
           Downlimit : LimitBpsType; (* Download limit in kilobytes          *)
           Filelimit : LimitBpsType; (* Download limit in files              *)
         end;

         EventRecord = Record        (* CONFIG.DAT - Event entry             *)
           Id          : LongInt;    (* Always ID_CFG_EVENT                  *)
           Attrib      : Byte;       (* Event attributes                     *)
           Days        : Byte;       (* Days to run, bitmapped               *)
           RunTime     : TimeRec;    (* Running time in minutes after 00:00  *)
           ErrorLevel  : Byte;       (* Drop to DOS with error level         *)
           LastRun     : DateRec;    (* Last run time                        *)
         End;

{#chgd#} ProtocolRecord = Record         (* CONFIG.DAT - Protocol entry      *)
           Id           : LongInt;       (* Always ID_CFG_PROTO              *)
           Attrib       : Byte;          (* Protocol attributes              *)
           Name         : DefStr;        (* Short definition for protocol    *)
           Key          : Char;          (* Key to select protocol           *)
{#PathStr} DownloadCmd  : String;        (* Cmd line needed to transmit file *)
{#PathStr} UploadCmd    : String;        (* Cmd line needed to receive file  *)
           ListChar     : Char;          (* List indicator                   *)
           Efficiency   : Byte;          (* Transfer efficiency in percents  *)
           LogFileType  : Byte;          { 0=OTHER,1=ICOM,2=DSZ               }
           ProtocolType : Byte;          { 0=other,1=opus,2=BIMODEM           }
           LogFileName  : PathStr;
           CtlFileName  : PathStr;
           UpLogKeyword : DefStr;
           DnLogKeyword : DefStr;
           DescWordNr   : Byte;
           NameWordNr   : Byte;
           DnCtlString  : ANameStr;
           UpCtlString  : ANameStr;
         end;

         ArchiveRecord = Record          (* CONFIG.DAT - Archive entry       *)
           Id           : LongInt;       (* Always ID_CFG_ARC                *)
           Attrib       : Byte;          (* Archive attributes               *)
           Extension    : ExtStr;        (* File extension for this archive  *)
           Name         : DefStr;        (* Short definition for archive     *)
           Key          : Char;          (* Key to select this archive       *)
           Compress     : PathStr;       (* Cmd line to compress file        *)
           Uncompress   : PathStr;       (* Cmd line to uncompress file      *)
           ListChar     : Char;          (* List indicator                   *)
           Efficiency   : Byte;          (* (PackedSize/OrigSize) %          *)
           ArchiveId    : NameStr;       (* Archive ID                       *)
         end;

         EditorRecord = Record           (* CONFIG.DAT - FS Editor entry     *)
           Id           : LongInt;       (* Always ID_CFG_EDIT               *)
           Attrib       : Byte;          (* Editor attributes                *)
           Name         : DefStr;        (* Short definition for editor      *)
           Key          : Char;          (* Key to select this editor        *)
           CmdLine      : PathStr;       (* Cmd line to start editor         *)
         end;

         CharSetRecord = Record                   (* CONFIG.DAT - Char set   *)
           Id           : LongInt;                (* Always ID_CFG_CHSET     *)
           Attrib       : Byte;                   (* Char set attributes     *)
           Name         : DefStr;                 (* Short definition        *)
           Key          : Char;                   (* Key to select           *)
           Table        : Array [0..255] of Char; (* Char Convertion Table   *)
           KludgeLabel  : DefStr;                 (* Label to CHARSET kludge *)
         end;

{#chgd#} MenuRecord = Record
           Cmd   : SmallWord;                 (* Menu command                *)
           Sec   : Security;                  (* Security required           *)
           Key   : SmallInt;                  (* Hot key to run command      *)
           Input : DefStr;                    (* Input string to run command *)
{#PathStr} Data  : String;                    (* Command parameters          *)
         End;

         GosubRecord = Array [1..MAX_GOSUB] of MenuStr;   (* Gosub menu list *)

         DoorRec = Record        (* Door entry                               *)
    {000}  Id       : LongInt;   (* Always ID_CFG_DOOR                       *)
    {004}  Attrib   : Byte;      (* Door attributes                          *)
    {005}  Name     : ANameStr;  (* Door name                                *)
    {066}  Group    : GroupStr;  (* Door group                               *)
    {070}  CmdLine  : PathStr;   (* Command line to run door                 *)
    {150}  Sec      : Security;  (* Security required to select and run door *)
    {175}  PassWord : PassStr;   (* Password required to enter door          *)
    {191}  OpenFrom : TimeRec;   (* Door opening time in minutes after 00:00 *)
    {193}  OpenTo   : TimeRec;   (* Door closing time in minutes after 00:00 *)
    {195}  SubDirNum: SmallWord; (* Current subdirectory number              *)
    {197}  JumpDirNum:SmallWord; (* If DOOR_JUMP, where to jump              *)
         end;

         FAreaRec = Record          (* File area entry                       *)
    {000}  Id           : LongInt;  (* Always ID_CFG_FAREA                   *)
    {004}  Attrib       : LongInt;  (* File area attributes.                 *)
    {008}  Name         : ANameStr; (* File area name.                       *)
    {069}  DownloadSec  : Security; (* Sec needed to download files.         *)
    {094}  UploadSec    : Security; (* Sec needed to upload files.           *)
    {119}  FileListSec  : Security; (* Sec needed to list files.             *)
    {144}  Password     : PassStr;  (* Password needed to enter file area.   *)
    {160}  DownloadPath : DirStr;   (* Download path.                        *)
    {228}  Basename     : MenuStr;  (* Filebase file name w/out extension    *)
    {237}  EmptySpace   : Array [1..51] of Byte;
    {288}  SubDirNum    : SmallWord;(* Current subdirectory number           *)
    {290}  JumpDirNum   : SmallWord;(* If FAREA_JUMP, where to jump          *)
    {292}  UploadArea   : LongInt;  (* If empty : Current area               *)
    {296}  Group        : GroupStr; (* Filearea group                        *)
    {300}  ArchiveFmt   : Byte;     (* Convert files to this archive format. *)
    {301}  KillDaysDL   : SmallWord;(* Kill file if not dl'd in last n days. *)
    {303}  KillDaysFD   : SmallWord;(* Kill file if older than n days.       *)
    {305}  FilePoints   : SmallWord;(* Default file points per file dl'd.    *)
    {307}  OpenFrom     : TimeRec;  (* Opening time in minutes after 00:00   *)
    {309}  OpenTo       : TimeRec;  (* Closing time in minutes after 00:00   *)
    {311}  FILESBBS     : PathStr;  (* Name of FILES.BBS                     *)
    {391}
         end;

         MAreaRec = Record            (* Message area entry                  *)
    {000}  Id           : LongInt;    (* Always ID_CFG_MAREA                 *)
    {004}  Attrib       : LongInt;    (* Area attributes, see below          *)
    {008}  Format       : Byte;       (* Message base format                 *)
    {009}  Pathname     : PathStr;    (* File path name w/o extension        *)
    {089}  Name         : ANameStr;   (* Message area name                   *)
    {150}  ShortName    : QWKStr;     (* Short message area name             *)
    {163}  Group        : GroupStr;   (* Message area group                  *)
    {167}  PassWord     : PassStr;    (* Password required to enter area     *)
    {183}  OwnBoard     : Byte;       (* Virtual area number in HMB system   *)
    {184}  Typ          : Byte;       (* Area type                           *)
    {185}  Kinds        : Byte;       (* Area status                         *)
    {186}  ReplyStatus  : Byte;       (* Reply status                        *)
    {187}  UseAlias     : Byte;       (* Use alias                           *)
    {188}  ReadRights   : Security;   (* Read rights                         *)
    {213}  WriteRights  : Security;   (* Write rights                        *)
    {238}  SysopRights  : Security;   (* Sysop rights                        *)
    {263}  DaysKill     : SmallWord;  (* Kill older than n days              *)
    {265}  ReceiveKill  : SmallWord;  (* Kill more than n days received msgs *)
    {267}  CountKill    : SmallWord;  (* Keep only n newest messages         *)
    {269}  SubDirNum    : SmallWord;  (* Current subdirectory number         *)
    {271}  UseAka       : Byte;       (* Which AKA to use                    *)
    {272}  CharTable    : Byte;       (* Which char convertion table to use  *)
    {273}  OriginLine   : ANameStr;   (* Origin line for echo areas          *)
    {334}  OpenFrom     : TimeRec;    (* Opening time in minutes after 00:00 *)
    {336}  OpenTo       : TimeRec;    (* Closing time in minutes after 00:00 *)
    {338}  JumpDirNum   : SmallWord;  (* If MAREA_JUMP, where to jump        *)
    {340} {CommentLen   : SmallWord;} (* If nonzero, area has a comment      *)
    {340}  ReplyArea    : LongInt;    (* If nonzero, move replies here       *)
    {344}  AreaTag      : ANameStr;   (* Echomail AREATAG                    *)
         end;

         LanguageHeader = Record             (* LNG?????.DAT - Header       *)
           Id            : LongInt;          (* Always ID_LNG_HDR           *)
           Version       : LongInt;          (* Version number              *)
           Description   : String [254];     (* Language description        *)
           Key           : Char;             (* Selection key               *)
           MenuPath      : DirStr;           (* Menu files path             *)
           TextPath      : DirStr;           (* Text files path             *)
           TopMenu       : QWKStr;           (* Top menu filename           *)
           FileListFirst : LongInt;          (* First filelist string num   *)
           FileListCnt   : Byte;             (* Different filelists         *)
           FileListSize  : Byte;             (* Number of strings           *)
           ReadMsgFirst  : LongInt;          (* First readmsg string num    *)
           ReadMsgCnt    : Byte;             (* Different readmsg types     *)
           ReadMsgSize   : Byte;             (* Number of strings           *)
           ScriptPath    : DirStr;           (* Scripts (*.SCR) path        *)
         end;

         LanguageRecord = PChar;             (* NULL terminated strings     *)

         LngIdxRec = Record                  (* LNG?????.IDX - Record       *)
           Pos : LongInt;                    (* Pointer to LNG?????.DAT     *)
           Len : SmallWord;                  (* String length               *)
         end;

         ScriptHeader = Record
           Id      : LongInt;
           Attrib  : LongInt;
           RecSize : SmallWord;
         end;

         ScriptRecord = Record
           Cmd     : SmallWord;
           Param   : LongInt;
         end;

         StatisticRecord = Record
           Calls       : Array [1..MAX_LIMITBPS] of LongInt;
           Failed      : LongInt;
           NewUsers    : LongInt;
           PublicMsgs  : LongInt;
           PrivateMsgs : LongInt;
           UpK         : LongInt;
           UpTimes     : LongInt;
           DownK       : LongInt;
           DownTimes   : LongInt;
           Yells       : LongInt;
         end; (* 64 bytes *)

         SystemStatRecord = Record (* SYSSTAT.DAT *)
           Total     : StatisticRecord;
           Yesterday : StatisticRecord;
           Today     : StatisticRecord;
           FirstDate : DateRec;
           TodayDate : DateRec;
          {LastCaller: NameStr;}
         end;

  FileListRec = Record                                (* ????????.HDR *)
    Name:        FileMaskType; {spaces mean description line}
    Size:        Longint;
    UploadDate:  Longint;
    Downloads:   SmallWord;
    Attribute:   SmallWord;
    DescPtr:     Longint;
    DescRecLen:  SmallWord;
    UpLdrLen:    Byte;

 { Attributes
   bit        description
     0         Deleted
     1         For Sysop
     2         OFFLINE
     3         Unlisted

     4         No-kill   NOT YET IMPLEMENTED
     5         Checked   NOT YET IMPLEMENTED
    LastDL:      DateRec; NOT YET IMPLEMENTED
    Cost:        SmallWord;    NOT YET IMPLEMENTED
  }
  end;  { Size = 30 bytes}

  {
  DescriptionRec = record                             (* ????????.TXT *)
    Desc:        array[1..desclen] of char; (max. length 1024 bytes)
    Uploader:    array[1..namelen] of char;
  end;
  }

(* The file names are 32 bit CRCs counted from UPPERCASE (capital letters)
   filearea name converted to hexa decimals specified in FAREAS.DAT and
   stored in the filebase path *)


  (* FILEBASEPATH\DELSUGG.TXT :                               *)
  (* DeleteCounter:09 PointerToDELSUGGDAT:09 FullFilePathName *)
  (* FILEBASEPATH\DELSUGG.DAT :                               *)
  FileDeleteSuggRec = Record
    UserNameCRC32: CRC32; (* CRC32 of user name who suggested delete *)
    Next: LongInt;        (* Pointer to next record                  *)
  end;


(*****************************************************************************)
(*                                                                           *)
(*                          U S E R   F I L E S                              *)
(*                                                                           *)
(*****************************************************************************)

       const

         ID_USR       = ID_VER or $00040000;
         ID_USR_HDR   = ID_USR or $01000000;
         ID_USR_REC   = ID_USR or $02000000;

         USER_DELETED      = $00000001; (* Bit  0 - User deleted             *)
         USER_MAILCHK      = $00000002; (* Bit  1 - Mail check               *)
         USER_FILECHK      = $00000004; (* Bit  2 - New files check          *)
         USER_NORATIO      = $00000008; (* Bit  3 - No DL ratios             *)
         USER_FEMALE       = $00000010; (* Bit  4 - Female                   *)
         USER_CLRSCR       = $00000020; (* Bit  5 - Clear screen             *)
         USER_MORE         = $00000040; (* Bit  6 - More prompts             *)
         USER_NOKILL       = $00000080; (* Bit  7 - User cannot be removed   *)
         USER_COLORS       = $00000100; (* Bit  8 - Colors                   *)
         USER_NODISTURB    = $00000200; (* Bit  9 - Do not disturb           *)
         USER_HOTKEYS      = $00000400; (* Bit 10 - Hot keys                 *)
         USER_IGNDLHOURS   = $00000800; (* Bit 11 - Ignore download hours    *)
         USER_DELAFTERVIEW = $00001000; (* Bit 12 - Delete file after viewed *)
         USER_VIEWED       = $00002000; (* Bit 13 - File viewed              *)
         USER_VIEWONLYONCE = $00004000; (* Bit 14 - View file only once      *)
         USER_SYSOP        = $00008000; (* Bit 15 - Added BBS to BBS list    *)
         USER_VIP          = $00010000; (* Bit 16 - VIP member               *)
         USER_BULLETCHK    = $00020000; (* Bit 17 - New bulletins check      *)
         USER_WSCURSORS    = $00040000; (* Bit 18 - Use Wordstar cursor keys *)
         USER_DL_FILEDESC  = $00080000; (* Bit 19 - Download file descs      *)
         USER_FILEDESC_FMT = $00100000; (* Bit 20 - 0=FILES.BBS, 1=DESCRIPT.ION *)
         USER_SHOWKLUDGES  = $00200000; (* Bit 21 - Show kludges when reading msgs *)

                                                 (* OfflineAttrib :          *)
         OFFLINE_WELCOME   = $00000001; (* Bit  0 - Include WELCOME.ANS      *)
         OFFLINE_NEWS      = $00000002; (* Bit  1 - Include NEWS.ANS         *)
         OFFLINE_GOODBYE   = $00000004; (* Bit  2 - Include GOODBYE.ANS      *)
         OFFLINE_NEWFILES  = $00000008; (* Bit  3 - Include new files list   *)
         OFFLINE_NEWBULLET = $00000010; (* Bit  4 - Include new bulletins    *)
{}       OFFLINE_LASTREAD  = $00000020; (* Bit  5 - Include last read ptrs   *)
{}       OFFLINE_ALLMAIL   = $00000040; (* Bit  6 - 'All' msgs as personal?  *)
{}       OFFLINE_AUTOMATIC = $00000080; (* Bit  7 - Offline packing used     *)
         OFFLINE_RECEIVED  = $00000100; (* Bit  8 - Mark personal msgs read  *)
         OFFLINE_OWNMSGS   = $00000200; (* Bit  9 - Include own msgs         *)
         OFFLINE_COMBAREAS = $00000400; (* Bit 10 - Only comb.areas to list  *)
         OFFLINE_NORE      = $00000800; (* Bit 11 - Remove RE: from subject  *)
         OFFLINE_LONGAREAS = $00001000; (* Bit 12 - Long area names in QWK   *)
         OFFLINE_KLUDGES   = $00002000; (* Bit 13 - Include kludges          *)
         OFFLINE_LONGSUBJ  = $00004000; (* Bit 14 - Long subject in QWK      *)

         OFFLINEPKT_NONE  = $00;                 (* No offline packet format *)
         OFFLINEPKT_ASCII = $01;                 (* ASCII format             *)
         OFFLINEPKT_QWK   = $02;                 (* QWK format               *)
         OFFLINEPKT_OMEN  = $03;                 (* OMEN format              *)
         OFFLINEPKT_BWAVE = $04;                 (* Bluewave format          *)

     type

       NameIdxRec = Record                            (* USERINFO.IDX        *)
         NameCRC32   : CRC32;                         (* CRC-32 of real name *)
         AliasCRC32  : CRC32;                         (* CRC-32 of alias     *)
       end;

      (* !First record in user file is default user info! *)

       UserFileHeader = Record               (* USERINFO.DAT - Header        *)
         Id       : LongInt;                 (* Always ID_USR_HDR            *)
         Version  : LongInt;                 (* Version number               *)
         UserSize : SmallWord;               (* Size of user record in bytes *)
       end;

       UserRec = Record                               (* USERINFO.DAT Record *)
         Id            : LongInt;               {  0} (* Always ID_USR_REC   *)
         Name          : NameStr;               {  4} (* Real name           *)
         Alias         : NameStr;               { 40} (* Alias               *)
         City          : CityStr;               { 76} (* City                *)
         Voice         : PhoneStr;              {102} (* Voice number        *)
         Data          : PhoneStr;              {123} (* Data number         *)
         Birthday      : DateRec;               {144} (* Birthday            *)
         Password      : PassStr;               {146} (* Password            *)
         Sec           : Security;              {162} (* Security            *)
         ScreenLen     : Byte;                  {187} (* Screen length       *)
         Attrib1       : LongInt;               {188} (* User attributes I   *)
         Attrib2       : LongInt;               {192} (* User attributes II  *)
         FirstTime     : DateTimeRec;           {196} (* First logon date    *)
         LastTime      : DateTimeRec;           {200} (* Last logon date     *)
         TimesCalled   : LongInt;               {204} (* Total times called  *)
         TotalMinutes  : LongInt;               {208} (* Total minutes used  *)
         Pages         : LongInt;               {212} (* Total times paged   *)
         PublicMsgs    : LongInt;               {216} (* Messages posted I   *)
         PrivateMsgs   : LongInt;               {220} (* Messages posted II  *)
         UpK           : LongInt;               {224} (* Upload kilobytes    *)
         UpTimes       : LongInt;               {228} (* Upload times        *)
         DownK         : LongInt;               {232} (* Download kilobytes  *)
         DownTimes     : LongInt;               {236} (* Download times      *)
         SysopCmnt     : ANameStr;              {240} (* Sysop comment       *)
         Protocol      : Byte;                  {301} (* Protocol number     *)
         Editor        : Byte;                  {302} (* Editor number       *)
         Viewer        : Byte;                  {303} (* Viewer number       *)
         Packer        : Byte;                  {304} (* Packer number       *)
         CharSet       : Byte;                  {305} (* Char set number     *)
         LastFileChk   : DateRec;               {306} (* Last new files chk  *)
         LastBullChk   : DateRec;               {308} (* Last new bullet chk *)
         Expiration    : DateRec;               {310} (* Expiration date     *)
         FirstMenu     : MenuStr;               {312} (* First menu to enter *)
         Language      : MenuStr;               {321} (* Language file       *)
         MessageArea   : LongInt;               {330} (* Msg area number     *)
         MAreaExt      : GroupStr;              {334} (* N/A                 *)
         FileArea      : LongInt;               {338} (* File area number    *)
         FAreaExt      : GroupStr;              {342} (* N/A                 *)
         Door          : LongInt;               {346} (* Door number         *)
         DoorExt       : GroupStr;              {350} (* N/A                 *)
         ChatChannel   : LongInt;               {354} (* Chat channel number *)
         TodayCalls    : Byte;                  {358} (* Today times called  *)
         TodayElapsed  : SmallInt;              {359} (* Today minutes used  *)
         TodayDownK    : LongInt;               {361} (* Today download kB   *)
         TodayDowns    : LongInt;               {365} (* Today DL times      *)
         TimeInBank    : LongInt;               {369} (* Total time in bank  *)
         DLLimitInBank : LongInt;               {373} (* Total limit in bank *)
         ViewFileName  : QWKStr;                {377} (* View file name      *)
         OfflineFmt    : Byte;                  {390} (* Offline packet fmt  *)
         OfflineDays   : Byte;                  {391} (* Automatic pack days *)
         OfflineAttrib : LongInt;               {392} (* Offline attributes  *)
         ReadMsgNum    : Byte;                  {396}
         FileListNum   : Byte;                  {397}
         TodayLastPkt  : Byte;                  {398} (* Today last pkt num  *)
         VerifyCalls   : Byte; (* Calls since last birthday verify, 255 = verify failed *)
         PasswordTries : Byte; (* Number of wrong passwords entered since last call *)
         OfflineMaxNum : SmallWord;             {401} (* Max msgs to pack *)
         FlexPos       : LongInt;               {403} (* Flex record number *)
         LastPktDl     : DateRec;               {407}
         BBSCRC        : LongInt;               {409}
         Emulation     : Byte;                  {413} (* 1=ANSI, 2=AVATAR, 4=ASCII *)
         TextFileType  : Byte;                  {414} (* 0=.ANS, 1->=others *)
         DateFormat    : Byte;                  {415} (* See later *)
         PasswordCRC   : LongInt;               {416} (* CRC password field *)
         UserDefNum    : Array [1..10] of LongInt;    (* User definable number variables *)
         LastVoteChk   : DateRec;               {460}
         TodayLastDesc : Byte;                  {462} (* Last DESCRIPT.xxx downloaded *)
         TimeUnits     : LongInt;                     (* 0=not used, -1=none left, >0=n units left *)
         KBUnits       : LongInt;                     (* 0=not used, -1=none left, >0=n units left *)
         Empty         : Array [1..29] of Byte; {463}
       end;

       (*

          Date format:

          Bits 0-1: 00 = MMDDYY
                    01 = DDMMYY
                    10 = YYMMDD

          Bits 2-3: 00 = "-"
                    01 = "."
                    10 = "/"
                    11 = " "

          Time format:

          Bit 4:     0 = ":"
                     1 = "."

          eg. 00000000 = MM-DD-YY HH:MM
              00010101 = DD.MM.YY HH.MM

       *)

       FlexUserIdxRec = Record (* USERINF2.IDX *)
         NameCRC32: LongInt;   (* CRC & FilePos -1 if record not used *)
         FilePos:   LongInt;
         AddrLen:   SmallWord;
         CmntLen:   SmallWord;
         MailLen:   SmallWord;
         MAreaCnt:  LongInt;
         FAreaCnt:  LongInt;
       end;

       (*
       FIXED LENGTH DATA (USERINF2.DAT) :
       Address
       UserComment
       Comb. msg areas
       Msg pkt msg areas
       Mail scan areas
       Comb. file areas
       Message to those who write mail
       *)

       ExitRecord = Record                  (* EXITINFO.DAT                  *)
         BpsRate     : SmallWord;           (* Bps rate div 100              *)
         COMport     : Byte;                (* COM port                      *)
         NodeNumber  : Byte;                (* Node number                   *)
         UserInfo    : UserRec;             (* User information              *)
         UserRecNum  : LongInt;             (* Record number in USERINFO.*   *)
         LogonTime   : DateTimeRec;         (* Current logon time            *)
         PageTimes   : Byte;                (* Times paged SysOp             *)
         PageReason  : ANameStr;            (* Page reason                   *)
         TimeLeft    : SmallInt;            (* Time left on this call        *)
         LimitLeft   : LongInt;             (* DL-limit left on this call    *)
         NextEvent   : EventRecord;         (* Time of next system event     *)
         NewNetmail  : Boolean;             (* User has entered new netmail  *)
         NewEchomail : Boolean;             (* User has entered new echomail *)
         LastMenu    : MenuStr;             (* Name of last menu entered     *)
         GosubLevel  : Byte;                (* Level of gosubs               *)
         GosubMenus  : GosubRecord;         (* Gosub menu name list          *)
         FlexInfo    : FlexUserIdxRec;      (* USERINF2.DAT index            *)
         LastInfo    : Byte;                (* Last caller attribute         *)
         CurrStat    : StatisticRecord;     (* Current call stats            *)
         LastTimeChk : SmallWord;           (* Last time check [internaluse] *)
         FilesLeft   : LongInt;             (* DL-files left on this call    *)
         EventRecNum : SmallWord;           (* NextEvent recnum, 0=misc.event*)
         GosubCursor : Array [1..MAX_GOSUB] of Byte; (* Gosub menu cursors   *)
         Empty: Array [1..407] of Byte;     (* Reserved for future expansion *)
       end;                                 (* USERINF2.DAT information      *)

(* MAJOR CHANGES :                                                           *)
(*                                                                           *)
(* Beta-7: Size of MAreaRec and DoorRec increased by 2 bytes                 *)
(* Beta-8: String lengths expanded in ModemCfg and ProtocolRecord            *)
(* Beta-10: File database naming system from CRC-32 to sysop selectable,     *)
(*          LimitRec expanded by FileLimit variable,                         *)
(*          EventRec expanded by LastRunTime variable                        *)
(* Beta-11: Script path to LanguageHeader                                    *)
(* Beta-18: Better multinode support; COMMON_xxx flags in cfg other settings *)
(* Beta-23: Size of MAreaRec increased by 61 bytes                           *)
