/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.usbdm.connections.usbdm;

import com.freescale.cdt.debug.cw.core.ui.publicintf.AbstractPhysicalConnectionPanel;
import com.freescale.cdt.debug.cw.core.ui.publicintf.ISettingsListener;
import com.freescale.cdt.debug.cw.core.ui.settings.PrefException;
import com.freescale.cdt.debug.cw.mcu.common.publicintf.ICWGdiInitializationData;
import com.swtdesigner.SWTResourceManager;
import java.util.ArrayList;
import java.util.ListIterator;
import net.sourceforge.usbdm.connections.usbdm.DoubleTextAdapter;
import net.sourceforge.usbdm.connections.usbdm.HexTextAdapter;
import net.sourceforge.usbdm.connections.usbdm.Usbdm;
import net.sourceforge.usbdm.connections.usbdm.UsbdmCommon;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class UsbdmConnectionPanel
extends AbstractPhysicalConnectionPanel
implements ICWGdiInitializationData {
    protected final FormToolkit toolkit = new FormToolkit(Display.getCurrent());
    protected DefaultBdmOptions defaultBdmOptions = new DefaultBdmOptions();
    protected ArrayList<Usbdm.DeviceInfo> deviceList;
    protected ILaunchConfiguration launchConfiguration;
    protected String gdiDllName;
    protected String gdiDebugDllName;
    protected String connectionTypeId;
    protected String deviceNameId;
    protected String deviceNote = "";
    protected String attributeKey = "net.sourceforge.usbdm.connections.usbdm.";
    protected Combo comboSelectBDM;
    protected Button btnRefreshBDMs;
    protected Label lblBDMInformation;
    protected Button btnDefault;
    protected HexTextAdapter txtNVTRIMAddressAdapter;
    protected Label lblNvtrimAddress;
    protected Text txtTrimFrequency;
    protected DoubleTextAdapter txtTrimFrequencyAdapter;
    protected Text txtNVTRIMAddress;
    protected Label lblTrimFrequency;
    protected Label lblKhz;
    protected Label lblHex;
    protected Button btnTrimTargetClock;
    protected Group grpClockTrim;
    protected Button btnTargetVddOff;
    protected Button btnTargetVdd3V3;
    protected Button btnTargetVdd5V;
    protected Button btnCycleTargetVddOnReset;
    protected Button btncycleTargetVddOnConnect;
    protected Button btnLeaveTargetPowered;
    protected Button btnUseDebugBuild;
    protected Label lblDeviceNote;

    public UsbdmConnectionPanel(Composite parent, int style) {
        super((ISettingsListener)new dummyISettingsListener(), parent, style, "None");
    }

    public UsbdmConnectionPanel(ISettingsListener listener, Composite parent, int swtstyle, String protocolPlugin, String connectionTypeId) {
        super(listener, parent, swtstyle, connectionTypeId);
        this.connectionTypeId = connectionTypeId;
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                UsbdmConnectionPanel.this.toolkit.dispose();
            }
        });
    }

    public void create() {
        this.createContents((Composite)this);
        this.addSettingsChangedListeners();
    }

    protected void appendContents(Composite comp) {
        this.lblDeviceNote = new Label(comp, 0);
        this.lblDeviceNote.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        this.lblDeviceNote.setText("Note: " + this.deviceNote);
    }

    protected void createContents(Composite comp) {
        this.toolkit.setBackground(SWTResourceManager.getColor(22));
        this.toolkit.adapt(comp);
        this.toolkit.paintBordersFor(comp);
        GridLayout gridLayout = new GridLayout(3, false);
        this.setLayout((Layout)gridLayout);
        Group grpSelectBdm = new Group(comp, 0);
        grpSelectBdm.setText("Preferred BDM");
        grpSelectBdm.setLayout((Layout)new GridLayout(2, false));
        grpSelectBdm.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        this.toolkit.adapt((Composite)grpSelectBdm);
        this.toolkit.paintBordersFor((Composite)grpSelectBdm);
        this.comboSelectBDM = new Combo((Composite)grpSelectBdm, 8);
        this.comboSelectBDM.setToolTipText("Allows selection of  preferred BDM from those currently connected.\r\nOnly used if multiple BDMs are attached when debugging.");
        this.comboSelectBDM.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UsbdmConnectionPanel.this.updateBdmDescription();
            }
        });
        GridData gd_comboSelectBDM = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_comboSelectBDM.minimumWidth = 200;
        this.comboSelectBDM.setLayoutData((Object)gd_comboSelectBDM);
        this.toolkit.adapt((Composite)this.comboSelectBDM);
        this.toolkit.paintBordersFor((Composite)this.comboSelectBDM);
        this.populateBdmChoices(null, false);
        this.btnRefreshBDMs = new Button((Composite)grpSelectBdm, 0);
        this.btnRefreshBDMs.setToolTipText("Check for connected BDMs");
        this.btnRefreshBDMs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UsbdmConnectionPanel.this.populateBdmChoices(null, true);
            }
        });
        this.toolkit.adapt((Control)this.btnRefreshBDMs, true, true);
        this.btnRefreshBDMs.setText("Refresh");
        this.lblBDMInformation = new Label((Composite)grpSelectBdm, 0);
        this.lblBDMInformation.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.lblBDMInformation.setToolTipText("Description of selected BDM");
        this.toolkit.adapt((Control)this.lblBDMInformation, true, true);
        this.lblBDMInformation.setText("USBDM-CF");
        new Label((Composite)grpSelectBdm, 0);
        Composite composite_1 = new Composite(comp, 0);
        composite_1.setLayout((Layout)new FillLayout(256));
        GridData gd_composite_1 = new GridData(4, 128, false, false, 1, 1);
        gd_composite_1.verticalIndent = 10;
        gd_composite_1.horizontalIndent = 5;
        composite_1.setLayoutData((Object)gd_composite_1);
        this.toolkit.adapt(composite_1);
        this.toolkit.paintBordersFor(composite_1);
        this.btnDefault = new Button(composite_1, 0);
        this.btnDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UsbdmConnectionPanel.this.restoreDefaultSettings();
            }
        });
        this.btnDefault.setToolTipText("Restore dialogue to default values");
        this.toolkit.adapt((Control)this.btnDefault, true, true);
        this.btnDefault.setText("Restore Default");
        Group grpTargetVddSupply = new Group(comp, 0);
        grpTargetVddSupply.setText("Target Vdd Supply");
        RowLayout rl_grpTargetVddSupply = new RowLayout(512);
        rl_grpTargetVddSupply.marginHeight = 3;
        rl_grpTargetVddSupply.spacing = 5;
        rl_grpTargetVddSupply.fill = true;
        grpTargetVddSupply.setLayout((Layout)rl_grpTargetVddSupply);
        grpTargetVddSupply.setLayoutData((Object)new GridData(4, 4, false, false, 1, 2));
        this.toolkit.adapt((Composite)grpTargetVddSupply);
        this.toolkit.paintBordersFor((Composite)grpTargetVddSupply);
        Composite composite = new Composite((Composite)grpTargetVddSupply, 0);
        this.toolkit.adapt(composite);
        this.toolkit.paintBordersFor(composite);
        composite.setLayout((Layout)new FillLayout(256));
        this.btnTargetVddOff = new Button(composite, 16);
        this.btnTargetVddOff.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UsbdmConnectionPanel.this.setTargetVdd(0);
            }
        });
        this.btnTargetVddOff.setToolTipText("Do not supply power to the target.  An external target supply is required.");
        this.toolkit.adapt((Control)this.btnTargetVddOff, true, true);
        this.btnTargetVddOff.setText("Off");
        this.btnTargetVdd3V3 = new Button(composite, 16);
        this.btnTargetVdd3V3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UsbdmConnectionPanel.this.setTargetVdd(1);
            }
        });
        this.btnTargetVdd3V3.setToolTipText("Supply 3.3V to the target through the BDM connection.");
        this.toolkit.adapt((Control)this.btnTargetVdd3V3, true, true);
        this.btnTargetVdd3V3.setText("3V3");
        this.btnTargetVdd5V = new Button(composite, 16);
        this.btnTargetVdd5V.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UsbdmConnectionPanel.this.setTargetVdd(2);
            }
        });
        this.btnTargetVdd5V.setToolTipText("Supply 5V to the target through the BDM connection.");
        this.toolkit.adapt((Control)this.btnTargetVdd5V, true, true);
        this.btnTargetVdd5V.setText("5V");
        this.btnCycleTargetVddOnReset = new Button((Composite)grpTargetVddSupply, 32);
        this.btnCycleTargetVddOnReset.setToolTipText("Cycle target supply when resetting.");
        this.toolkit.adapt((Control)this.btnCycleTargetVddOnReset, true, true);
        this.btnCycleTargetVddOnReset.setText("Cycle target Vdd on reset");
        this.btncycleTargetVddOnConnect = new Button((Composite)grpTargetVddSupply, 32);
        this.btncycleTargetVddOnConnect.setToolTipText("Cycle target Vdd if having trouble connecting to the target.");
        this.btncycleTargetVddOnConnect.setText("Cycle target Vdd on connection problems");
        this.btncycleTargetVddOnConnect.setBounds(0, 0, 433, 16);
        this.toolkit.adapt((Control)this.btncycleTargetVddOnConnect, true, true);
        this.btnLeaveTargetPowered = new Button((Composite)grpTargetVddSupply, 32);
        this.btnLeaveTargetPowered.setToolTipText("Leave target powered when leaving the debugger");
        this.btnLeaveTargetPowered.setText("Leave target powered on exit");
        this.btnLeaveTargetPowered.setBounds(0, 0, 433, 16);
        this.toolkit.adapt((Control)this.btnLeaveTargetPowered, true, true);
    }

    protected void restoreDefaultSettings() {
        if (this.defaultBdmOptions == null) {
            this.defaultBdmOptions = new DefaultBdmOptions();
        }
        try {
            int targetVdd = this.defaultBdmOptions.targetVdd;
            this.btnTargetVddOff.setSelection(targetVdd == 0);
            this.btnTargetVdd3V3.setSelection(targetVdd == 1);
            this.btnTargetVdd5V.setSelection(targetVdd == 2);
            this.btncycleTargetVddOnConnect.setSelection(this.defaultBdmOptions.cycleVddOnReset != 0);
            this.btnCycleTargetVddOnReset.setSelection(this.defaultBdmOptions.cycleVddOnConnect != 0);
            this.btnLeaveTargetPowered.setSelection(this.defaultBdmOptions.leaveTargetPowered != 0);
            this.btncycleTargetVddOnConnect.setEnabled(targetVdd != 0);
            this.btnCycleTargetVddOnReset.setEnabled(targetVdd != 0);
            this.btnLeaveTargetPowered.setEnabled(targetVdd != 0);
            this.btnUseDebugBuild.setSelection(false);
            this.lblDeviceNote.setText("Note: " + this.deviceNote);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadSettings(ILaunchConfiguration iLaunchConfiguration) {
        this.launchConfiguration = iLaunchConfiguration;
        try {
            int targetVdd;
            String preferredBDM = iLaunchConfiguration.getAttribute(this.attrib("defaultBdmSerialNumber"), null);
            if (preferredBDM != null) {
                this.populateBdmChoices(preferredBDM, false);
            }
            this.btnTargetVddOff.setSelection((targetVdd = this.getIntAttribute(iLaunchConfiguration, this.attrib("setTargetVdd"), this.defaultBdmOptions.targetVdd)) == 0);
            this.btnTargetVdd3V3.setSelection(targetVdd == 1);
            this.btnTargetVdd5V.setSelection(targetVdd == 2);
            this.btnCycleTargetVddOnReset.setSelection(this.getIntAttribute(iLaunchConfiguration, this.attrib("cycleTargetVddOnReset"), this.defaultBdmOptions.cycleVddOnReset) != 0);
            this.btncycleTargetVddOnConnect.setSelection(this.getIntAttribute(iLaunchConfiguration, this.attrib("cycleTargetVddOnConnect"), this.defaultBdmOptions.cycleVddOnConnect) != 0);
            this.btnLeaveTargetPowered.setSelection(this.getIntAttribute(iLaunchConfiguration, this.attrib("leaveTargetPowered"), this.defaultBdmOptions.leaveTargetPowered) != 0);
            this.btncycleTargetVddOnConnect.setEnabled(targetVdd != 0);
            this.btnCycleTargetVddOnReset.setEnabled(targetVdd != 0);
            this.btnLeaveTargetPowered.setEnabled(targetVdd != 0);
            this.lblDeviceNote.setText("Note: " + this.deviceNote);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void saveSettings(ILaunchConfigurationWorkingCopy paramILaunchConfigurationWorkingCopy) throws PrefException {
        paramILaunchConfigurationWorkingCopy.setAttribute(this.attrib("defaultBdmSerialNumber"), this.comboSelectBDM.getText());
        int targetVdd = 0;
        if (this.btnTargetVdd3V3.getSelection()) {
            targetVdd = 1;
        } else if (this.btnTargetVdd5V.getSelection()) {
            targetVdd = 2;
        }
        paramILaunchConfigurationWorkingCopy.setAttribute(this.attrib("setTargetVdd"), String.format("%d", targetVdd));
        if (targetVdd == 0) {
            paramILaunchConfigurationWorkingCopy.setAttribute(this.attrib("cycleTargetVddOnConnect"), "0");
            paramILaunchConfigurationWorkingCopy.setAttribute(this.attrib("cycleTargetVddOnReset"), "0");
            paramILaunchConfigurationWorkingCopy.setAttribute(this.attrib("leaveTargetPowered"), "0");
        } else {
            paramILaunchConfigurationWorkingCopy.setAttribute(this.attrib("cycleTargetVddOnConnect"), this.btncycleTargetVddOnConnect.getSelection() ? "1" : "0");
            paramILaunchConfigurationWorkingCopy.setAttribute(this.attrib("cycleTargetVddOnReset"), this.btnCycleTargetVddOnReset.getSelection() ? "1" : "0");
            paramILaunchConfigurationWorkingCopy.setAttribute(this.attrib("leaveTargetPowered"), this.btnLeaveTargetPowered.getSelection() ? "1" : "0");
        }
    }

    protected void addSettingsChangedListeners() {
        if (this.fListener != null) {
            this.comboSelectBDM.addModifyListener(this.fListener.getModifyListener());
            this.btnDefault.addSelectionListener(this.fListener.getSelectionListener());
            this.btnTargetVddOff.addSelectionListener(this.fListener.getSelectionListener());
            this.btnTargetVdd3V3.addSelectionListener(this.fListener.getSelectionListener());
            this.btnTargetVdd5V.addSelectionListener(this.fListener.getSelectionListener());
            this.btncycleTargetVddOnConnect.addSelectionListener(this.fListener.getSelectionListener());
            this.btnCycleTargetVddOnReset.addSelectionListener(this.fListener.getSelectionListener());
            this.btnLeaveTargetPowered.addSelectionListener(this.fListener.getSelectionListener());
        }
    }

    protected int getIntAttribute(ILaunchConfiguration paramILaunchConfiguration, String key, int defaultValue) throws CoreException {
        String sValue = paramILaunchConfiguration.getAttribute(key, String.format("%d", defaultValue));
        return Integer.decode(sValue);
    }

    protected String attrib(String suffix) {
        return String.valueOf(this.attributeKey) + suffix;
    }

    protected void updateBdmDescription() {
        int index;
        if (this.lblBDMInformation != null && (index = this.comboSelectBDM.getSelectionIndex()) >= 0) {
            String deviceDescription = this.deviceList.get((int)index).deviceDescription;
            this.lblBDMInformation.setText(deviceDescription);
        }
    }

    protected void populateBdmChoices(String previousDevice, boolean scanForBdms) {
        String preferredDevice;
        Usbdm.DeviceInfo nullDevice = new Usbdm.DeviceInfo("Generic BDM", "Any connected USBDM", new Usbdm.BdmInformation());
        this.deviceList = scanForBdms ? Usbdm.getDeviceList(this.getShell()) : new ArrayList();
        this.deviceList.add(0, nullDevice);
        if (previousDevice != null && !previousDevice.equals(nullDevice.deviceSerialNumber)) {
            this.deviceList.add(1, new Usbdm.DeviceInfo("Previously selected device", previousDevice, new Usbdm.BdmInformation()));
            preferredDevice = previousDevice;
        } else {
            preferredDevice = this.comboSelectBDM.getText();
        }
        this.comboSelectBDM.removeAll();
        ListIterator<Usbdm.DeviceInfo> it = this.deviceList.listIterator();
        while (it.hasNext()) {
            Usbdm.DeviceInfo di = it.next();
            this.comboSelectBDM.add(di.deviceSerialNumber);
        }
        int index = this.comboSelectBDM.indexOf(preferredDevice);
        if (index >= 0) {
            this.comboSelectBDM.select(index);
        } else {
            this.comboSelectBDM.select(0);
        }
        this.updateBdmDescription();
    }

    public String GetConfigFile() {
        return "";
    }

    public String GetGdiLibrary() {
        if (this.btnUseDebugBuild != null && this.btnUseDebugBuild.getSelection()) {
            return this.gdiDebugDllName;
        }
        return this.gdiDllName;
    }

    public String[] GetGdiOpenCmdLineArgs() {
        return new String[0];
    }

    protected void enableTrim(boolean enabled) {
        this.btnTrimTargetClock.setSelection(enabled);
        this.lblNvtrimAddress.setEnabled(enabled);
        this.lblHex.setEnabled(enabled);
        this.lblKhz.setEnabled(enabled);
        this.lblTrimFrequency.setEnabled(enabled);
        this.txtNVTRIMAddress.setEnabled(enabled);
        this.txtTrimFrequency.setEnabled(enabled);
        this.txtNVTRIMAddress.setText("default");
        this.txtTrimFrequency.setText("default");
    }

    protected void setTargetVdd(int targetVdd) {
        this.btncycleTargetVddOnConnect.setEnabled(targetVdd != 0);
        this.btnCycleTargetVddOnReset.setEnabled(targetVdd != 0);
        this.btnLeaveTargetPowered.setEnabled(targetVdd != 0);
    }

    final class DefaultBdmOptions
    extends UsbdmCommon.BdmOptions {
        public DefaultBdmOptions() {
            this.autoReconnect = 1;
            this.guessSpeed = 1;
            this.cycleVddOnConnect = 0;
            this.cycleVddOnReset = 0;
            this.leaveTargetPowered = 0;
            this.targetClockFreq = 0;
            this.targetVdd = 0;
            this.useAltBDMClock = 255;
            this.usePSTSignals = 0;
            this.useResetSignal = 0;
            this.maskinterrupts = 0;
            this.derivative_type = 0;
            this.clockTrimFrequency = 0;
            this.clockTrimNVAddress = 0;
            this.doClockTrim = false;
        }
    }

    protected static class dummyISettingsListener
    implements ISettingsListener {
        protected dummyISettingsListener() {
        }

        public ModifyListener getModifyListener() {
            return new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    System.err.println("dummyISettingsListener.ModifyListener.modifyText");
                }
            };
        }

        public SelectionListener getSelectionListener() {
            return new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    System.err.println("dummyISettingsListener.SelectionListener.widgetSelected");
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    System.err.println("dummyISettingsListener.SelectionListener.widgetDefaultSelected");
                }
            };
        }

        public void settingsChanged() {
        }
    }
}

