/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Event;
import java.awt.TextComponent;
import java.awt.Window;

class RefreshDialog
extends ICDialog {
    RefreshDlg dlg = new RefreshDlg(this);
    String errMsg;

    RefreshDialog(ICFrame iCFrame) {
        super(iCFrame, "Set Refresh Interval", true);
        this.dlg.CreateControls();
        ((Component)this).setFont(this.frame.fixFont);
        this.dlg.setControlFont(this.frame.baseFont);
        ((TextComponent)this.dlg.RefreshInterval).setText(String.valueOf(this.frame.refresh.interval));
        this.dlg.RefreshInterval.selectAll();
        this.show();
    }

    public boolean updateInterval() {
        int n = 0;
        this.errMsg = "Invalid refresh interval. Must be from 1-1000";
        try {
            n = Integer.parseInt(this.dlg.RefreshInterval.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        if (n >= 1 && n <= 1000) {
            this.frame.refresh.interval = n;
            return true;
        }
        return false;
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.dlg.RefreshInterval || event.target == this.dlg.IDOK) {
            if (!this.updateInterval()) {
                new MessageBox(this.frame, (Window)this, this.errMsg, 1);
            } else {
                this.dispose();
            }
            return true;
        }
        if (event.target == this.dlg.IDCANCEL) {
            this.dispose();
            return true;
        }
        return super.action(event, object);
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 201: {
                this.dispose();
                return true;
            }
        }
        return super.handleEvent(event);
    }
}

