/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

class FlowSpec {
    String IPMask;
    int protocol;
    int srcPort;
    int dstPort;
    String vcType;
    int pcr;
    int scr;
    int maxBurst;
    int LANEThreshold;
    int MPOAThreshold;
    boolean readOnly;
    int qos_flags;
    ParsedStringBuffer template;
    static Vector protocols;
    static Vector ports;
    static ParsedStringBuffer pTemplate;
    public static final int IP_FIELD = 0;
    public static final int SRC_FIELD = 1;
    public static final int DST_FIELD = 2;
    public static final int PROTOCOL_FIELD = 3;
    public static final int TRAFFIC_FIELD = 4;
    public static final int PEAK_FIELD = 5;
    public static final int SUSTAINED_FIELD = 6;
    public static final int BURST_FIELD = 7;
    public static final int LANE_FIELD = 8;
    public static final int MPOA_FIELD = 9;
    public static final int PP_NAME_FIELD = 0;
    public static final int PP_VALUE_FIELD = 1;
    public static final int READONLY_FIELD = 10;
    public static final int QOS_FLAGS_FIELD = 11;
    public static final String READONLY = "r";
    public static final int NO_CUT_THRU = 1;
    public static final int SHARED_PRIORITY = 2;
    public static final int USE_MAC = 4;
    public static final int USE_MIN_BACK_PCR = 8;
    static final String userSpecified = "user-specified";
    public static final String shared = "Shared VC";
    public static final String cbr = "CBR";
    public static final String vbr = "VBR";
    public static final String ubr = "UBR";
    private static final String[] protocolStrings;
    private static final String[] portStrings;

    FlowSpec(FlowSpec flowSpec) {
        this();
        this.setFlow(flowSpec);
    }

    FlowSpec() {
        if (pTemplate == null) {
            protocols = new Vector();
            ports = new Vector();
            pTemplate = new ParsedStringBuffer();
            pTemplate.addField(16);
            pTemplate.addField(5);
            ParsedStringBuffer parsedStringBuffer = pTemplate.Clone();
            parsedStringBuffer.setField(0, userSpecified);
            protocols.addElement(parsedStringBuffer);
            int n = 0;
            while (!protocolStrings[n].equals("")) {
                parsedStringBuffer = pTemplate.Clone();
                parsedStringBuffer.setField(0, protocolStrings[n]);
                parsedStringBuffer.setField(1, protocolStrings[n + 1]);
                protocols.addElement(parsedStringBuffer);
                n += 2;
            }
            parsedStringBuffer = pTemplate.Clone();
            parsedStringBuffer.setField(0, userSpecified);
            ports.addElement(parsedStringBuffer);
            int n2 = 0;
            while (!portStrings[n2].equals("")) {
                parsedStringBuffer = pTemplate.Clone();
                parsedStringBuffer.setField(0, portStrings[n2]);
                parsedStringBuffer.setField(1, portStrings[n2 + 1]);
                ports.addElement(parsedStringBuffer);
                n2 += 2;
            }
        }
        this.template = new ParsedStringBuffer();
        this.template.addField(20);
        this.template.addField(17);
        this.template.addField(19);
        this.template.addField(12);
        this.template.addField(30);
        this.template.addField(15);
        this.template.addField(15);
        this.template.addField(15);
        this.template.addField(15);
        this.template.addField(15);
        this.template.addField(1);
        this.template.addField(3);
        this.IPMask = "*.*.*.*";
        this.protocol = -1;
        this.srcPort = -1;
        this.dstPort = -1;
        this.vcType = ubr;
        this.pcr = 38400;
        this.scr = 2560;
        this.maxBurst = 128;
        this.LANEThreshold = -1;
        this.MPOAThreshold = -1;
        this.readOnly = false;
        this.qos_flags = 0;
    }

    public String toString() {
        ParsedStringBuffer parsedStringBuffer = this.template.Clone();
        parsedStringBuffer.setField(0, this.IPMask);
        parsedStringBuffer.setField(1, FlowSpec.getPort(this.srcPort));
        parsedStringBuffer.setField(2, FlowSpec.getPort(this.dstPort));
        parsedStringBuffer.setField(3, FlowSpec.getProtocol(this.protocol));
        parsedStringBuffer.setField(4, this.vcType);
        parsedStringBuffer.setField(5, String.valueOf(this.pcr));
        parsedStringBuffer.setField(6, String.valueOf(this.scr));
        parsedStringBuffer.setField(7, String.valueOf(this.maxBurst));
        if (this.LANEThreshold < 0) {
            parsedStringBuffer.setField(8, "*");
        } else {
            parsedStringBuffer.setField(8, String.valueOf(this.LANEThreshold));
        }
        if (this.MPOAThreshold < 0) {
            parsedStringBuffer.setField(9, "*");
        } else {
            parsedStringBuffer.setField(9, String.valueOf(this.MPOAThreshold));
        }
        if (this.readOnly) {
            parsedStringBuffer.setField(10, READONLY);
        }
        parsedStringBuffer.setField(11, String.valueOf(this.qos_flags));
        return parsedStringBuffer.toString();
    }

    public void fromString(String string) {
        ParsedStringBuffer parsedStringBuffer = this.template.Clone();
        parsedStringBuffer.fromString(string);
        this.IPMask = parsedStringBuffer.getField(0);
        this.srcPort = FlowSpec.getPortNumber(parsedStringBuffer.getField(1));
        this.dstPort = FlowSpec.getPortNumber(parsedStringBuffer.getField(2));
        this.protocol = FlowSpec.getProtocolNumber(parsedStringBuffer.getField(3));
        this.vcType = parsedStringBuffer.getField(4);
        this.pcr = Integer.parseInt(parsedStringBuffer.getField(5));
        this.scr = Integer.parseInt(parsedStringBuffer.getField(6));
        this.maxBurst = Integer.parseInt(parsedStringBuffer.getField(7));
        this.LANEThreshold = parsedStringBuffer.getField(8).startsWith("*") ? -1 : Integer.parseInt(parsedStringBuffer.getField(8));
        this.MPOAThreshold = parsedStringBuffer.getField(9).startsWith("*") ? -1 : Integer.parseInt(parsedStringBuffer.getField(9));
        this.readOnly = parsedStringBuffer.getField(10).equals(READONLY);
        this.qos_flags = Integer.parseInt(parsedStringBuffer.getField(11));
    }

    public static String getProtocol(int n) {
        if (n == 255 || n < 0) {
            return new String("*");
        }
        String string = String.valueOf(n);
        string = pTemplate.trim(string, 1);
        int n2 = 0;
        while (n2 < protocols.size()) {
            ParsedStringBuffer parsedStringBuffer = (ParsedStringBuffer)protocols.elementAt(n2);
            if (parsedStringBuffer.getField(1).equals(string)) {
                return new String(parsedStringBuffer.getField(0));
            }
            ++n2;
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    public static int getProtocolNumber(String var0) {
        if (var0 == null) {
            return -1;
        }
        try {
            var1_1 = Integer.parseInt(var0.trim());
            return var1_1;
        }
        catch (NumberFormatException v0) {
            var2_3 = 0;
            ** while (var2_3 < FlowSpec.protocols.size())
        }
lbl-1000:
        // 1 sources

        {
            var1_2 = (ParsedStringBuffer)FlowSpec.protocols.elementAt(var2_3);
            if (var1_2.getField(0).equals(var0.trim())) {
                return Integer.parseInt(var1_2.getField(1));
            }
            ++var2_3;
            continue;
        }
lbl14:
        // 1 sources

        return -1;
    }

    public static String getPort(int n) {
        if (n == 255 || n < 0) {
            return new String("*");
        }
        String string = String.valueOf(n);
        string = pTemplate.trim(string, 1);
        int n2 = 0;
        while (n2 < ports.size()) {
            ParsedStringBuffer parsedStringBuffer = (ParsedStringBuffer)ports.elementAt(n2);
            if (parsedStringBuffer.getField(1).equals(string)) {
                return new String(parsedStringBuffer.getField(0));
            }
            ++n2;
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    public static int getPortNumber(String var0) {
        if (var0 == null) {
            return -1;
        }
        try {
            var1_1 = Integer.parseInt(var0.trim());
            return var1_1;
        }
        catch (NumberFormatException v0) {
            var2_3 = 0;
            ** while (var2_3 < FlowSpec.ports.size())
        }
lbl-1000:
        // 1 sources

        {
            var1_2 = (ParsedStringBuffer)FlowSpec.ports.elementAt(var2_3);
            if (var1_2.getField(0).equals(var0.trim())) {
                return Integer.parseInt(var1_2.getField(1));
            }
            ++var2_3;
            continue;
        }
lbl14:
        // 1 sources

        return -1;
    }

    public boolean setFlow(FlowSpec flowSpec) {
        int n;
        boolean bl = false;
        String string = flowSpec.IPMask.trim();
        if (!string.equals(this.IPMask)) {
            bl = true;
            this.IPMask = string;
        }
        if ((n = flowSpec.protocol) != this.protocol) {
            bl = true;
            this.protocol = n;
        }
        if ((n = flowSpec.srcPort) != this.srcPort) {
            bl = true;
            this.srcPort = n;
        }
        if ((n = flowSpec.dstPort) != this.dstPort) {
            bl = true;
            this.dstPort = n;
        }
        if (!(string = flowSpec.vcType.trim()).equals(this.vcType)) {
            bl = true;
            this.vcType = string;
        }
        if ((n = flowSpec.pcr) != this.pcr) {
            bl = true;
            this.pcr = n;
        }
        if ((n = flowSpec.scr) != this.scr) {
            bl = true;
            this.scr = n;
        }
        if ((n = flowSpec.maxBurst) != this.maxBurst) {
            bl = true;
            this.maxBurst = n;
        }
        if ((n = flowSpec.LANEThreshold) != this.LANEThreshold) {
            bl = true;
            this.LANEThreshold = n;
        }
        if ((n = flowSpec.MPOAThreshold) != this.MPOAThreshold) {
            bl = true;
            this.MPOAThreshold = n;
        }
        if (flowSpec.readOnly != this.readOnly) {
            bl = true;
            this.readOnly = flowSpec.readOnly;
        }
        if (flowSpec.qos_flags != this.qos_flags) {
            bl = true;
            this.qos_flags = flowSpec.qos_flags;
        }
        return bl;
    }

    static {
        pTemplate = null;
        protocolStrings = new String[]{"Any", "*", "ICMP", "1", "IGMP", "2", "TCP", "6", "UDP", "17", ""};
        portStrings = new String[]{"Any", "*", "ftp", "20", "http", "80", "netbios-ns", "137", "netbios-dgm", "138", "netbios-ssn", "139", "nntp", "119", "pop-2", "109", "pop-3", "110", "smtp", "25", "snmptrap", "162", "sqlsrv", "156", "telnet", "23", "tftp", "69", "x400", "103", ""};
    }
}

