/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Event;
import java.util.Vector;

class EditMPOADialog
extends ICDialog {
    FlowSpecDialog dlgFlow;
    String elanName;
    EditMPOADlg dlg;
    Vector flowSpecs;
    int MPOAThreshold_default;
    int lineRate = 61826;
    String errMsg = "Unknown Error";
    private boolean madeChange = false;

    EditMPOADialog(ICFrame iCFrame, int n) {
        super(iCFrame, true);
        Object object;
        this.frame = iCFrame;
        this.dlg = new EditMPOADlg(this);
        this.dlg.CreateControls();
        ((Component)this).setFont(this.frame.fixFont);
        this.dlg.setControlFont(this.frame.baseFont);
        this.dlg.flowSpecList.setFont(this.frame.fixFont);
        this.dlg.flowSpec2List.setFont(this.frame.fixFont);
        if (n == -1) {
            this.elanName = "UNKNOWN";
        } else {
            object = (VlanPSB)this.frame.vlanPanel.vlanList.elementAt(n);
            this.elanName = ((ParsedStringBuffer)object).getField(1);
        }
        object = "QoS Preferences for " + this.elanName;
        this.setTitle((String)object);
        this.frame.topLayer.set_frame_icon((String)object);
        this.flowSpecs = new Vector();
        int n2 = this.frame.vlanPanel.getFlowSpecs(this.elanName, this);
        if (n2 != 0) {
            this.dispose();
            VlanPanel.dlgOpen = false;
            return;
        }
        this.updateList();
        this.updateList2();
        this.dlg.IDOK.disable();
        this.show();
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.dlg.IDOK) {
            this.frame.vlanPanel.saveMPOA(this);
            this.dispose();
            VlanPanel.dlgOpen = false;
            return true;
        }
        if (event.target == this.dlg.IDCANCEL) {
            this.dispose();
            VlanPanel.dlgOpen = false;
            return true;
        }
        if (event.target == this.dlg.moveUp) {
            int n = this.dlg.flowSpecList.getSelectedIndex();
            if (n < 1) {
                return true;
            }
            Object e = this.flowSpecs.elementAt(n);
            this.flowSpecs.removeElementAt(n);
            this.flowSpecs.insertElementAt(e, n - 1);
            this.madeChange = true;
            this.updateList(n - 1);
            return true;
        }
        if (event.target == this.dlg.moveDown) {
            int n = this.dlg.flowSpecList.getSelectedIndex();
            if (n < 0) {
                return true;
            }
            if (n + 1 >= this.flowSpecs.size()) {
                return true;
            }
            Object e = this.flowSpecs.elementAt(n);
            this.flowSpecs.removeElementAt(n);
            this.flowSpecs.insertElementAt(e, n + 1);
            this.madeChange = true;
            this.updateList(n + 1);
            return true;
        }
        if (event.target == this.dlg.addFlow) {
            int n = this.getReadOnlyIndex(0, true);
            this.flowSpecs.insertElementAt(new FlowSpec(), n);
            this.dlgFlow = new FlowSpecDialog(this.frame, this, null);
            return true;
        }
        if (event.target == this.dlg.deleteFlow) {
            int n = this.dlg.flowSpecList.getSelectedIndex();
            if (n > -1) {
                this.flowSpecs.removeElementAt(n);
                this.madeChange = true;
                this.updateList();
            }
            return true;
        }
        if (event.target == this.dlg.Properties || event.target == this.dlg.flowSpecList) {
            int n = this.dlg.flowSpecList.getSelectedIndex();
            if ((n = this.getReadOnlyIndex(n, false)) > -1) {
                FlowSpec flowSpec = (FlowSpec)this.flowSpecs.elementAt(n);
                this.dlgFlow = new FlowSpecDialog(this.frame, this, flowSpec);
            }
            return true;
        }
        if (event.target == this.dlg.View || event.target == this.dlg.flowSpec2List) {
            int n = this.dlg.flowSpec2List.getSelectedIndex();
            if ((n = this.getReadOnlyIndex(n, true)) > -1) {
                FlowSpec flowSpec = (FlowSpec)this.flowSpecs.elementAt(n);
                this.dlgFlow = new FlowSpecDialog(this.frame, this, flowSpec);
            }
            return true;
        }
        return super.action(event, object);
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 701: {
                this.setButtons();
                return true;
            }
            case 702: {
                this.setButtons();
                return true;
            }
            case 201: {
                this.dispose();
                VlanPanel.dlgOpen = false;
                return true;
            }
        }
        return super.handleEvent(event);
    }

    public void updateList() {
        this.updateList(-2);
    }

    public void updateList(int n) {
        Vector<ParsedStringBuffer> vector = new Vector<ParsedStringBuffer>();
        int n2 = n > -2 ? n : this.dlg.flowSpecList.getSelectedIndex();
        int n3 = 0;
        while (n3 < this.flowSpecs.size()) {
            FlowSpec flowSpec = (FlowSpec)this.flowSpecs.elementAt(n3);
            if (!flowSpec.readOnly) {
                ParsedStringBuffer parsedStringBuffer = flowSpec.template.Clone();
                String string = flowSpec.toString();
                parsedStringBuffer.fromString(string);
                vector.addElement(parsedStringBuffer);
            }
            ++n3;
        }
        ParsedStringBuffer.updateList(vector, this.dlg.flowSpecList);
        if (n2 + 1 > this.dlg.flowSpecList.countItems()) {
            n2 = this.dlg.flowSpecList.countItems() - 1;
        }
        this.dlg.flowSpecList.select(n2);
        this.setButtons();
    }

    public void updateList2() {
        Vector<ParsedStringBuffer> vector = new Vector<ParsedStringBuffer>();
        int n = 0;
        while (n < this.flowSpecs.size()) {
            FlowSpec flowSpec = (FlowSpec)this.flowSpecs.elementAt(n);
            if (flowSpec.readOnly) {
                ParsedStringBuffer parsedStringBuffer = flowSpec.template.Clone();
                parsedStringBuffer.fromString(flowSpec.toString());
                vector.addElement(parsedStringBuffer);
            }
            ++n;
        }
        ParsedStringBuffer.updateList(vector, this.dlg.flowSpec2List);
    }

    void setButtons() {
        int n = this.dlg.flowSpecList.getSelectedIndex();
        if (n > -1) {
            this.dlg.Properties.enable(true);
            FlowSpec flowSpec = new FlowSpec();
            flowSpec.fromString(this.dlg.flowSpecList.getSelectedItem());
            this.dlg.moveDown.enable(false);
            this.dlg.moveUp.enable(false);
            if (flowSpec.readOnly) {
                this.dlg.deleteFlow.enable(false);
            } else {
                this.dlg.deleteFlow.enable(true);
                int n2 = this.dlg.flowSpecList.countItems();
                if (n + 1 < n2) {
                    String string = this.dlg.flowSpecList.getItem(n + 1);
                    flowSpec.fromString(string);
                    if (flowSpec.readOnly) {
                        this.dlg.moveDown.enable(false);
                    } else {
                        this.dlg.moveDown.enable(true);
                    }
                }
                if (n > 0) {
                    this.dlg.moveUp.enable(true);
                }
            }
        } else {
            this.dlg.Properties.enable(false);
            this.dlg.deleteFlow.enable(false);
            this.dlg.moveUp.enable(false);
            this.dlg.moveDown.enable(false);
        }
        if (this.dlg.flowSpec2List.getSelectedIndex() > -1) {
            this.dlg.View.enable(true);
        } else {
            this.dlg.View.enable(false);
        }
        this.dlg.IDOK.enable(this.madeChange);
    }

    int getReadOnlyIndex(int n, boolean bl) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.flowSpecs.size()) {
            FlowSpec flowSpec = (FlowSpec)this.flowSpecs.elementAt(n3);
            if (flowSpec.readOnly == bl) {
                ++n2;
            }
            if (n2 > n) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public void madeChange() {
        this.madeChange = true;
        this.setButtons();
    }
}

