/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.Security;

public abstract class KeyPairGenerator {
    private String algorithm;

    protected KeyPairGenerator(String string) {
        this.algorithm = string;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public static KeyPairGenerator getInstance(String string) throws NoSuchAlgorithmException {
        try {
            return (KeyPairGenerator)Security.getImpl(string, "KeyPairGenerator", null);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new InternalError("please send a bug report via " + System.getProperty("java.vendor.url.bug"));
        }
    }

    public static KeyPairGenerator getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        return (KeyPairGenerator)Security.getImpl(string, "KeyPairGenerator", string2);
    }

    public abstract void initialize(int var1, SecureRandom var2);

    public void initialize(int n) {
        this.initialize(n, new SecureRandom());
    }

    public abstract KeyPair generateKeyPair();
}

