/***************************************************************************
*	NAME:  FREQ16P.C
**	COPYRIGHT:
**	"Copyright (c) 1994, by FORTE
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
*  CREATION DATE: 01/01/94
*--------------------------------------------------------------------------*
*     VERSION	DATE	   NAME		DESCRIPTION
*>	1.0	01/01/94		Original
***************************************************************************/

#include <dos.h>
#include <conio.h>

#include "forte.h"
#include "gf1os.h"
#include "codecos.h"

#include "proto16.h"
#include "defs16.h"
#include "extern16.h"
#include "codec.h"

extern CODEC_FREQ codec_freq[];
extern IMAGE16 _image_codec;
extern ULTRA16_DATA _codec_data;
extern ULTRA_DATA _gf1_data;

void
wait_mce_pdfr(unsigned char data)
{

_image_codec.pdfr = data;

ENTER_CRITICAL;

outp(_codec_data.addr,CODEC_MCE|PLAYBK_FORMAT);
outp(_codec_data.data,_image_codec.pdfr);
(void)inp(_codec_data.data);		/* ERRATA SHEETS ... */
(void)inp(_codec_data.data);		/* ERRATA SHEETS ... */

/* wait till sync is done ... */
while (inp(_codec_data.addr) & 0x80)
	;

/* turn off the MCE bit */
outp(_codec_data.addr,PLAYBK_FORMAT);

/* Need this. outp doesn't always take ... .*/
while (inp(_codec_data.addr) != PLAYBK_FORMAT)
	outp(_codec_data.addr,PLAYBK_FORMAT);

AutoCalibrate();

LEAVE_CRITICAL;
}

unsigned int 
Ultra16SetFreq(hertz)
unsigned int hertz;
{
unsigned int thertz;
unsigned int old;
int i;
unsigned char format;

old = _image_codec.playfreq;
if (old == hertz)
	return(old);

format = _image_codec.pdfr & 0xF0;

_image_codec.playfreq = hertz;

thertz = hertz / 1000;

if (thertz > 48)
	thertz = 48;

for (i=0;i<14;i++)
	{
	if (thertz <= codec_freq[i].hertz)
		{
		format |= codec_freq[i].bits;
		break;
		}
	}

wait_mce_pdfr(format);

return(old);
}

unsigned int 
Ultra16PlayFormat(stereo,sixteen_bit,compress)
int stereo;
int sixteen_bit;
int compress;
{
unsigned char format;
unsigned int old;

old = _image_codec.pdfr;
format = _image_codec.pdfr & 0x0F;

if (sixteen_bit)
	{
	if (compress == COMPRESS_ADPCM)
		format |= 0xA0;	/* 16 bit ADPCM */
	else
		format |= 0x40;		/* 16 bit, twos comp, little endian */
	}
else
	{
	if (compress == COMPRESS_ALAW)
		format |= 0x60;		/* 8 bit, companded Alaw */
	else if (compress == COMPRESS_ULAW)
			format |= 0x20;		/* 8 bit, companded mulaw */
	}

if (stereo)
	format |= TYPE_STEREO;

if (old != format)
	wait_mce_pdfr(format);

return(old);
}


