/*							*/
/*    Modified to support multiple boards on SCO - k. olsen 4/18/93 */
/*      in particular renamed driver from ether to u5l */
/*    Modified to support multiple boards on SCO - jhlin 10/04/93 */
/*      in particular renamed driver from ether to u5l */

/* space.c */

#include "config.h"

#ifdef U5L4_CNTLS
#define MAX_BOARDS (U5L4_CNTLS+U5L3_CNTLS+U5L2_CNTLS+U5L1_CNTLS+U5L_CNTLS) 

#elif U5L3_CNTLS
#define MAX_BOARDS (U5L3_CNTLS+U5L2_CNTLS+U5L1_CNTLS+U5L_CNTLS) 

#elif U5L2_CNTLS
#define MAX_BOARDS (U5L2_CNTLS+U5L1_CNTLS+U5L_CNTLS) 

#elif U5L1_CNTLS
#define MAX_BOARDS (U5L1_CNTLS+U5L_CNTLS) 

#else
#define MAX_BOARDS (U5L_CNTLS) 
#endif

int u5l_num_dev = MAX_BOARDS;

typedef	struct {
	int  start_addr; /* RAM starting address	*/
	int  end_addr;	 /* RAM ending address	*/
	int  IRQ;	 /* Interrupt 		*/
	int  PORT;	 /* I/O address		*/
} T_u5l_sdev;

T_u5l_sdev	Sdev[MAX_BOARDS] = {
#ifdef U5L_0
	{
		U5L_0_SCMA, 	/* RAM starting address */
		U5L_0_ECMA,	/* RAM ending address	*/
		U5L_0_VECT,	/* IRQ			*/
		U5L_0_SIOA		/* I/O address		*/
	}
#endif
#ifdef U5L1_0
	,
	{
		U5L_0_SCMA, 	/* RAM starting address */
		U5L1_0_ECMA,	/* RAM ending address	*/
		U5L1_0_VECT,	/* IRQ			*/
		U5L1_0_SIOA	/* I/O address		*/
	}
#endif
#ifdef U5L2_0
	,
	{
		U5L_0_SCMA, 	/* RAM starting address */
		U5L2_0_ECMA,	/* RAM ending address	*/
		U5L2_0_VECT,	/* IRQ			*/
		U5L2_0_SIOA	/* I/O address		*/
	}
#endif
#ifdef U5L3_0
	,
	{
		U5L_0_SCMA, 	/* RAM starting address */
		U5L3_0_ECMA,	/* RAM ending address	*/
		U5L3_0_VECT,	/* IRQ			*/
		U5L3_0_SIOA	/* I/O address		*/
	}
#endif
#ifdef U5L4_0
	,
	{
		U5L_0_SCMA, 	/* RAM starting address */
		U5L4_0_ECMA,	/* RAM ending address	*/
		U5L4_0_VECT,	/* IRQ			*/
		U5L4_0_SIOA	/* I/O address		*/
	}
#endif
};
