//
// $Id: who.cpp 1.9 1993/11/11 22:48:30 supervisor Exp supervisor $
//
// The Press-Enterprise Co.
// 3512 Fourteenth Street
// Riverside, California 92501-3878
// (c) Copyright 1992
//
// Author: Randolph Thomas
// 
// $Log: who.cpp $
// Revision 1.9  1993/11/11  22:48:30  supervisor
// Fixed when there is no internet address accessible.
//
// Revision 1.8  1993/07/09  18:51:23  rthomas
// Added the station number to the listing.
//
// Revision 1.7  1993/07/09  18:43:03  rthomas
// Fixed bug where user did not have a Real Name, it would
// return a bad property value.  So now it puts a space in
// that value.
//
// Revision 1.6  1993/04/14  23:00:00  rthomas
// Now it detects your login across servers for
// the "*" indicator.
//
// Revision 1.5  1992/11/04  18:21:41  rthomas
// Oops, had forgotten May.
//
// Revision 1.4  1992/09/04  22:49:27  rthomas
// Changed the format of some of the NCP function calls, since
// the library itself had changed.
//
// Revision 1.3  1992/08/10  21:40:33  rthomas
// Added the PreferredConnection, since specifying a machine
// in Norton Desktop didn't seem to work.  Now it does.
//
// Revision 1.2  1992/07/31  15:09:02  rthomas
// Added the ability to specify a server.
//
// Revision 1.1  1992/07/30  20:37:20  rthomas
// Initial revision
//
//

#include <dos.h>
#include <malloc.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "ethers.hpp"
#include <novell.h>

Ethers ethers;
void StringToUpper(char *);
static char *Months[]={"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep",
	"Oct","Nov","Dec"};
static char *Days[]={"Sun","Mon","Tue","Wed","Thu","Fri","Sat"};
static char IdentString[]="IDENTIFICATION";

static char RCSId[]="$Id: who.cpp 1.9 1993/11/11 22:48:30 supervisor Exp supervisor $";

void main(int argc, char **argv)
{
	int i,j,ShowEther=0;
	char netNumber[4],nodeAddress[6],etheradd[18];
	BYTE myEtherAdd[10];
	int socketNumber;
	char obName[49];
	WORD obType;
	long obID;
	BYTE loTime[7],propVal[128],moSeg,propFlags;
	int PrimaryConnect=GetPrimaryConnectionID();
	int PreferredConnect=GetPreferredConnectionID();
	int myconnect=GetConnectionNumber();
	char *realname;

	if (argc>1)
	{
		for (i=1;i<argc;i++)
		{
			if ((argv[i][0]=='-')||(argv[i][0]=='/'))
			{
				switch (argv[i][1])
				{
					case 'e':
						ShowEther++;
						break;
					case 'h':
						printf("%s [server] [/e] [/h]\n",argv[0]);
						exit(0);
						break;
					default:
						fprintf(stderr,"Unknown switch -%c\n",argv[i][1]);
						exit(2);
				}
			}
			else
			{
				StringToUpper(argv[i]);
				if (SwitchToServer(argv[i]))
				{
					fprintf(stderr,"You're not attached to %s.\n",argv[i]);
					exit(6);
				}
				printf("[%s]\n",argv[i]);
			}
		}
	}
	if (!IPXInitialize())
	{
		fprintf(stderr,"You must be logged on first.\n");
		exit(3);
	}
	for (i=1;i<255;i++)
	{
		j=GetConnectionInformation(i,obName,&obType,&obID,loTime);
		if (j==253)	// must have run out of connections
			i=999;
		if ( !j && obID && (obType==0x0001))
		{
			printf("%-10s",obName);
			j=GetInternetAddress(i,netNumber,nodeAddress,&socketNumber);
			if (j)
			{
				strcpy(etheradd,"no address");
			}else
			{
				sprintf(etheradd,"%02x:%02x:%02x:%02x:%02x:%02x",
					(BYTE)nodeAddress[0],
					(BYTE)nodeAddress[1],
					(BYTE)nodeAddress[2],
					(BYTE)nodeAddress[3],
					(BYTE)nodeAddress[4],
					(BYTE)nodeAddress[5]);
				IPXGetInternetworkAddress(myEtherAdd);
			}
			if (myEtherAdd[4]==nodeAddress[0]&&
				myEtherAdd[5]==nodeAddress[1]&&
				myEtherAdd[6]==nodeAddress[2]&&
				myEtherAdd[7]==nodeAddress[3]&&
				myEtherAdd[8]==nodeAddress[4]&&
				myEtherAdd[9]==nodeAddress[5])
				printf("* ");
			else
				printf("  ");
			j=ReadPropertyValue(obName,obType,IdentString,1,propVal,
				&moSeg, &propFlags);
			if (j==0xFFFB)
			{
				strcpy((char *)propVal," ");
			}else
			{
				if (j)
				{
					fprintf(stderr,"Read bad property value (%X)\n",j);
					exit(4);
				}
			}
			printf("%-25.25s ",propVal);
			if (ShowEther)
			{
				printf("%2d-%02d %02d:%02d",loTime[1],
					loTime[2],
					loTime[3],
					loTime[4]);
				printf(" %s ",etheradd);
			}
			else
			{
				printf("%3s %3s %2d ",
					Days[loTime[6]],
					Months[loTime[1]-1],
					loTime[2]);
				if (loTime[3]>12)
				{
					printf("%2d:%02d pm ",
						loTime[3]-12,
						loTime[4]);
				}
				else
				{
					printf("%2d:%02d am ",
						loTime[3],
						loTime[4]);
				}
				printf("%2d ",i);
			}
			printf("%-.10s",ethers.lookup(etheradd));
			printf("\n");
		}
	}
	SetPrimaryConnectionID(PrimaryConnect);
	SetPreferredConnectionID(PreferredConnect);
	exit(0);
}

void StringToUpper(char *in)
{
	while (in[0]!='\0')
	{
		*in=toupper(*in);
		in++;
	}
}
