//
// $Id: ethers.cpp 1.4 1993/07/09 18:54:56 rthomas Exp $
//
// The Press-Enterprise Co.
// 3512 Fourteenth Street
// Riverside, California 92501-3878
// (c) Copyright 1992
//
// Author: Randolph Thomas
// 
// $Log: ethers.cpp $
// Revision 1.4  1993/07/09  18:54:56  rthomas
// Now it checks sys:etc before sys:public for the ethers file.
//
// Revision 1.3  1992/09/08  20:12:04  rthomas
// Changed module to handle no ETHER file.  It'll just return
// a pointer to a null string.
//
// Revision 1.2  1992/09/04  22:52:59  rthomas
// Changed the location of the ETHERS file.
//
// Revision 1.1  1992/06/11  15:52:53  rthomas
// Initial revision
//
//

#include <process.h>
#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include "ethers.hpp"

char Id[]="$Id: ethers.cpp 1.4 1993/07/09 18:54:56 rthomas Exp $";

Ethers::Ethers()
{
        struct ethernode *current;
        FILE *etherfile;
        int a1,a2,a3,a4,a5,a6;
        char temp[180],name[80],garbage[80];

        if ( (etherfile = fopen("SYS:ETC\\ETHERS","r")) == NULL )
        {
        	if ( (etherfile = fopen("SYS:PUBLIC\\ETHERS","r")) == NULL )
        	{
				return;
			}
        }
        current = (struct ethernode *)malloc(sizeof(struct ethernode));
        current->name = (char *)NULL;
        current->next = (struct ethernode *)NULL;
        top = current;
        while (!feof(etherfile))
        {
                fgets(temp,sizeof(temp)-1,etherfile);
                if (sscanf(temp,"%x:%x:%x:%x:%x:%x %s %[^\n]",&a1,&a2,
                        &a3,&a4,&a5,&a6,&name,&garbage)>6)
                {
                        current->a1 = (a1<<8) + a2;
                        current->a2 = (a3<<8) + a4;
                        current->a3 = (a5<<8) + a6;
                        current->name=strdup(name);
                        if ((current->next=(struct ethernode *)malloc(
                                sizeof(struct ethernode)))==(struct ethernode *)NULL)
                        {
                                fprintf(stderr,"ether memory error");
                                exit(4);
                        }
                        current = current->next;
                        current->name = (char *)NULL;
                        current->next = (struct ethernode *)NULL;
                }
        }
        fclose(etherfile);
}

char *Ethers::lookup(char *inter)
{
        int a1,a2,a3,a4,a5,a6;
        unsigned int A1,A2,A3;
        struct ethernode *current;
        char *val="";

        if (sscanf(inter,"%x:%x:%x:%x:%x:%x",&a1,&a2,&a3,&a4,&a5,&a6)==6)
        {
                current=top;
                A1 = (a1<<8) + a2;
                A2 = (a3<<8) + a4;
                A3 = (a5<<8) + a6;
                while (current!=(struct ethernode *)NULL)
                {
                        if ((current->a1==A1) && (current->a2==A2) &&
                            (current->a3==A3))
                            return current->name;
                        current = current->next;
                }
        }
        return val;
}


Ethers::~Ethers()
{
        struct ethernode *current,*nextone;

        current=top;
        while (current!=(struct ethernode *)NULL)
        {
        	nextone=current->next;
        	free(current);
        	current=nextone;
        }
}
