{**************************************************************************
*   UNDOC - Undocumented Calls-DOS                                        *
*   Copyright 1993 by Sren Granfeldt                                     *
*   May be freely distributed and used but not sold except by permission. *
*                                                                         *
*   Version 1.0  22/02/93                                                 *
*     first release                                                       *
***************************************************************************}
{.$IFDEF InitAllUnits}

{$A-,B-,D-,F-,I-,L-,N+,R-,S-,V-}

unit Undoc;
  {-Undocumented Calls-DOS}

interface

function SetHandleCount(DesiredHandles : Word) : Boolean;
  {-This function is used to increase the per-process limit on
    open files beyond the default of 20 files. Although documented,
    this function is included because of a bug in early
    releases(DOS 3.3+)}

function MSNetworkInstalled : Boolean;
  {-Determine whether a Microsoft Network-compatible network is
    installed(DOS 2+)}

function GetSwitchChar : Char;
  {-Return the character which is used to introduce command
    switches(DOS 3+)}

  {======================================================================}

implementation

uses
  Dos;

  function SetHandleCount(DesiredHandles : Word) : Boolean;
    {-This function is used to increase the per-process limit on
      open files beyond the default of 20 files. Although documented,
      this function is included because of a bug in early
      releases(DOS 3.3+)}
  var
    Regs : registers;
  begin
    with Regs do begin
      AH := $67;
      BX := DesiredHandles;
      MsDos(Regs);

      {set up result}
      SetHandleCount := (Flags and FCarry) <> 1;
    end;
  end;

  function MSNetworkInstalled : Boolean;
    {-Determine whether a Microsoft Network-compatible network is
      installed(DOS 2+)}
  var
    Regs : registers;
  begin
    with Regs do begin
      AH := $00;
      intr($2A, Regs);

      {set up result}
      MSNetworkInstalled := (AH <> 0);
    end;
  end;

  function GetSwitchChar : Char;
    {-Return the character which is used to introduce command
      switches(DOS 3+)}
  var
    Regs : registers;
  begin
    with Regs do begin
      AX := $3700;
      MsDos(Regs);

      {set up result}
      GetSwitchChar := Char(DL);
    end;
  end;

{$IFDEF InitAllUnits}
begin
{$ENDIF}
end.
