#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <dir.h>
#include <string.h>
#include <mem.h>
#include <stdlib.h>

typedef unsigned char BYTE;
typedef unsigned int  WORD;
typedef unsigned long LONG;

#define zap(a)              {memset ( &a, NULL, sizeof(a));}
#define size(a)             {a.Length=sizeof(a)-2;}

struct scanBindReq {
	WORD    Length;
	BYTE    Function;
	LONG    LastObjectID;
	WORD    ObjectType;
	BYTE    ObjectNameLength;
	BYTE    ObjectName[48];
	};

struct scanBindRep {
	WORD    Length;
	LONG    ObjectID;
	WORD    ObjectType;
	BYTE    ObjectName[48];
	BYTE    ObjectFlag;
	BYTE    ObjectSecurity;
	BYTE    ObjectHasProperties;
	};

struct readPropValueReq {
	WORD    Length;
	BYTE    Function;
    WORD    ObjectType;
    BYTE    ObjectNameLength;
    BYTE    ObjectName[48];
    BYTE    SegmentNumber;
    BYTE    PropertyNameLength;
    BYTE    PropertyName[16];
    };

struct readPropValueRep {
	WORD    Length;
	BYTE    PropertyValue[128];
	BYTE    MoreSegments;
	BYTE    PropertyFlags;
	};

struct readQueueStatReq {
	WORD    Length;
	BYTE    Function;
	LONG    ObjectID;
	};

struct readQueueStatRep {
	WORD    Length;
	LONG    ObjectID;
	BYTE    QueueStatus;
	BYTE    NumberOfJobs;
	BYTE    NumberOfServers;
	LONG    ServerID[25];
	BYTE    ServerStation[25];
	BYTE    MaxServers;
	};

struct getBindObjNameReq {
	WORD    Length;
	BYTE    Function;
	LONG    ObjectID;
	};

struct getBindObjNameRep {
	WORD    Length;
	LONG    ObjectID;
	WORD    ObjectType;
	BYTE    ObjectName[48];
	};

struct getJobListReq {
    WORD    Length;
	BYTE    Function;
    LONG    QueueID;
    };

struct getJobListRep {
	WORD    Length;
	WORD    JobCount;
    WORD    JobList[250];
    };

struct getJobReq {
	WORD    Length;
	BYTE    Function;
	LONG    QueueID;
    WORD    JobNum;
    };

struct getJobRep {
    WORD    Length;
	BYTE    ClientStation;
	BYTE    ClientTaskNumber;
	LONG    ClientIDNumber;
	LONG    TargerServerIDNumber;
    BYTE    TargerExecutionTime[6];
    BYTE    JobEntryTime[6];
    WORD    JobNumber;
    WORD    JobType;
	BYTE    JobPosition;
    BYTE    JobControllFlags;
    BYTE    JobFileName[14];
	BYTE    JobFileHandle[6];
	BYTE    ServerStation;
	BYTE    ServerTaskNumber;
	LONG    ServerIDNumber;
    BYTE    TextJobDescription[50];
	BYTE    ClientRecordAreaVersion;
    WORD    TabSize;
	WORD    NumberOfCopies;
	BYTE    ControllFlags; // WORD
	WORD    MaxLines;
    WORD    MaxCharacters;
    BYTE    FormName[16];
	BYTE    Dummy[6]; // Reserved
	BYTE    BannerName[13]; // 14
    BYTE    FileNameOnBanner[13];
	BYTE    FileNameInHeader[14]; // 16
    BYTE    DirPath[80];
	};

struct getFileSizeReq {
	WORD    Length;
	BYTE    Function;
	LONG    QueueID;
	WORD    JobNum;
	};

struct getFileSizeRep {
	WORD    Length;
	LONG    QueueID;
	WORD    JobNum;
	LONG    FileSize;
	};

struct QueueEntry {
	int  Ready;
	int  NumOfJobs;
	int  NumOfServers;
	LONG QueueID;
	char QueueName[48];
	LONG PrintID;
	char PrintName[48];
	char Location[100];
	};

char ProgName[]="Queue List";
int VerMaj=1;
int VerMin=5;
int QueueCount=0;
#define MaxEntry 100
struct QueueEntry QueueList[MaxEntry];
int AnyJob=0;
int ShowErrors=0;

char *qstat[]={"<Offline>","",};

int API_E3(void *Request, void *Reply)
{
	_SI=(unsigned)Request;
	_DI=(unsigned)Reply;
	_ES=_DS;
	_AH=0xE3;
	geninterrupt(0x21);
	return(_AL);
}

void ShowError(char *s)
{
	if (ShowErrors!=0) printf(s);
}

void PrintError(int ern)
{
	switch (ern)
	{
		case 0x00: ShowError("Success\n");                  break;
		case 0x96: ShowError("Server Out Of Memory\n");     break;
		case 0x9C: ShowError("Invalid Path\n");             break;
		case 0xD0: ShowError("Q Error\n");                  break;
		case 0xD1: ShowError("No Queue\n");                 break;
		case 0xD2: ShowError("No Q Server\n");              break;
		case 0xD3: ShowError("No Q Rights\n");              break;
		case 0xD5: ShowError("No Q Job\n");                 break;
		case 0xEC: ShowError("No Such Segment\n");          break;
		case 0xEF: ShowError("Invalid name\n");             break;
		case 0xF0: ShowError("Wildcard Not Allowed\n");     break;
		case 0xF1: ShowError("Invalid Bindary Security\n"); break;
		case 0xFB: ShowError("No Such Property\n");         break;
		case 0xFC: ShowError("No Such Object\n");           break;
		case 0xFE: printf("Server Bindary Locked\n");       break;
		case 0xFF: printf("Bindary Failure\n");             break;
		default:   printf("Unknown error #%2x#2\n",ern);    break;
	}
}

WORD swapw(WORD x)
{
	union
	{
		WORD w;
		BYTE b[2];
	} U;
	BYTE t;

	U.w=x;
	t=U.b[0];
	U.b[0]=U.b[1];
	U.b[1]=t;

	return (U.w);
}

LONG swapl(LONG x)
{
	union
	{
		LONG l;
		WORD w[2];
	} U;
	WORD t;

	U.l=x;
	t=swapw(U.w[0]);
	U.w[0]=swapw(U.w[1]);
	U.w[1]=t;
	return (U.l);
}

void GetQueueList()
{
	struct scanBindReq Request;
	struct scanBindRep Reply;
	int    result;

	zap(Request); size(Request);
	zap(Reply);   size(Reply);
	Request.Function=0x37; // p 146
	Request.LastObjectID=0xFFFFFFFF;
	Request.ObjectType=swapw(0x0003); // queue
	Request.ObjectNameLength=1;
	strcpy(Request.ObjectName,"*");

	result=API_E3(&Request,&Reply);

	while (result==0)
	{
		zap(QueueList[QueueCount]);
		QueueList[QueueCount].QueueID=Reply.ObjectID;
		strcpy(QueueList[QueueCount].QueueName,Reply.ObjectName);
		if (QueueCount++>MaxEntry) exit(1);
		Request.LastObjectID=Reply.ObjectID;
		result=API_E3(&Request,&Reply);
	}
	if (result!=0xFC) PrintError(result);
}

LONG GetDefaultPrinter(char *QueueName)
{
	struct readPropValueReq Request;
	struct readPropValueRep Reply;
	int    result;

	union {
		char s[4];
		LONG l;
	} PServer;

	zap(Request); size(Request);
	zap(Reply);   size(Reply);
	Request.Function=0x3D; // p 160
	Request.ObjectType=swapw(0x0003); // Queue
	Request.ObjectNameLength=sizeof(Request.ObjectName);
	strcpy(Request.ObjectName,QueueName);
	Request.SegmentNumber=1;
	Request.PropertyNameLength=9;
	strcpy(Request.PropertyName,"Q_SERVERS");

	result=API_E3(&Request,&Reply);

	if (result!=0) {
		if (result!=0xFC) PrintError(result);
		return (0l);
	}
	else
	{
		PServer.s[0]=Reply.PropertyValue[0];
		PServer.s[1]=Reply.PropertyValue[1];
		PServer.s[2]=Reply.PropertyValue[2];
		PServer.s[3]=Reply.PropertyValue[3];
		return (PServer.l);
	}
}

void GetPrinterName(LONG PrintID, char *PrintName)
{
	struct getBindObjNameReq Request;
	struct getBindObjNameRep Reply;
	int    result;

	zap(Request); size(Request);
	zap(Reply);   size(Reply);
	Request.Function=0x36; // p 153
	Request.ObjectID=PrintID;

	result=API_E3(&Request,&Reply);

	if (result>0) {
		PrintError(result);
		strcpy(PrintName,"");
	}
	else {
		strcpy(PrintName,Reply.ObjectName);
	}
}

void GetPrinterLoc(char *PrintName, char *Location)
{
	struct readPropValueReq Request;
	struct readPropValueRep Reply;
	int    result;

	zap(Request); size(Request);
	zap(Reply);   size(Reply);
	Request.Function=0x3D; // p160
	Request.ObjectType=swapw(0x0007); // Queue Server
	Request.ObjectNameLength=sizeof(Request.ObjectName);
	strcpy(Request.ObjectName,PrintName);
	Request.SegmentNumber=1;
	Request.PropertyNameLength=14;
	strcpy(Request.PropertyName,"IDENTIFICATION");

	result=API_E3(&Request,&Reply);

	if (result!=0)
	{
		PrintError(result);
		strcpy(Location,"");
	}
	else strcpy(Location,Reply.PropertyValue);
}

void GetPrintList()
{
	struct readQueueStatReq Request;
	struct readQueueStatRep Reply;
	int    result;

	int i;

	zap(Request); size(Request);
	Request.Function=0x66; // p 184
	for (i=0;i<QueueCount;i++)
	{
		zap(Reply);   size(Reply);
		Request.ObjectID=QueueList[i].QueueID;
		result=API_E3(&Request,&Reply);
		if (result>0 && result!=0xD2)
		{
			PrintError(result);
			return;
		}
		QueueList[i].NumOfJobs=Reply.NumberOfJobs;
		QueueList[i].NumOfServers=Reply.NumberOfServers;
		if (Reply.NumberOfServers>0)
		{
			QueueList[i].Ready=1;
			QueueList[i].PrintID=Reply.ServerID[0];
		}
		else
		{
			QueueList[i].Ready=0;
			QueueList[i].PrintID=GetDefaultPrinter(QueueList[i].QueueName);
		};
		GetPrinterName(QueueList[i].PrintID,QueueList[i].PrintName);
		GetPrinterLoc(QueueList[i].PrintName,QueueList[i].Location);
	}
}

LONG JobFileSize(LONG QueueID, WORD JobNum)
{
	struct getFileSizeReq Request;
	struct getFileSizeRep Reply;
	int    result;

	zap(Request); size(Request);
	zap(Reply);   size(Reply);
	Request.Function=0x78; // p 206
	Request.QueueID=QueueID;
	Request.JobNum=JobNum;

	result=API_E3(&Request,&Reply);

	if (result>0)
	{
		PrintError(result);
		return (0);
	}
	else
	{
		return (swapl(Reply.FileSize));
	}
}

void ShowUserName(LONG UserID)
{
	char UserName[100];

	GetPrinterName(UserID,UserName);
	printf("%-12s ",UserName);
}

void ShowOneJob(LONG QueueID, WORD JobNum)
{
	struct getJobReq Request;
	struct getJobRep Reply;
	int    result;

	int t;

	zap(Request); size(Request);
	zap(Reply);   size(Reply);
	Request.Function=0x6C; // p191
	Request.QueueID=QueueID;
	Request.JobNum=JobNum;

	result=API_E3(&Request,&Reply);

	if (result>0) {
		PrintError(result);
	}
	else {
		printf("    ");
		ShowUserName(Reply.ClientIDNumber);
		printf("%5i ",swapw(Reply.JobNumber));
		printf("%14s ",Reply.JobFileName);
		printf("%12li ",JobFileSize(QueueID,JobNum));
		printf("%s ",Reply.TextJobDescription);
		t=Reply.JobControllFlags;
		if (t!=0x10) printf("[");
		if ((t&0x08) >0) printf("Keep ");
		if ((t&0x10)==0) printf("Clear ");
		if ((t&0x20) >0) printf("Adding ");
		if ((t&0x40) >0) printf("UserHold ");
		if ((t&0x80) >0) printf("OperHold ");
		if (t!=0x10) printf("\b]");
		printf("\n");
	}
}

void ShowJobs(QueueEntry Q)
{
	struct getJobListReq Request;
	struct getJobListRep Reply;
	int    result;

	int i;

	zap(Request); size(Request);
	zap(Reply);   size(Reply);
	Request.Function=0x6B; // p 190
	Request.QueueID=Q.QueueID;

	result=API_E3(&Request,&Reply);

	if (result>0) {
		PrintError(result);
	}
	else {
		for (i=0;i<swapw(Reply.JobCount);i++)
		{
			ShowOneJob(Q.QueueID,Reply.JobList[i]);
		};
	}
}

void PrintQueueList()
{
	int i;

	for (i=0;i<QueueCount;i++)
	{
		if (QueueList[i].NumOfJobs>0)
		{
			if (AnyJob==0)
			{
				printf("    %-12s %5s %14s %12s %s\n","User","Job #","Queue file","File Size","Description");
			}
			AnyJob+=QueueList[i].NumOfJobs;
			printf("%-16s %s %s\n",
				QueueList[i].QueueName,
				QueueList[i].Location,
				qstat[QueueList[i].Ready]
			);
			ShowJobs(QueueList[i]);
		}
	}
}

void HelpMe()
{
	printf("%s v%i.%d\n",ProgName,VerMaj,VerMin);
	printf("Usage:\n");
	printf("   %s [ /E | /? ]\n",ProgName);
	printf("Where:\n");
	printf("   /E  Show all API errors\n");
	printf("   /?  Show this help\n");
	_exit(0);
}

void ProcessArgs()
{
	if (_argc>2) HelpMe();
	if (strcmp(_argv[1],"/?")==0) HelpMe();
	if (strcmp(_argv[1],"/h")==0) HelpMe();
	if (strcmp(_argv[1],"/H")==0) HelpMe();
	if (strcmp(_argv[1],"?")==0) HelpMe();
	if (strcmp(_argv[1],"/e")==0) ShowErrors=1;
	if (strcmp(_argv[1],"/E")==0) ShowErrors=1;
	if (ShowErrors==0) HelpMe();
}

void main()
{
	if (_argc>1) ProcessArgs();
	GetQueueList();
	GetPrintList();
	printf("%s v%i.%d\n",ProgName,VerMaj,VerMin);
	PrintQueueList();
	exit(0);
}
