
/* semfdddm.h */

/*****************************************************************************/
/* NT IBM SDLC Adapter Device Driver: DMA support stuff                      */
/*****************************************************************************/

#define StandardDMAChannel   0x01

#define DMAPhysAddress       0x02
#define DMACountRegister     0x03
#define DMAMaskRegister      0x0a
#define DMAModeRegister      0x0b
#define DMAFirstByteFlipFlop 0x0c

#define DMAExtdFnRegister    0x18
#define LDD_DMAEFE           0x1a

#define DMAPageRegister      0x83

#define DMAClearChannel1     0x01
#define DMAMaskChannel1      0x05
#define DMACmdWrite          0x45
#define DMACmdRead           0x49

#define MCADMASetMask        0x90
#define MCADMAAddress        0x20
#define MCADMACount          0x40
#define MCADMAMode           0x70
#define MCADMAClearMask      0xa0

#define DMACrosses64K(BufStart,BufSize)                                        \
  (                                                                            \
    (                                                                          \
     (                                                                         \
       (                                                                       \
        ((ULONG) BufStart)              /* the physical address mod 64K      */\
         &                                                                     \
        ((ULONG) 0xFFFF  )                                                     \
       )                                                                       \
      +                                                                        \
       ((ULONG)                                                                \
        ((BufSize)-1)                   /* up to last byte (but not to next!)*/\
       )                                                                       \
     )                                                                         \
     & (~0xFFFF)                                                                \
    )                                                                          \
    NE 0L                                                                      \
  )                                     /* non-zero if crosses 64k boundary  */


