/* semfisda.h */

/* Device Driver for IBM SDLC adapter: Global data                           */

/*****************************************************************************/
/* Trace data                                                                */
/*****************************************************************************/
#ifdef IBMSYNC_TRACE
UCHAR           TrcBuffer [TRC_BUFSIZE];
UCHAR          *TrcPtr      = TrcBuffer;
#endif

/*****************************************************************************/
/* Bus Type (Eisa, Isa or MicroChannel.                                      */
/*****************************************************************************/
INTERFACE_TYPE    InterfaceType;

/*****************************************************************************/
/* 8273 data                                                                 */
/*****************************************************************************/
/* Commands, statically allocated, for copying into target device extension  */
/*                                                                           */
/* Note that only the first two bytes are required - opcode and length.      */
/* Other bytes must be written driver before command is used                 */
/*                                                                           */
/* Note also that the command may be overwritten if appropriate: e.g.        */
/* receive and DataTransferMode commands.                                    */
/*****************************************************************************/

UCHAR  LastWaitUntilStatus;
UCHAR  ProtoCmdStringReadPortA[]        = { 0x22, 0 };
UCHAR  ProtoCmdStringResetOpMode[]      = { 0x51, 1 };
UCHAR  ProtoCmdStringResetSerialIOMode[]= { 0x60, 1 };
UCHAR  ProtoCmdStringSetOpMode[]        = { 0x91, 1 };
UCHAR  ProtoCmdStringSetSerialIOMode[]  = { 0xa0, 1 };
UCHAR  ProtoCmdStringDataTransferMode[] = { 0x97, 1 };
UCHAR  ProtoCmdStringResetPortB[]       = { 0x63, 1 };
UCHAR  ProtoCmdStringSetPortB[]         = { 0xa3, 1 };
UCHAR  ProtoCmdStringReceive []         = { 0xc0, 2 };
UCHAR  ProtoCmdStringTransmit[]         = { 0xc8, 4 };
UCHAR  ProtoCmdStringAbortTransmit[]    = { 0xcc, 0 };
UCHAR  ProtoCmdStringDisableReceiver[]  = { 0xc5, 0 };

/*****************************************************************************/
/* FSM data                                                                  */
/*****************************************************************************/
char *RxFSMStateNames[] = {"RsId", "RsGo", "RsIH", "RsRH"};

char *RxFSMInputNames[] = {"RiGo", "RiSo", "RiHo", "RiRl", "RiGr", "RiEr"};

char *TxFSMStateNames[] = {"TsId", "TsAc", "TsTx", "TsAb", "TsCl"};

char *TxFSMInputNames[] = {"TiGo", "TiEo", "TiSo", "TiAb", "TiEr"};

/*****************************************************************************/
/* This is the declaration of the Receiver FSM                               */
/*****************************************************************************/

typedef struct _RXFSMENTRY          /* one entry in Rx FSM                   */
{
    int         NewState;
    void        (*pRxActionRoutine) (PDX);
}
                RXFSMENTRY;

RXFSMENTRY      RxFSM [RXFSMINPUTCOUNT ] [RXFSMSTATECOUNT] =
{
       /* Input = RxFSMInputStart            Start the receiver */
  {
    {  RxFSMStateReady ,RxFSMActionStart  },/* RX State = Idle */
    {  RxFSMStateReady ,  FSMNullAction   },/* RX State = Ready */
    {  RxFSMStateRdyHld,  FSMNullAction   },/* RX State = Idle (held) */
    {  RxFSMStateRdyHld,  FSMNullAction   } /* RX State = Ready(held) */
  },
       /* Input = RxFSMInputStop             Stop the receiver */
  {
    {  RxFSMStateIdle  ,  FSMNullAction   },/* RX State = Idle */
    {  RxFSMStateIdle  ,RxFSMActionStop   },/* RX State = Ready */
    {  RxFSMStateIdlHld,  FSMNullAction   },/* RX State = Idle (held) */
    {  RxFSMStateIdlHld,  FSMNullAction   } /* RX State = Ready(held) */
  },
       /* Input = RxFSMInputHold             Stop the receiver during Tx DMA */
  {
    {  RxFSMStateIdlHld,  FSMNullAction   },/* RX State = Idle */
    {  RxFSMStateRdyHld,RxFSMActionStop   },/* RX State = Ready */
    {  RxFSMStateIdlHld,  FSMNullAction   },/* RX State = Idle (held) */
    {  RxFSMStateRdyHld,  FSMNullAction   } /* RX State = Ready(held) */
  },
       /* Input = RxFSMInputRelease          Restart the receiver after Tx DMA*/
  {
    {  RxFSMStateIdle  ,RxFSMActionInvalid},/* RX State = Idle */
    {  RxFSMStateReady ,RxFSMActionInvalid},/* RX State = Ready */
    {  RxFSMStateIdle  ,  FSMNullAction   },/* RX State = Idle (held) */
    {  RxFSMStateReady ,RxFSMActionRestart} /* RX State = Ready(held) */
  },
       /* Input = RxFSMInputGoodReceive      Receiver interrupt - good result */
  {
    {  RxFSMStateIdle  ,RxFSMActionInvalid},/* RX State = Idle */
    {  RxFSMStateReady ,RxFSMActionRcvOK  },/* RX State = Ready */
    {  RxFSMStateIdlHld,RxFSMActionInvalid},/* RX State = Idle (held) */
    {  RxFSMStateRdyHld,RxFSMActionInvalid} /* RX State = Ready(held) */
  },
       /* Input = RxFSMInputReceiverError    Receiver interrupt - bad result */
  {
    {  RxFSMStateIdle  ,RxFSMActionInvalid}, /* RX State = Idle */
    {  RxFSMStateReady ,RxFSMActionRcvError},/* RX State = Ready */
    {  RxFSMStateIdlHld,  FSMNullAction   }, /* RX State = Idle (held) */
    {  RxFSMStateRdyHld,  FSMNullAction   }  /* RX State = Ready(held) */
  }
};

/*****************************************************************************/
/* This is the declaration of the Transmitter FSM                            */
/*****************************************************************************/

typedef struct _TXFSMENTRY          /* one entry in Rx FSM                   */
{
    int         NewState;
    void        (*pTxActionRoutine) (PDX);
}
                TXFSMENTRY;

TXFSMENTRY      TxFSM [TXFSMINPUTCOUNT ] [TXFSMSTATECOUNT]  =
{
       /* Input = TxFSMInputStart            Start a transmission. */
  {
    {  TxFSMStateTxing   ,TxFSMActionStart   },  /* TX State = Idle */
    {  TxFSMStateTxing   ,TxFSMActionXmitNext},  /* TX State = Active */
    {  TxFSMStateTxing   ,  FSMNullAction    },  /* TX State = Transmitting */
    {  TxFSMStateAborting,  FSMNullAction    },  /* TX_State = Wait for abort compl */
    {  TxFSMStateAborting,  FSMNullAction    }   /* TX_State = Closing Down */
  },
       /* Input = TxFSMInputEOTX             Good Transmission completion */
  {
    {  TxFSMStateIdle    ,TxFSMActionInvalid },  /* TX State = Idle */
    {  TxFSMStateActive  ,TxFSMActionInvalid },  /* TX State = Active */
    {  TxFSMStateActive  ,TxFSMActionEndOK   },  /* TX State = Transmitting */
    {  TxFSMStateAborting,  FSMNullAction    },  /* TX_State = Wait for abort compl */
    {  TxFSMStateClosing ,  FSMNullAction    }   /* TX_State = Closing Down */
  },
       /* Input = TxFSMInputStop             Stop the transmitter. */
  {
    {  TxFSMStateIdle    ,  FSMNullAction    },  /* TX State = Idle */
    {  TxFSMStateIdle    ,TxFSMActionStop    },  /* TX State = Active */
    {  TxFSMStateClosing ,TxFSMActionAbort   },  /* TX State = Transmitting */
    {  TxFSMStateClosing ,  FSMNullAction    },  /* TX_State = Wait for abort compl */
    {  TxFSMStateClosing ,  FSMNullAction    }   /* TX_State = Closing Down */
  },
       /* Input = TxFSMInputAbortd           Abort Complete interrupt received. */
  {
    {  TxFSMStateIdle    ,TxFSMActionInvalid },  /* TX State = Idle */
    {  TxFSMStateActive  ,TxFSMActionInvalid },  /* TX State = Active */
    {  TxFSMStateTxing   ,TxFSMActionInvalid },  /* TX State = Transmitting */
    {  TxFSMStateTxing   ,TxFSMActionXmitNext},  /* TX_State = Wait for abort compl */
    {  TxFSMStateIdle    ,TxFSMActionStop    }   /* TX_State = Closing Down */
  },
       /* Input = TxFSMInputEOTx_Err         Error Completion interrupt received */
  {
    {  TxFSMStateIdle    ,TxFSMActionInvalid },  /* TX State = Idle */
    {  TxFSMStateActive  ,TxFSMActionInvalid },  /* TX State = Active */
    {  TxFSMStateActive  ,TxFSMActionEndError},  /* TX State = Transmitting */
    {  TxFSMStateAborting,  FSMNullAction    },  /* TX_State = Wait for abort compl */
    {  TxFSMStateClosing ,  FSMNullAction    }   /* TX_State = Closing Down */
  }
};

/*****************************************************************************/
/* Configuration data                                                        */
/*****************************************************************************/


CONFIGDATA ConfigData[] =
{                                           /* must be in ADAPTER_TYPE order */
/* DL$01 */
        { AT_SDLC, "SDLC1",(IO_ADDRESS)0x380, 0,           1,      0,       0,
                           1 /*AddrSpace*/,
                           0 /*BusNumber*/,
                              3,3,FALSE,Latched,
                           0,   0,FALSE,Latched  /* IRQ4 cut ! */
        },
/* DL$02 */
        { AT_SDLC, "SDLC1",(IO_ADDRESS)0x380, 0,           1,      0,       0,
                           1 /*AddrSpace*/,
                           0 /*BusNumber*/,
                              3,3,FALSE,Latched,
                              4,4,FALSE,Latched
        },
/* DL$03 */
        { AT_MPCA1,"MPCA1",(IO_ADDRESS)0x380, 0,           1, (IO_ADDRESS)
                                                              0x3AF,    0x0A,
                           1 /*AddrSpace*/,
                           0 /*BusNumber*/,
                              4,4,FALSE,Latched,  /* 0x0A => IRQ4, DMA chan 1 */
                           0,   0,FALSE,Latched
        },
/* DL$04 */
        { AT_MPCA2,"MPCA2",(IO_ADDRESS)0x3a0, 0,           0, (IO_ADDRESS)
                                                              0x38F,    0x09,
                           1 /*AddrSpace*/,
                           0 /*BusNumber*/,
                              3,3,FALSE,Latched,  /* 0x09 => IRQ3, no DMA     */
                           0,   0,FALSE,Latched
        },
/* DL$05 */
        { AT_MPAA1,"MPAA1",(IO_ADDRESS)0x380, POS_IDMPAA1, 1,     0,       0,
                           1 /*AddrSpace*/,
                           0 /*BusNumber*/,
                              3,3,TRUE,LevelSensitive,
                           0,   0,TRUE,LevelSensitive
        },
/* DL$06 */
        { AT_MPAA2,"MPAA2",(IO_ADDRESS)0x3A0, POS_IDMPAA2, 7,     0,       0,
                           1 /*AddrSpace*/,
                           0 /*BusNumber*/,
                              4,4,TRUE,LevelSensitive,
                           0,   0,TRUE,LevelSensitive
        },
};

/*****************************************************************************/
/* Dummy Interface Record for use until the real one comes along, or once    */
/* the real one goes away - so we can do initialisation and wrap up without  */
/* worrying about generating events for anon-existent IR.                    */
/*****************************************************************************/

IR      InitIR = {0};

