/*****************************************************************************
*   Function:   display_which_cyrix(unsigned char dir0, unsigned char dir1)  *
*                                                                            *
*   Purpose:    print to screen Cyrix CPU type based on old technique        *
*               using device id registers                                    *
*                                                                            *
*   Parameters: unsigned char dir0  - Cyrix CPU DIR0 register value          *
*               unsigned char dir1  - Cyrix CPU DIR1 register value          *
*   Returns:    Nothing                                                      *
*   Calls:      Nothing                                                             *
*****************************************************************************/            
#include <stdio.h>
#include "cpu_type.h"

void display_which_cyrix (unsigned char dir0, unsigned char dir1)
   {
   switch ( dir0 )
      {
      case (UNKNOWN_VENDER):
         printf ("\n UNKNOWN CPU Manufacturer");
         break;

      case (Cx486_SLC):
         printf ("\n Cx486SLC(tm)");
         break;

      case (Cx486_DLC):
         printf ("\n Cx486DLC(tm)");
         break;

      case (Cx486_SLC2):
         printf ("\n Cx486SLC2(tm)");
         break;

      case (Cx486_DLC2):
         printf ("\n Cx486DLC2(tm)");
         break;

      case (Cx486_SRx):
         printf ("\n Cx486SRx(tm)");
         break;

      case (Cx486_DRx):
         printf ("\n Cx486DRx(tm)");
         break;

      case (Cx486_SRx2):
         printf ("\n Cx486SRx2(tm)");
         break;

      case (Cx486_DRx2):
         printf ("\n Cx486DRx2(tm)");
         break;

      case (Cx486S):
         printf ("\n Cx486S(tm)");
         break;

      case (Cx486S2):
         printf ("\n Cx486S2(tm)");
         break;

      case (Cx486Se):
         printf ("\n Cx486Se(tm)");
         break;

      case (Cx486S2e):
         printf ("\n Cx486S2e(tm)");
         break;

      case (Cx486DX):
         printf ("\n Cx486DX(tm)");
         break;

      case (Cx486DX2):
         printf ("\n Cx486DX2(tm)");
         break;

      case (Cx486_pr):
         printf ("\n Cx486SLC/DLC(tm) pre DIR regs");
         break;

      case (Cx486S_a):
         printf ("\n Cx486Sa(tm)");
         printf ("Step=1");
         break;

      case (Cx486DX4):
         printf ("\n Cx486DX4(tm)");
         break;

      case (_5x86_1xs):
      case (_5x86_1xp):
         printf ("\n Cyrix 5x86(tm)  core/clock = 1/1");
         break;
      case (_5x86_2xs):
      case (_5x86_2xp):
         printf ("\n Cyrix 5x86(tm)  core/clock = 2/1");
         break;
      case (_5x86_3xs):
      case (_5x86_3xp):
         printf ("\n Cyrix 5x86(tm)  core/clock = 3/1");
         break;
      case (_5x86_4xs):
      case (_5x86_4xp):
         printf ("\n Cyrix 5x86(tm)  core/clock = 4/1");
         break;

      case (_6x86_1xs):
      case (_6x86_1xp):
         printf ("\n Cyrix 6x86(tm)  core/clock = 1/1");
         break;
      case (_6x86_2xs):
      case (_6x86_2xp):
         printf ("\n Cyrix 6x86(tm)  core/clock = 2/1");
         break;
      case (_6x86_3xs):
      case (_6x86_3xp):
         printf ("\n Cyrix 6x86(tm)  core/clock = 3/1");
         break;
      case (_6x86_4xs):
      case (_6x86_4xp):
         printf ("\n Cyrix 6x86(tm)  core/clock = 4/1");
         break;

      case (Gx86_3xs):
      case (Gx86_3xp):
         printf ("\n Cyrix Gx86(tm)  core/clock = 3/1");
         break;
      case (Gx86_4xs):
      case (Gx86_4xp):
         printf ("\n Cyrix Gx86(tm)  core/clock = 3/1");
         break;


      case (m2_1xs):
      case (m2_1xp): 
         printf ("\n Cyrix M2(tm)  core/clock = 1/1");
         break;
      case (m2_2xs):
      case (m2_2xp): 
         printf ("\n Cyrix M2(tm)  core/clock = 2/1");
         break;
      case (m2_2p5xs):
      case (m2_2p5xp): 
         printf ("\n Cyrix M2(tm)  core/clock = 2.5/1");
         break;
      case (m2_3xs):
      case (m2_3xp): 
         printf ("\n Cyrix M2(tm)  core/clock = 3/1");
         break;
      case (m2_3p5xs):
      case (m2_3p5xp): 
         printf ("\n Cyrix M2(tm)  core/clock = 3.5/1");
         break;
      case (m2_4xs):
      case (m2_4xp): 
         printf ("\n Cyrix M2(tm)  core/clock = 4/1");
         break;
      case (m2_4p5xs):
      case (m2_4p5xp): 
         printf ("\n Cyrix M2(tm)  core/clock = 4.5/1");
         break;
      case (m2_5xs):
      case (m2_5xp): 
         printf ("\n Cyrix M2(tm)  core/clock = 5/1");
         break;

      default:
         printf ("\n Unknown Cyrix CPU");
         printf ("\n Device Type = %x",dir0);
         printf ("\n Step=%x, Rev=%x", (dir1 & 0xf0) >> 4, dir1 & 0x0f);
         break;
      }
   }   

