/*****************************************************************************
*   Function:  main ()                                                       *
*                                                                            *
*   Purpose:   1) Display Cyrix CPU revision                                 *
*              2) Display Cyrix FPU detection                                *
*                                                                            *
*   Parameters:   Nothing                                                    *
*   Returns:      Nothing                                                    *
*   Calls:                                                                   *
*              is_cpuid_supported () - 1 if CPUID instruction supported      *
*              cpu_type ()    - Returns int containing CPU identification    *
*              isfpu()        - 1 if fpu is present, 0 if not                *
*              iscyrixfpu()   - 1 if Cyrix fpu, 0 if not                     *
*              get_cpuid_info () - execute CPUID instruction                 *
*              is486()           - 1 if 486 CPU support available            *
*              display_which_cyrix - print CPU type based on dir1 and dir0   *
*****************************************************************************/            
#include <stdio.h>
#include <string.h>
#include "cpu_type.h"
#include "cx_funcs.h"            

#define TRUE      1
#define FALSE     0

void main (int argc, char *argv[])
   {
   unsigned short x;
   long cpuid_levels, reg_eax, reg_ebx, reg_edx, reg_ecx;
   long vender[4];
   unsigned char dir0, dir1;
   int cpuid_supported;
   unsigned int family, model, stepping;

   dir0 = UNKNOWN_VENDER;
   cpuid_supported = FALSE;

   if ( is_cpuid_supported () )
      {
      cpuid_supported = TRUE;

      reg_eax = reg_ebx= reg_ecx = reg_edx =0;
      get_cpuid_info (0, &reg_eax, &reg_ebx, &reg_ecx, &reg_edx);

      cpuid_levels = reg_eax;

      vender[0] = reg_ebx;
      vender[1] = reg_edx;
      vender[2] = reg_ecx;
      vender[3] = 0;

      printf ("\n vender = %s",vender);
      printf ("\n cpuid levels supported %ld",cpuid_levels);

      if (cpuid_levels > 0)
         {
         reg_eax = reg_ebx= reg_ecx = reg_edx =0;
         get_cpuid_info (1, &reg_eax, &reg_ebx, &reg_ecx, &reg_edx);

         family   = (reg_eax & 0xf00) >> 8;
         model    = (reg_eax & 0xf0) >> 4;
         stepping =  reg_eax & 0xf;

         if ((strcmp ("CyrixInstead", (char *)vender) == 0))
            {
            if (family == 5)
               printf ("\n Cyrix 6x86 CPU");

            if (family == 6)
               printf ("\n Cyrix m2 CPU");

            }

         printf ("\n  family = %d, model = %d, stepping = %d", family,
                                                             model,
                                                             stepping);

         printf ("\n    FPU  %s",  reg_edx & 1        ? "yes": "no");
         printf ("\n    VME  %s",  reg_edx & 2        ? "yes": "no");
         printf ("\n    DE   %s",  reg_edx & 4        ? "yes": "no");
         printf ("\n    PSE  %s",  reg_edx & 8        ? "yes": "no");
         printf ("\n    TSE  %s",  reg_edx & 0x10     ? "yes": "no");
         printf ("\n    MSR  %s",  reg_edx & 0x20     ? "yes": "no");
         printf ("\n    PAE  %s",  reg_edx & 0x40     ? "yes": "no");
         printf ("\n    MCE  %s",  reg_edx & 0x80     ? "yes": "no");
         printf ("\n    CXS  %s",  reg_edx & 0x100    ? "yes": "no");
         printf ("\n    APIC %s",  reg_edx & 0x200    ? "yes": "no");
         printf ("\n    MTRR %s",  reg_edx & 0x1000   ? "yes": "no");
         printf ("\n    PGE  %s",  reg_edx & 0x2000   ? "yes": "no");
         printf ("\n    MCA  %s",  reg_edx & 0x4000   ? "yes": "no");
         printf ("\n    CMOV %s",  reg_edx & 0x8000   ? "yes": "no");
         printf ("\n    MMX  %s",  reg_edx & 0x800000 ? "yes": "no");
         }

      }

   /* Check for need to use old Cyrix Detection Technique */
   /* or is 'c' on command line forcing old detection     */
   if ( (!cpuid_supported || *argv [1]=='c') && is486() && iscyrix() )                
      {
      /* We are going to use the old Cyrix Detection Method */
      printf ("\n Cyrix CPU detected");
      cpu_type(&dir0, &dir1);

      if (dir0 != UNKNOWN_VENDER)
         printf ("\n Device ID Regs, dir0 = %x, dir1 = %x", dir0, dir1);

      display_which_cyrix (dir0, dir1);

      if (dir0 != UNKNOWN_VENDER && dir0 != Cx486S_a)
         printf ("\n Step=%x, Rev=%x", (dir1 & 0xf0) >> 4, dir1 & 0x0f);
      }


   if (isfpu())
      {
      if (iscyrixfpu ())
         printf ("\n Cyrix Coprocessor");
      else
         printf ("\n Other Coprocessor");
      }
   else
      printf ("\n No Coprocessor");

   }
/****************************************************************************/

