#
#  (C) Copyright Promise Technology, Inc., 1994
# This source file is the property of Promise Technology Inc.
# It may not be copied or distributed in any isomorphic form
# without an appropriate prior licensing arrangement with 
# Promise Technology, Inc.
# Shell script to add new disks for SCO UNIX
# NOTE:
# 1. drivenum is for each controller, e.g drive 2 controller 1
#    while disknum is for the system. 
# 2. About disknum, it is set as the next available integer in
#    the system.
#    That is, disknum is determined by the order you mkdev your disk.
#    E.g there has already been one ST506 controller with one drive,
#	 now, if we install a new PTI controller as a secondary card,
# 	 with only one drive as the card's 3rd drive. 
#        Then this new drive's:
#		drivenum = 3
#		ctrlnum  = 1
#	        disknum = 1 (after 0).
# 3. The variable, "minor_seed" is determined only by drivenum.
#
NOBRANDPRODUCTNAME="Caching Controller Driver V1.10"
PROMISEPRODUCTNAME="DC-200 UNIX Driver V1.10"
PRODUCTDATE=19930510
ADAPTERNAME="DC-200 "

TMPFILE=/tmp/tmp$$
TMPFILE2=${TMPFILE}2
OK=0
FAIL=1
STOP=10
PATH=/etc:/bin:/usr/bin
export PATH
umask 0

# borrow the same back-end functions as mkdev/hd
if [ -f /usr/lib/mkdev/.hdfuncs ]
then
	PTIFILE=/usr/lib/mkdev/.hdfuncs 
else
	PTIFILE=/usr/lib/mkdev/hd
fi



sed -e '/"\$disknum" = /s/\[ .* \]/\[ "\$disknum" != "0" \]/g' $PTIFILE > $TMPFILE
if [ "$PTIFILE" = "/usr/lib/mkdev/hd" ]
then  
	grep -n "begin main"  $TMPFILE > $TMPFILE2 
	AAA=`cut -d : -f 1 $TMPFILE2`
	echo "sed -e '$AAA,\$d' $TMPFILE > /tmp/ptifile$$" > $TMPFILE2
	chmod +x $TMPFILE2
	$TMPFILE2
else
	mv $TMPFILE /tmp/ptifile$$
fi
. /tmp/ptifile$$

# cd to root
cd /

# set a trap so that if the user dels out, a value of $STOP
# is passed to the calling program
settrap() {
	trap 'echo ptidiskadd command aborted. >&2
	cleanup $FAIL'	1 2 3 15
}

# unset the traps
unsettrap() {
	trap '' 1 2 3 15
}

#
#### START HERE !!!
#

echo "\n\nWhich controller will the hard disk be attached to?\n" 
echo " 1. the primary or singel controller"
echo " 2. the secondary controller"
echo "\nPlease choose answer(1 or 2)(default=1): \c"
read AAA
if [ "$AAA" = "2" ]
then
	ADAPTER=1
	major=54
else
	ADAPTER=0
	major=1
fi

echo "\n\nWhich cable (of this controller) will the hard disk be attached to?\n"
echo " 1. the first or single cable"
echo " 2. the second cable"
echo "\nPlease choose answer(1 or 2)(default=1): \c"
read AAA
if [ "$AAA" = "2" ]
then
	CABLE=1
else
	CABLE=0
fi

echo "\n\nWill the hard disk be the master(single) or slave drive on this cable?\n" 
echo " 1. the master or single hard disk"
echo " 2. the slave hard disk"
echo "\nPlease choose answer(1 or 2)(default=2): \c"
read AAA
if [ "$AAA" = "1" ]
then
	DRIVE=0
else
	DRIVE=1
fi 
#
#drivenum and ctrlnum determined here
#
drivenum=`expr $CABLE \* 2 + $DRIVE`
ctrlnum=$ADAPTER

arch=AT

if [ "$ctrlnum" = "0" -a "$drivenum" = "0" ]
then
	echo "It is not necessary to add the root disk once more.\n"
	cleanup $FAIL
fi

[ -x "/bin/sed" ] || error no_sed

#
# !!!!!! DC400
#
ptigands g $ctrlnum $drivenum

echo "\n\nDo you want to change them(Y/N)? (default=Y) \c"
read AAA
if [ "$AAA" = "Y" -o "$AAA" = "y" -o "$AAA" = "" ]
then
	while [ 1 ]
	do
	echo "\n CYLINDERS: \c"
	read cyl
	echo " HEADS    : \c"
	read head
	echo " SECTORS  : \c"
	read sect
	ptigands s $ctrlnum $drivenum $cyl $head $sect
	if [ $? = 0 ] 
	then
		echo "
		sed -e '/adapter $ctrlnum drive $drivenum/s/^.*$/$cyl, $head, $sect,	\/* adapter $ctrlnum drive $drivenum *\/ \/* DC400 *\//g' /etc/conf/pack.d/wd/space.c > $TMPFILE
		mv $TMPFILE /etc/conf/pack.d/wd/space.c" > $TMPFILE2
		chmod +x $TMPFILE2
		$TMPFILE2
		/etc/conf/bin/idbuild
		break
	fi
	done
fi
#
# !!!!!! DC400
#

newtype=W
# get variable "rootdisk ", in .hdfuncs
get_root_type

# set the traps
settrap

# set minor numbers, minor_0, minor_1, minor_2, ... according to 
# drivenum, HDFUNCS 
set_minors

# determine variables, "disknum" & "cdev", HDFUNCS
set_disknum

# create devices 
fix

# get disk parameters and call dkinit to display/change
# hard disk characteristics, HDFUNCS
interactive=YES
rundparam

# fdisk and badtrack, HDFUNCS
diskprep

# divide the disk into file systems
rundivvy
echo "\nHard disk initialization procedure completed.\n"
cleanup $OK
