/***************************************************************************
** roltypes.h
***************************************************************************/

#ifndef _ROLTYPES_H_
#define _ROLTYPES_H_

typedef unsigned char BYTE;
typedef unsigned short BYTE2;
typedef unsigned int BYTE4;

typedef BYTE2 Time;

typedef struct {
   Time time;
   float tempo;
} TempoEvent;

typedef struct {
   BYTE2 note;
   BYTE2 duration;
} NoteEvent;


typedef struct {
   Time time;
   char instrumName[9];
   char filler;
   BYTE2 timbreIndex;
} InstrumEvent;

typedef struct {
   Time time;
   float volume;
} VolumeEvent;

typedef struct {
   Time time;
   float pitch;
} PitchEvent;

typedef struct {
   BYTE2   major, minor;
   char    filler1 [40];
   BYTE2   ticks_in_beat;
   BYTE2   beats_in_measure;
   BYTE2   axis_y, axis_x;
   char    filler2;
   char    music_mode;
   char    filler3 [90+38+15];
   float   basic_tempo;
} Rol_Header;

#endif  /* _ROLTYPES_H_ */

