/***************************************************************************
** graphics.c
***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <dos.h>
#include <string.h>
#include <math.h>
#include <ctype.h>
#include <dir.h>

#include "general.h"

const vidMem = 0xA000;

/**************************************************************************
** round2
**
** Rounds a float to the closest int. Takes into actions which direction
** the current line is being drawn when it has a 50:50 decision about
** where to put a pixel.
**************************************************************************/
int round2(float aNumber, float dirn)
{
   if (dirn < 0)
      return ((aNumber - floor(aNumber) <= 0.501)? floor(aNumber) : ceil(aNumber));
   return ((aNumber - floor(aNumber) < 0.499)? floor(aNumber) : ceil(aNumber));
}


/**************************************************************************
** putpix2
**
** Draws a pixel on the screen (agi style).
**************************************************************************/
void putpix2(int x, int y, byte c)
{
   asm {
      mov es, vidMem
      mov di, x
      mov ah, y
      shl di, 1
      xor al, al
      add di, ax
      shr ax, 1
      mov cl, c
      shr ax, 1
      add di, ax
      mov [es:di], cl
      mov [es:di+1], cl
   }
}

/**************************************************************************
** putpix
**
** Draws a pixel on the screen.
**************************************************************************/
void putpix(int x, int y, byte c)
{
   asm {
      mov es, vidMem
      mov di, x
      mov ah, y
      xor al, al
      add di, ax
      shr ax, 1
      mov cl, c
      shr ax, 1
      add di, ax
      mov [es:di], cl
   }
}

/**************************************************************************
** getpix
**
** Get colour at x,y on the screen.
**************************************************************************/
byte getpix(int x, int y)
{
   byte retVal;

   hideCursor();

   asm {
      mov es, vidMem
      mov di, x
      mov ah, y
      xor al, al
      add di, ax
      shr ax, 1
      shr ax, 1
      add di, ax
      mov al, [es:di]
      mov retVal, al
   }

   showCursor();

   return (retVal);
}

void drawChar(unsigned char aChar, int x, int y, int foreColour, int backColour)
{
   int fontSegment, fontOffset, fontByte, byteNum, bytePos;

   fontSegment = *(unsigned int *)MK_FP(0, 0x43*4+2);
   fontOffset = *(unsigned int *)MK_FP(0, 0x43*4);

   for (byteNum = aChar*8; byteNum<=(aChar*8+7); byteNum++) {
      fontByte = *(byte *)MK_FP(fontSegment, fontOffset+byteNum);
      for (bytePos = 7; bytePos>=0; bytePos--) {
	if (fontByte & (1 << bytePos))
	   putpix(x+(7-bytePos)+8, y+(byteNum-(aChar*8)), foreColour);
	else
	   putpix(x+(7-bytePos)+8, y+(byteNum-(aChar*8)), backColour);
      }
   }
}

void drawString(char *aString, int x, int y, int foreColour, int backColour)
{
   int charPos;

   for (charPos=0; charPos<strlen(aString); charPos++)
      drawChar(aString[charPos], x+(charPos-1)*8, y, foreColour, backColour);
}

/**************************************************************************
** normline2
**
** Draws a normal line.
**************************************************************************/
void normline2(int x1, int y1, int x2, int y2, int c)
{
   int height, width, startX, startY;
   float x, y, addX, addY;

   height = (y2 - y1);
   width = (x2 - x1);
   addX = (height==0?height:(float)width/abs(height));
   addY = (width==0?width:(float)height/abs(width));

   if (abs(width) > abs(height)) {
      y = y1;
      addX = (width == 0? 0 : (width/abs(width)));
      for (x=x1; x!=x2; x+=addX) {
	 putpix2(round2(x, addX), round2(y, addY), c);
	 y+=addY;
      }
      putpix2(x2,y2,c);
   }
   else {
      x = x1;
      addY = (height == 0? 0 : (height/abs(height)));
      for (y=y1; y!=y2; y+=addY) {
	 putpix2(round2(x, addX), round2(y, addY), c);
	 x+=addX;
      }
      putpix2(x2,y2,c);
   }
}

/**************************************************************************
** normline
**
** Draws a normal line.
**************************************************************************/
void normline(int x1, int y1, int x2, int y2, int c)
{
   int height, width, startX, startY;
   float x, y, addX, addY;

   height = (y2 - y1);
   width = (x2 - x1);
   addX = (height==0?height:(float)width/abs(height));
   addY = (width==0?width:(float)height/abs(width));

   if (abs(width) > abs(height)) {
      y = y1;
      addX = (width == 0? 0 : (width/abs(width)));
      for (x=x1; x!=x2; x+=addX) {
	 putpix(round2(x, addX), round2(y, addY), c);
	 y+=addY;
      }
      putpix(x2,y2,c);
   }
   else {
      x = x1;
      addY = (height == 0? 0 : (height/abs(height)));
      for (y=y1; y!=y2; y+=addY) {
	 putpix(round2(x, addX), round2(y, addY), c);
	 x+=addX;
      }
      putpix(x2,y2,c);
   }
}


void drawBox(int left, int top, int right, int bottom, int c)
{
   memset(MK_FP(0xA000, top*320+left), c, (right-left)+1);
   normline(right, top, right, bottom, c);
   normline(left, bottom, left, top, c);
   memset(MK_FP(0xA000, bottom*320+left), c, (right-left)+1);
}

void drawFilledBox(int left, int top, int right, int bottom, int c)
{
   int y;

   for (y=top; y<=bottom; y++)
      memset(MK_FP(0xA000, y*320+left), c, (right-left)+1);
}

void drawCircle(int x, int y, int radius, int c)
{
   int xPos, yPosA, yPosB;
   int oldX=0, oldYA=0, oldYB=0;

   for (xPos=(-radius); xPos<=radius; xPos++) {
      yPosA = round2(sqrt(((radius*radius)-(xPos*xPos))), -1);
      yPosB = (-1)*round2(sqrt(((radius*radius)-(xPos*xPos))), -1);
      putpix(xPos+x, yPosA+y, c);

      putpix(xPos+x, yPosB+y, c);
      if ((oldX != 0) && (oldYA != 0) && (oldYB != 0)) {
	 normline(oldX, oldYA, xPos+x, yPosA+y, c);
	 normline(oldX, oldYB, xPos+x, yPosB+y, c);
      }

      oldX = xPos+x;
      oldYA = yPosA+y;
      oldYB = yPosB+y;
   }
}
