{
    GetResourceNum1.pas - Dialog box to get resource number
    Copyright (C) 1997-1999 Peter Kelly <peter@area51.org.au>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
}

unit GetResourceNum1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type TWindowFunction = (MainRenumberResource,ViewEditSaveAsResource,LogEditGetNum);

type
  TGetResourceNum = class(TForm)
    Label1: TLabel;
    NumberEdit: TEdit;
    OKBut: TButton;
    CancelBut: TButton;
    procedure CancelButClick(Sender: TObject);
    procedure NumberEditChange(Sender: TObject);
    procedure OKButClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    ResType : byte;
    OldNum : byte;
    WindowFunction : TWindowFunction;
    ViewEditorNum : byte;
    OKPressed : boolean;
  end;

var
  GetResourceNum: TGetResourceNum;

implementation

uses VolMan2, ViewEdit1;

{$R *.DFM}

procedure TGetResourceNum.CancelButClick(Sender: TObject);
begin
  Close;
end;

procedure TGetResourceNum.NumberEditChange(Sender: TObject);
var TempNum      : integer;
    Code         : integer;
begin
  Val(NumberEdit.Text,TempNum,Code);
  if (Code = 0) and (TempNum >= 0) and (TempNum <= 255) then
    OKBut.Enabled := True
  else OKBut.Enabled := False;
end;

procedure TGetResourceNum.OKButClick(Sender: TObject);
begin
  if WindowFunction = MainRenumberResource then
    RenumberResource(ResType,OldNum,StrToInt(NumberEdit.Text))
  else if WindowFunction = ViewEditSaveAsResource then
    ViewEditWin[ViewEditorNum].SaveAsResource(StrToInt(NumberEdit.Text));
  OKPressed := True;
  Close;
end;

procedure TGetResourceNum.FormShow(Sender: TObject);
begin
  case WindowFunction of
    MainRenumberResource: begin
                            Label1.Caption := 'Enter new resource number (0-255):';
                            GetResourceNum.Caption := 'Resource number';
                          end;
    ViewEditSaveAsResource: begin
                              Label1.Caption := 'Enter view number (0-255):';
                              GetResourceNum.Caption := 'View editor';
                            end;
    LogEditGetNum: begin
                     Label1.Caption := 'Enter logic number (0-255):';
                     GetResourceNum.Caption := 'Logic editor';
                   end;
  end;
  OKPressed := False;
  NumberEdit.SelectAll;
end;

end.
