/***************************************************************************
** play.c
**
** This is just a simple MIDI player that uses the Allegro library. It's
** provided with the AGI sound package just in case you don't have a MIDI
** player (unlikely).
***************************************************************************/

#include <stdio.h>
#include <allegro.h>

void main(int argc, char *argv[])
{
   FILE *fmid;
   MIDI *the_music;
   long size;

   if (argc<2) {
      printf("play <midi-file>\n");
   }
   else {
      allegro_init();
      install_keyboard();
      install_timer();

      if (install_sound(DIGI_NONE, MIDI_AUTODETECT, NULL) != 0) {
         printf("Error initialising sound card.\n%s\n", allegro_error);
         exit(0);
      }

      the_music = load_midi(argv[1]);

      play_midi(the_music, TRUE);
      readkey();
      destroy_midi(the_music);

      allegro_exit();
   }
}
