//---------------------------------------------------------------------------
#include "scihdr.h"     
#include "explorer.h"
#include "addresource.h"
//---------------------------------------------------------------------------
RESIDX	ResIdx;

RESTYPE resTypes[TOTAL_RES_TYPES3] = {
	{0x00, 0x80, "View",		"Views",	"v16", "v", "animated elements",
    	3, &edtWnds[rsVIEW], NULL,
        "SCI View Resource (view.*)|view.*|All Files (*.*)|*.*"},//WndExplorer->ViewPage},
	{0x01, 0x81, "Pic",		"Pics", 	"p16", "p", "background pictures",
    	4, &edtWnds[rsPIC], NULL,
        "SCI Pic Resource (pic.*)|pic.*|All Files (*.*)|*.*"},//WndExplorer->PicPage},
	{0x02, 0x82, "Script",	"Scripts",	"scr", "s", "scripts contain the code telling the game what to do, and how to interact with the player",
    	5, &edtWnds[rsSCRIPT], NULL,
        "SCI Script Resource (script.*)|script.*|All Files (*.*)|*.*"},//WndExplorer->MemoPage},
	{0x03, 0x83, "Text",		"Texts",	"tex", "t", "text resources link with the scripts, allowing the game to store external, easy to modify text",
    	6, &edtWnds[rsTEXT], NULL,
        "SCI Text Resource (text.*)|text.*|All Files (*.*)|*.*"},//WndExplorer->MemoPage},
	{0x04, 0x84, "Sound",		"Sounds",	"snd", "m", "sound effects and music",
    	7, &edtWnds[rsSOUND], NULL,
        "SCI Sound Resource (sound.*)|sound.*|All Files (*.*)|*.*"},//WndExplorer->SoundPage},
	{0x05, 0x85, "Memory",	"Memory",	"mem", "X", "internal memory allocated a runtime. (not stored in resources)",
    	8, NULL, NULL,""},//WndExplorer->PageNoPrev},
	{0x06, 0x86, "Vocab",		"Vocabs",	"voc", "w", "vocabulary resources all have different purposes, but primarily deal with parsing the player's input",
    	9, &edtWnds[rsVOCAB], NULL,
        "SCI Vocab Resource (vocab.*)|vocab.*|All Files (*.*)|*.*"},//WndExplorer->MemoPage},
	{0x07, 0x87, "Font",		"Fonts",	"fon", "f", "fonts, the text styles drawn by the game",
    	10, &edtWnds[rsFONT], NULL,
        "SCI Font Resource (font.*)|font.*|All Files (*.*)|*.*"},//WndExplorer->FontPage},
	{0x08, 0x88, "Cursor",	"Cursors",	"cur", "c", "mouse graphics to show the position of the cursor",
    	11, &edtWnds[rsCURSOR], NULL,
        "SCI Cursor Resource (cursor.*)|cursor.*|All Files (*.*)|*.*"},//WndExplorer->CursorPage},
	{0x09, 0x89, "Patch",		"Patches",	"pat", "a", "sound patch files for dealing with the source drivers",
    	12, NULL, NULL,
        "SCI Patch Resource (patch.*)|patch.*|All Files (*.*)|*.*"},//WndExplorer->PageNoPrev},

	{0x0A, 0x00, "Script Header",	"Headers",	"sch", "h", "source code header files",
    	13, NULL, NULL,""},//WndExplorer->MemoPage},

	{0x0B, 0x00, "Game Explorer",	"",	"", "", "resources are managed by the Game Explorer",
    	15, &edtWnds[wnEXPLORER], NULL,""},//WndExplorer->MemoPage},
};

char szTemp[1024];
U8 *bufTemp;
//---------------------------------------------------------------------------
BOOL LoadMap()
{
	FILE	*fMap;
	U32		ulMapLen;
	U8		*mapBuf,*mapPtr;
    S32		curEnt,totalEnt;  
    RESINFO *ri;
    FILE *fPack;
    U16 ident;
    U32 addr;

    // load the map
    if((fMap=ssOpenFile(ssFIO_GAME|ssFIO_MESSAGE,"resource.map","rb"))==0) return FALSE;
    ulMapLen = ssFileLen(fMap);

    // no bugs in the champagne room=make sure the map is valid
    if(ulMapLen < rmMIN_SIZE) {
		ssMessage(ssERROR,"Invalid resource.map file! File too small!");   
        ssCloseFile(fMap);
        return FALSE;
    }

    // Load the map
	mapBuf = (U8*)ssAlloc(ulMapLen);
    mapPtr = mapBuf;
    ssFRead(mapBuf,ulMapLen,fMap);
    ssCloseFile(fMap);

    curEnt = ulMapLen/6;
    // parse the map
    // two loop breakers to make sure of no crashing!
    totalEnt = 0;
    do {                  
		ident = ssBGetW(mapPtr);
		addr = ssBGetL((mapPtr+2));
    	if(ident==0xFFFF&&addr==0xFFFFFFFF) break;
		mapPtr+=6;
        totalEnt++;
        curEnt--;
    } while(curEnt);

    // Read the map data and load the resource headers into memory

    // first load them up with the map data
    InitResInfo(TRUE);
    for(int t=0;t<TOTAL_RES_TYPES;t++) {
    	mapPtr = mapBuf;
        BOOL first=TRUE;
        ri = NULL;
    	for(int i=0;i<totalEnt;i++) {
        	if(rmGET_TYPE(ssBGetW(mapPtr))==t) {
    			ri = AddResInfo(ri, (U8) t, (U8) rmGET_PACKAGE(ssBGetL(((U8*)mapPtr+2))), (U16) rmGET_NUMBER(ssBGetW(mapPtr)), (U32) rmGET_OFFSET(ssBGetL(((U8*)mapPtr+2))));
                if(first) {
                	first=FALSE;
                	ResIdx.resInfo[t] = ri;
             	}
            }
            mapPtr+=6;
        }
        if(ri!=NULL) ri->next = NULL;
    }
    // now get rid of the map, it's wasting memory!
    ssFree(mapBuf);

    // fill in the rest of the res headers by reading the packages
    for(int p=0;p<=ResIdx.maxPack;p++) {
		sprintf(szTemp,"resource.%03d",p);
        fPack = ssOpenFile(ssFIO_GAME,szTemp,"rb");
    	for(int t=0;t<TOTAL_RES_TYPES;t++) {
    		if(ResIdx.totalRes[t]&&ResIdx.resInfo[t]!=NULL) {
       	     	ri = ResIdx.resInfo[t];
        		do {
                	if(ri->pack==p) {
                    	if(!fPack) {
                        	ssMessage(ssERROR,"Could not open file: %s! "MSG_DEFRESERROR,szTemp);
                            DisposeResInfo();
                        	return FALSE;
                        }
                    	fseek(fPack,ri->offset,SEEK_SET);
                 		ident = ssFGetW(fPack);
                    	if(rmGET_TYPE(ident)!=ri->type||rmGET_NUMBER(ident)!=ri->number) {
                       		ssMessage(ssERROR,"Resource package/map file identifier mismatch! "MSG_DEFRESERROR);
                        	DisposeResInfo();
                       		return FALSE;
                    	}
                       if(ri->number==10&&ri->type==1)
                       		ri=ri;
						ri->encSize	= (U16)((U16)ssFGetW(fPack)-(U16)4);
						ri->size 	= (U16)ssFGetW(fPack);
						ri->encType = (U16)ssFGetW(fPack);
                    }
                    ri = ri->next;
        		} while(ri!=NULL);
        	}
    	}
        ssCloseFile(fPack);
    }



	return TRUE;
}
//---------------------------------------------------------------------------
void InitResInfo(BOOL ALLOCATE)
{
	int i;

    ResIdx.totalAllocs = 0;
    ResIdx.lastAlloc = NULL;
    ResIdx.maxPack = 0;

	for(i=0;i<TOTAL_RES_TYPES;i++) {
    	ResIdx.totalRes[i] = 0; 
    	ResIdx.resInfo[i] = NULL;
    }
    if(ALLOCATE) AllocResMem();
}
//---------------------------------------------------------------------------
void DisposeResInfo()
{
	int i;
               
	for(i=0;i<TOTAL_RES_TYPES;i++) {
    	ResIdx.totalRes[i] = 0;
    	ResIdx.resInfo[i] = NULL;
    }

	for(i=ResIdx.totalAllocs-1;i>=0;i--)
    	ssFree(ResIdx.allocBufs[i]);
    ResIdx.maxPack = 0;

    ResIdx.totalAllocs = 0;
    ResIdx.lastAlloc = NULL;
}
//---------------------------------------------------------------------------
void AllocResMem()
{
	if(ResIdx.totalAllocs+1>=rsMAX_ALLOCS) {
    	ssMessage(ssERROR,"Unable to allocate enough memory for the resource map entries! The map must be corrupt as no map would be this large!");
        Application->Terminate();
        return;
    }
    ResIdx.lastAlloc = (RESINFO*)ssAlloc(sizeof(RESINFO)*rsALLOCBUFSZ);
	ResIdx.allocBufs[ResIdx.totalAllocs] = ResIdx.lastAlloc;
    ResIdx.allocPtr = 0;
    ResIdx.totalAllocs++;
}
//---------------------------------------------------------------------------
RESINFO *AddResInfo(RESINFO *prev, U8 type, U8 pack, U16 number, U32 offset)
{
	if(!ResIdx.lastAlloc||ResIdx.allocPtr+1>=rsALLOCBUFSZ) {
		AllocResMem();
    } else
    	ResIdx.allocPtr++;
    ResIdx.lastAlloc++;
    if(ResIdx.maxPack<pack) ResIdx.maxPack=pack;

    ResIdx.lastAlloc->type = type;
    ResIdx.lastAlloc->number = number;
    ResIdx.lastAlloc->pack = pack;
    ResIdx.lastAlloc->offset = offset;

    if(prev!=NULL) prev->next = ResIdx.lastAlloc;
	ResIdx.lastAlloc->next = NULL;
	ResIdx.lastAlloc->prev = prev;
                          
    if(!ResIdx.resInfo[type])
    	ResIdx.resInfo[type] = ResIdx.lastAlloc;

    ResIdx.totalRes[type]++;

    return ResIdx.lastAlloc;
}
//---------------------------------------------------------------------------
void DelResInfo(RESINFO *resInfo)
{
	ResIdx.totalRes[resInfo->type]--;
    if(ResIdx.resInfo[resInfo->type]==resInfo)
    	ResIdx.resInfo[resInfo->type] = resInfo->next;
    if(ResIdx.totalRes[resInfo->type]==0) {
		ResIdx.resInfo[resInfo->type] = NULL;
    } else {
		if(resInfo->prev) resInfo->prev->next = resInfo->next;
    	if(resInfo->next) resInfo->next->prev = resInfo->prev;
    }
    resInfo->type = 0xFF;
}
//---------------------------------------------------------------------------
void AddResInfoStruct(RESINFO *resInfo)
{
	RESINFO *ri = ResIdx.resInfo[resInfo->type];
    if(!ResIdx.totalRes[resInfo->type]) {
		ResIdx.resInfo[resInfo->type] = resInfo;
        resInfo->next = NULL;
        resInfo->prev = NULL;
    } else {
		do {
        	ri = ri->next;
        } while(ri->next!=NULL);
        ri->next = resInfo;
		resInfo->prev = ri;
    	resInfo->next = NULL;
    }
	ResIdx.totalRes[resInfo->type]++;
}                                       
//---------------------------------------------------------------------------
RESINFO *FindLastResInfo(int type)
{
	RESINFO *ri = ResIdx.resInfo[type];
    while(ri) {
    	if(ri->next==NULL) return ri;
		ri = ri->next;
    }
    return ri;
}
//---------------------------------------------------------------------------
// opens the map, seeks to the location of the resource entry and returns the file handle
FILE *FindMapEntry(RESINFO *resInfo, U32 *ml)
{
	FILE *fMap;  
    U32 ulMapLen;
    U16 ident;
    U32 addr;

    // load the map
    if((fMap=ssOpenFile(ssFIO_GAME|ssFIO_MESSAGE,"resource.map","rb+"))==0) return NULL;
    ulMapLen = ssFileLen(fMap);

    // make sure the map is valid
    if(ulMapLen < rmMIN_SIZE) {
		ssMessage(ssERROR,"Invalid resource.map file! File too small!");
        ssCloseFile(fMap);
        return NULL;
    }

    for(U32 i=0;i<ulMapLen;i+=6) {
    	ident = ssFGetW(fMap);
        if(rmGET_NUMBER(ident)==resInfo->number&&rmGET_TYPE(ident)==resInfo->type) {
        	addr = ssFGetL(fMap);
           	if((U8)rmGET_PACKAGE(addr)==resInfo->pack&&rmGET_OFFSET(addr)==resInfo->offset) {
            	ssFSeek(fMap,-6,SEEK_CUR);
                if(ml) *ml = ulMapLen;
                return fMap;
            }
        } else ssFSeek(fMap,4,SEEK_CUR);
    }
    ssCloseFile(fMap);
    ssMessage(ssERROR,"Could not locate resource %s.%03d in the resource.map!",resTypes[resInfo->type].name,resInfo->number);
    return NULL;
}
//---------------------------------------------------------------------------
BOOL DelMapEntry(RESINFO *resInfo)
{
    U16 copyLen;
    U8 *buf;
	FILE *fMap;
    U32 ulMapLen;
    U16 offset;

    // load the map
    if((fMap=FindMapEntry(resInfo,&ulMapLen))==NULL) return FALSE;

    offset = (U16)ftell(fMap);
    fseek(fMap,6,SEEK_CUR);
    copyLen = (U16)((U16)ulMapLen-offset-6);
    buf = (U8*)ssAlloc(copyLen);
    ssFRead(buf,copyLen,fMap);
    ssFSeek(fMap,offset,SEEK_SET);
    ssFWrite(buf,copyLen,fMap);
    ssFree(buf);
    ssCloseFile(fMap);
    DelResInfo(resInfo);

    return TRUE;
}
//---------------------------------------------------------------------------
RESINFO *AddResource(U8 *buf, U16 len, U8 type, S16 number, U8 pack)
{        
	FILE *fMap,*fPack;
    U32 ulMapLen;
    U16 ident;
    U32 addr;
    U32 packOffset;
    U8 *mBuf;

    // load the map
    if((fMap=ssOpenFile(ssFIO_GAME|ssFIO_MESSAGE,"resource.map","rb+"))==0) return NULL;
    ulMapLen = ssFileLen(fMap);
    // make sure the map is valid
    if(ulMapLen < rmMIN_SIZE) {
		ssMessage(ssERROR,"Invalid resource.map file! File too small!");
        ssCloseFile(fMap);
        return FALSE;
    }

    // Ask the user for which package to store the resource and
    // what number to use.
    DlgAddResource = new TDlgAddResource(WndExplorer);
    DlgAddResource->ResourceType = AnsiString(resTypes[type].name);
    DlgAddResource->NumberEdit->Text  = IntToStr(number);
    DlgAddResource->PackageEdit->Text = IntToStr(pack);
    DlgAddResource->NumberEditChange(DlgAddResource->NumberEdit);
    DlgAddResource->ShowModal();
	delete DlgAddResource;

    // they pressed cancel, no res will be added
    if(WndExplorer->dlgCANCLOSE) {
        ssCloseFile(fMap);
        return FALSE;
    }

	number = (S16)WndExplorer->adrsNumber;
	pack = (U8)WndExplorer->adrsPackage;

    // Load the pack
    sprintf(szTemp,"resource.%03d",pack);
    if((fPack=ssOpenFile(ssFIO_GAME|ssFIO_MESSAGE,szTemp,"rb+"))==0) return NULL;
//    ulPackLen = ssFileLen(fPack);

    // move all the current entries forward 6 bytes so that the new entry is at the beginning!
	mBuf = (U8*)ssAlloc(ulMapLen);
    ssFRead(mBuf,ulMapLen,fMap);
    ssFSeek(fMap,6,SEEK_SET);
    ssFWrite(mBuf,ulMapLen,fMap);
    ssFree(mBuf);
    // Now write the new entry!

    // First to the package!
	ident = (U16)rmSET_TYPE(type)|(U16)rmSET_NUMBER(number);
    ssFSeek(fPack,0,SEEK_END);
    packOffset = ftell(fPack);
    ssFPutW(ident,fPack);	 // identifier (same as map)
    ssFPutW(len+4,fPack);  	 // actual length
    ssFPutW(len,fPack);  // encoded length
    ssFPutW(0,fPack);		 // encoding method (0-none)
    ssFWrite(buf,len,fPack);
    ssCloseFile(fPack);
    ssFSeek(fMap,0,SEEK_SET);

	addr = rmSET_PACKAGE(pack)|rmSET_OFFSET(packOffset);
    ssFPutW(ident,fMap);
    ssFPutL(addr,fMap);

    ssCloseFile(fMap);  

	RESINFO *ri = AddResInfo(FindLastResInfo(type), type, pack, number, packOffset);
    ri->size = len;
    ri->encSize = len;
    ri->encType = 0;

    return ri;
}
//---------------------------------------------------------------------------
/* The following are used in both decryption algorithms: */
#define MAXBIT 0x2000
unsigned int whichbit = 0;
unsigned char bits[(MAXBIT>>3)+3];

/*****************  Decryption Method 1  *******************************/

unsigned int getbits1(int numbits, FILE *handle) /* handles bitstrings length 9-12 */
{
  int place;
  unsigned long bitstring;
  if (whichbit >= MAXBIT) {
    whichbit -= MAXBIT;
    ssFRead(bits, (MAXBIT >> 3)+3, handle);
    ssFSeek(handle, -3L, SEEK_CUR);
  }
  place = whichbit >> 3;
  bitstring = bits[place] | (long)((bits[place+1])<<8)
	      | (long)((bits[place+2])<<16);
  bitstring >>= (whichbit & 7);
  bitstring &= 0xffffffffUL >> (32-numbits);
  whichbit += numbits;
  return bitstring;
}

#define STACKSIZE 8192
char stack[STACKSIZE];
int stackptr;
void push(char c) {
  stack[stackptr++] = c;
  if (stackptr >= STACKSIZE) {
    ssMessage(ssERROR,"Stack overflow!");
    Application->Terminate();
  }
}
char *popall(char *dest) {
  while (stackptr-- > 0) *(dest++) = stack[stackptr];
  stackptr++;
  return dest;
}

void decryp1(FILE *handle, char *data)
{                
  unsigned int field, linkindex = 0x102, nextindex = 0, newindex = 0,
      maxindex = 0x200, width = 9;
  U8 *links, lastbyte=0, linkbyte=0;
  links = (U8*)ssAlloc(12300);
  whichbit = MAXBIT;
  stackptr = 0;
  while ((field = getbits1(width, handle)) != 0x101) { /* exit on 0x101 */
    if (field == 0x100) { /* start over from beginning of table */
      linkindex = 0x102;
      width = 9;
      maxindex = 0x200;
      nextindex = field = getbits1(width, handle);
      lastbyte = linkbyte = (U8)(field & 0xff);
      *(data++) = (char)lastbyte;
    }
    else {
      newindex = field;
      if (field >= linkindex) { /* if it's a forward reference, */
	push(lastbyte);         /* repeat the last thing */
	field = nextindex;
      }
      while (field > 0xff) { /* trace links back */
	push(links[field*3+2]);
	field = (int)(links[field*3]) | (int)((links[field*3+1]) << 8);
      }
      lastbyte = linkbyte = (U8)field;
      push(lastbyte);
      data = popall(data);
      links[linkindex*3+2] = linkbyte;
      links[linkindex*3+1] = (U8)(nextindex >> 8);
      links[linkindex*3+0] = (U8)(nextindex & 0xff);
      linkindex++;
      nextindex = newindex;
      if (linkindex >= maxindex && width != 12) {
	width++;
	maxindex <<= 1;
      }
    }
  }
  ssFree(links);
}

/*****************  Decryption Method 2  *******************************/
/*This is basically byte-token huffman coding, except that a prefix of
  1 signals a literal byte. In fact, most bytes are literal; only extremely
  common ones are put in the huffman tree. */

char getbits2(int numbits, FILE *handle) /* handles bitstrings length 1-8 */
{
  int bitstring, place;
  if (whichbit >= MAXBIT) {
    whichbit -= MAXBIT;
    ssFRead(bits, (MAXBIT >> 3)+3, handle);
    ssFSeek(handle, -3L, SEEK_CUR);
  }
  place = whichbit >> 3;
  bitstring = bits[place] << 8;
  bitstring |= bits[place+1] & 0x00ff;
  bitstring >>= 16-numbits-(whichbit & 7);
  bitstring &= 0xffffu >> (16-numbits);
  whichbit += numbits;
  return (char)bitstring;
}

int getc2(U8 *node, FILE *handle)
{
  int next;
  while (node[1] != 0) {
    if (getbits2(1, handle)) {
      next = node[1] & 0xf; /* low 4 bits */
      if (next == 0) return (getbits2(8, handle) | 0x100);
    }
    else next = node[1] >> 4; /* high 4 bits */
    node += next*2;
  }
  return (int)*node;
}

void decryp2(FILE *handle, char *data)
{
  U8 numnodes, terminator;
  char *nodes;
  int c;
  numnodes = (U8)ssFGetB(handle);
  terminator = (U8)ssFGetB(handle);
  nodes = (char*)ssAlloc(2*numnodes); 
  ssFRead(nodes, 2*numnodes, handle);
  whichbit = MAXBIT;
  while ((int)(c = getc2((U8*)nodes, handle)) != (int)(0x0100 | (int)terminator)) {
    *data = (char)c;
    data++;
  }
  ssFree(nodes);
}


// mode -
//        erFILE/erBUFFER/erFILENAME
//        erSHOW_MESSAGES
// 	if file mode, it extracts it to a file (if erFILENAME set, to a specified
//	file, otherwise, it asks the user). If buffer mode, it allocates a
//	buffer and extracts it there, returning a pointer
//
char dirPath[1024];
U8 *ExtractResource(RESINFO *resInfo, U8 mode, U16 *len, char *fileName)
{
	FILE *fPack,*fOut;
    U16 ident;
    U8 *decBuf;
    AnsiString s;

    // Load the pack
    sprintf(dirPath,"resource.%03d",resInfo->pack);
    if((fPack=ssOpenFile(ssFIO_GAME|ssFIO_MESSAGE,dirPath,"rb"))==0) return FALSE;

    if(mode&erFILENAME) {
        strcpy(dirPath,fileName);
    } else if(mode & erFILE) {
     	WndExplorer->SaveDialog->Filter = FilterAllRes;
        WndExplorer->SaveDialog->FileName = s.sprintf("%s.%03d", resTypes[resInfo->type].name, resInfo->number);
        if(!WndExplorer->SaveDialog->Execute()) {
        	ssCloseFile(fPack);
            return NULL;
        }
        //ExtractedFileName.sprintf("%s\\%s.%03d", DirDialog->FullPath, TypeNames[Type], ResourceNumber);
        strcpy(dirPath,WndExplorer->SaveDialog->FileName.c_str());
    }

//    ulPackLen = ssFileLen(fPack);

    ssFSeek(fPack,resInfo->offset,SEEK_SET);
    ident = ssFGetW(fPack);
    if(rmGET_TYPE(ident)!=resInfo->type||rmGET_NUMBER(ident)!=resInfo->number) {       
    	if(mode&erSHOW_MESSAGES)
    		ssMessage(ssERROR,"Resource package/map file identifier mismatch! "MSG_DEFRESERROR);
        else
        	WndExplorer->PreviewPC->ActivePage = WndExplorer->ErrPage;
   	 	DisposeResInfo();
        return FALSE;
    }                            
    resInfo->encSize = (U16)((U16)ssFGetW(fPack)-(U16)4);
    resInfo->size = (U16)ssFGetW(fPack);
    if(!resInfo->size) {
   		ssCloseFile(fPack);
    	return NULL;
    }
    resInfo->encType = ssFGetW(fPack);
    decBuf = (U8*)ssAlloc(resInfo->size);
    switch(resInfo->encType) {
		case 0:
    		ssFRead(decBuf,resInfo->size,fPack);
            break;
        case 1:
        	decryp1(fPack, (char*)decBuf);
            break;
        case 2:
        	decryp2(fPack, (char*)decBuf);
            break;
        default:
    		if(mode&erSHOW_MESSAGES)
            	ssMessage(ssERROR,"Unknown encoding method! "MSG_DEFRESERROR);
            else
            	WndExplorer->PreviewPC->ActivePage = WndExplorer->UnkComPage;
			ssFree(decBuf);
    		ssCloseFile(fPack);
            return NULL;
    }
   	ssCloseFile(fPack);

    if(mode&erFILE||mode&erFILENAME) {
    	if((fOut=ssOpenFile(ssFIO_ROOT|ssFIO_MESSAGE,dirPath,"wb"))==0) return NULL;
        ssFPutW(MAKE_RESFILE_HEADER(resInfo->type),fOut);
        ssFWrite(decBuf,resInfo->size,fOut);
        ssCloseFile(fOut);
    	ssFree(decBuf);
        decBuf = (U8*) 1;
    } else {
     	if(len) *len = resInfo->size;
    }

    return decBuf;
}
//---------------------------------------------------------------------------
BOOL ExtractAllRes(char *path, int type)
{
	BOOL fERROR = FALSE;
    RESINFO *resInfo;
	resInfo = ResIdx.resInfo[type];
    while(resInfo) {
    	sprintf(szTemp,"%s\\%s.%03d",path,resTypes[type].name,resInfo->number);
		if(!ExtractResource(resInfo, erFILENAME, NULL, szTemp))
			fERROR = TRUE;
    	resInfo = resInfo->next;
    }
    return fERROR;
}
//---------------------------------------------------------------------------
RESINFO *FindRes(U8 type, int number, int pack, long offset)
{
	RESINFO *ri = ResIdx.resInfo[type];
    while(ri) {
       	if(ri->number == number||number==-1) {
        	if(pack==ri->pack||pack==-1)
        		if(offset==(long)ri->offset||offset==-1)
         			return ri;
        }
    	ri = ri->next;
    }

    return ri;
}
//---------------------------------------------------------------------------
int CheckSCIFileHeader(U8 *rBuf)
{
	if(((rBuf[0]&0xF0)!=0x80)||(rBuf[1]!=0x00)) return -1;
    return rBuf[0]&0x0F;
}
//---------------------------------------------------------------------------
int GetFileExtNumber(char *s)
{
	int sLen = strlen(s);
    if(sLen<5) return -1;
    char *se=s+sLen-3;
	if(!CheckStringNum(se)) return -1;
	return StrToInt(AnsiString(se));
}                            
//---------------------------------------------------------------------------
BOOL CheckStringNum(char *str)
{
	 int CharPos = 0;
	 if(str[0] == '\0') return FALSE;
	 if(str[0] == '0'&&(str[1]=='x'||str[1]=='X')) {
		  if(str[2] == '\0') return FALSE;
		  CharPos+=2;
		  while(str[CharPos] != '\0')
				if(!((str[CharPos] >= '0' && str[CharPos] <= '9') ||
				((char)(str[CharPos] & 0xDF) >= 'A' && (char)(str[CharPos] & 0xDF) <= 'F')))
					 return FALSE;
				else CharPos++;
	 } else {
		  if(str[0] == '+' || str[0] == '-') {
				CharPos++;
				if(str[1] == '\0') return FALSE;
		  }
		  while(str[CharPos] != '\0')
				if(str[CharPos] < '0' || str[CharPos] > '9')
						  return FALSE;
				else CharPos++;
	 }
	 return TRUE;
}                                                  
//---------------------------------------------------------------------------
AnsiString AnsiStringFmtRes(int type, int number)
{
 	AnsiString s;
    s.sprintf("%s.%03d",resTypes[type].name,number);
    return s;
}
//---------------------------------------------------------------------------

void SetResIDfo(RESIDFO *resIDfo, RESINFO *resInfo)
{
    resIDfo->type = resInfo->type;	// the currently open resource
    resIDfo->number = resInfo->number;
    resIDfo->pack = resInfo->pack;
    resIDfo->size = resInfo->size;
}
//---------------------------------------------------------------------------


