/////////////////////////////////////////////////////
//
// SourceCodeDlgUI.cpp
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    provides event handlers for user-interface
//    events such as button presses, etc., for the
//    Source Code property page; also provides functions
//    that update the user interface as necessary to
//    reflect the current state of the application
//
// Portability information:
//    this file contains code written specifically for
//    a Win32 build of the BLG
//
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
//
// includes
//
/////////////////////////////////////////////////////

#include "DefineNameList.h"
#include "DefineNameDlg.h"
#include "SourceCodeDlgUI.h"

/////////////////////////////////////////////////////
//
// globals
//
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
// declared in SourceCodeDlgEventHandlers.cpp
extern HWND g_hwndSourceCodeDlg;
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
// declared in MainDlgEventHandlers.cpp
extern CDefineNameList g_deflist;
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
//
// OnSourceCodeDlgButtonEditDefines
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles clicks of the Edit Defines button
// Return value:
//    TRUE if the event was handled; FALSE if Windows
//    needs to handle it
//
/////////////////////////////////////////////////////

BOOL OnSourceCodeDlgButtonEditDefines()
{
    DefineNameDlgDoModal(g_hwndSourceCodeDlg, g_deflist);
    return TRUE;
}