/////////////////////////////////////////////////////
//
// PositionCtrlDlg.h
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    defines the public interface for the Position
//    Control dialog
//
// Portability information:
//    this file contains code written specifically
//    for a Win32 build of the BLG
//
/////////////////////////////////////////////////////

// make sure this header can't be included twice
#if !defined(POSITION_CTRL_DLG_H_INCLUDED)
#define POSITION_CTRL_DLG_H_INCLUDED

#include <windows.h>
#include "BLGDefs.h"

// use POSCTRLDLG_MODE_ADD to put the position control dialog in
// Add mode...used POSCTRLDLG_MODE_EDIT to put it into Edit mode
#define POSCTRLDLG_MODE_ADD  0
#define POSCTRLDLG_MODE_EDIT 1

/////////////////////////////////////////////////////
//
// PositionCtrlDlgDoModal
//
/////////////////////////////////////////////////////
//
// Purpose:
//    provides a somewhat abstract interface to the
//    Position Control dialog so that modules that need
//    to use this dialog don't have to worry about
//    any of the details of displaying the dialog box;
//    this function also takes care of the details of
//    applying changes when the user clicks OK and
//    discarding changes when the user clicks Cancel
// Parameter nMode:
//    either POSCTRLDLG_MODE_ADD or POSCTRLDLG_MODE_EDIT;
//    the primary difference between Add mode and Edit
//    mode is the window title on the dialog box;
//    additionally, in edit mode, the contents of the
//    parameter epc are used to initialize the dialog
//    box's controls
// Parameter epc:
//    input/output parameter; when the function is
//    called, this parameter is used to initialize
//    the dialog box's controls, if the dialog box
//    is in Edit mode; if the user dismisses
//    the dialog box with the OK button, then changes
//    will be saved to this parameter; if the user
//    clicks the Cancel button, then the parameter
//    will retain the value it had when the function
//    was called
// Return value:
//    IDOK if the user dismisses the dialog with
//    the OK button; IDCANCEL if the user dismisses
//    the dialog box any other way
//
/////////////////////////////////////////////////////

int PositionCtrlDlgDoModal(int nMode, 
                           EGOPOSITIONCONTROL& epc);

#endif // !defined(POSITION_CTRL_DLG_H_INCLUDED)