/////////////////////////////////////////////////////
//
// OptionsDlg.cpp
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    implements the interface for the Options
//    dialog and contains its dialog box procedure
//
// Portability information:
//    this file contains code written specifically
//    for a Windows build of the BLG
//
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
//
// includes
//
/////////////////////////////////////////////////////

#include <windowsx.h>

#include "resource.h"
#include "GeneralUI.h"
#include "CommentsPropSheetPage.h"
#include "SourceCodePropSheetPage.h"
#include "CompiledCodePropSheetPage.h"
#include "QuotesPropSheetPage.h"
#include "OptionsDlg.h"

/////////////////////////////////////////////////////
//
// defines
//
/////////////////////////////////////////////////////

#define OPTIONS_DLG_PAGE_COUNT 4

/////////////////////////////////////////////////////
//
// globals
//
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
// declared in AGIBLG.cpp
extern HINSTANCE g_hInstance;
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
// declared in MainDlgEventHandlers.cpp
extern HWND g_hwndMainDlg;
/////////////////////////////////////////////////////

BOOL g_bOptionsDlgCentered;
COptions g_optionsTemp;

/////////////////////////////////////////////////////
//
// OptionsDlgProc
//
/////////////////////////////////////////////////////
//
// Purpose:
//    dialog box procedure for the Options dialog
// Parameters:
//    consult a Windows API reference for the meanings
//    of the parameters
// Return value:
//    TRUE if the BLG handled the event and Windows
//    doesn't need to; FALSE if Windows should handle
//    the event
// Remarks:
//    to prevent the window procedure from getting
//    too large, this function calls event handler
//    functions to handle specific messages
//
/////////////////////////////////////////////////////

int CALLBACK OptionsDlgProc(HWND hDlg, UINT uiMsg, LPARAM lParam)
{
    // this is actually a property sheet procedure, so it looks
    // a little different from the other dialog procedures
    switch(uiMsg)
    {
    case PSCB_INITIALIZED:
        break;

    case PSCB_PRECREATE:
        break;

    default:
        break;
    }

    return 0;
}

/////////////////////////////////////////////////////
//
// OptionsDlgDoModal
//
/////////////////////////////////////////////////////
//
// Purpose:
//    provides a somewhat abstract interface to the
//    Options dialog so that modules that need
//    to use this dialog don't have to worry about
//    any of the details of displaying the dialog box;
//    this function also takes care of the details of
//    applying changes when the user clicks OK and
//    discarding changes when the user clicks Cancel
// Parameter options:
//    input/output parameter; when the function is
//    called, this parameter is used to initialize
//    the dialog box's controls; if the user dismisses
//    the dialog box with the OK button, then changes
//    will be saved to this parameter; if the user
//    clicks the Cancel button, then the parameter
//    will retain the value it had when the function
//    was called
// Return value:
//    IDOK if the user dismisses the dialog with
//    the OK button; IDCANCEL if the user dismisses
//    the dialog box any other way
//
/////////////////////////////////////////////////////

int OptionsDlgDoModal(COptions& options)
{
    BOOL bResult;

    g_optionsTemp.BecomeCopy(&options);

    // initialize the property sheet

    PROPSHEETHEADER pshead;
    PROPSHEETPAGE apspage[OPTIONS_DLG_PAGE_COUNT];

    ZeroMemory(&pshead, sizeof(PROPSHEETHEADER));
    pshead.dwSize = sizeof(PROPSHEETHEADER);
    pshead.dwFlags = PSH_PROPSHEETPAGE |
                     PSH_USECALLBACK |
                     PSH_USEHICON |
                     PSH_NOAPPLYNOW;
    pshead.hwndParent = g_hwndMainDlg;
    pshead.hInstance = g_hInstance;
    pshead.hIcon = NULL;
    pshead.pszCaption = "Base Logic Generator Options";
    pshead.nPages = OPTIONS_DLG_PAGE_COUNT;
    pshead.nStartPage = 0;
    pshead.ppsp = apspage;
    pshead.pfnCallback = OptionsDlgProc;

    ZeroMemory(&apspage, sizeof(PROPSHEETPAGE));

    // add the Comments property sheet page
    apspage[0].dwSize = sizeof(PROPSHEETPAGE);
    apspage[0].dwFlags = PSP_USECALLBACK | PSP_USEICONID;
    apspage[0].hInstance = g_hInstance;
    apspage[0].pszTemplate = MAKEINTRESOURCE(IDD_DLG_COMMENTS);
    apspage[0].pszIcon = NULL;
    apspage[0].pfnDlgProc = CommentsDlgProc;
    apspage[0].lParam = 0;
    apspage[0].pfnCallback = CommentsPageProc;

    // add the Source Code property sheet page
    apspage[1].dwSize = sizeof(PROPSHEETPAGE);
    apspage[1].dwFlags = PSP_USECALLBACK | PSP_USEICONID;
    apspage[1].hInstance = g_hInstance;
    apspage[1].pszTemplate = MAKEINTRESOURCE(IDD_DLG_SOURCE_CODE);
    apspage[1].pszIcon = NULL;
    apspage[1].pfnDlgProc = SourceCodeDlgProc;
    apspage[1].lParam = 0;
    apspage[1].pfnCallback = SourceCodePageProc;

    // add the Compiled Code property sheet page
    apspage[2].dwSize = sizeof(PROPSHEETPAGE);
    apspage[2].dwFlags = PSP_USECALLBACK | PSP_USEICONID;
    apspage[2].hInstance = g_hInstance;
    apspage[2].pszTemplate = MAKEINTRESOURCE(IDD_DLG_COMPILED_CODE);
    apspage[2].pszIcon = NULL;
    apspage[2].pfnDlgProc = CompiledCodeDlgProc;
    apspage[2].lParam = 0;
    apspage[2].pfnCallback = CompiledCodePageProc;

    // add the Quotes property sheet page
    apspage[3].dwSize = sizeof(PROPSHEETPAGE);
    apspage[3].dwFlags = PSP_USECALLBACK | PSP_USEICONID;
    apspage[3].hInstance = g_hInstance;
    apspage[3].pszTemplate = MAKEINTRESOURCE(IDD_DLG_QUOTES);
    apspage[3].pszIcon = NULL;
    apspage[3].pfnDlgProc = QuotesDlgProc;
    apspage[3].lParam = 0;
    apspage[3].pfnCallback = QuotesPageProc;

    // g_bOptionsDlgCentered is a kludge solution to the problem
    // of centering a property sheet -- the docs on property sheets
    // really suck, and I don't seem to be able to center the property
    // sheet by responding to a PSCB_INITIALIZED message, so I just have
    // the first property sheet page call CenterDialogToParent for its
    // parent (rather than itself); THIS IS IMPORTANT: if you insert
    // a property sheet page at the beginning of the options property
    // sheet, make sure that the new page (and ONLY the new page) centers
    // the whole property sheet (and that it only does it ONCE, by
    // appropriately checking and setting g_bOptionsDlgCentered) --
    // if things aren't done this way, then the property sheet will get
    // centered every time a user switches to a different tab, or worse,
    // every time a user switches to certain tabs only, which could 
    // potentially annoy the crap out of them
    g_bOptionsDlgCentered = FALSE;

    bResult = PropertySheet(&pshead);

    if (bResult)
    {
        options.BecomeCopy(&g_optionsTemp);
    }

    return ((bResult) ? IDOK : IDCANCEL);
}
