/////////////////////////////////////////////////////
//
// MessageBoxesUI.h
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    prototypes for the BLG custom message boxes' user 
//    interface functions
//
// Portability information:
//    this file contains code written specifically
//    for a Win32 build of the BLG
//
/////////////////////////////////////////////////////

// make sure this header can't be included twice
#if !defined(MESSAGE_BOXES_UI_H_INCLUDED)
#define MESSAGE_BOXES_UI_H_INCLUDED

#include <windows.h>

/////////////////////////////////////////////////////
//
// functions for Unescaped Quote message boxes
//
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
//
// OnRadioIncludeQuotes
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles events related to the IDC_RADIO_INCLUDE_QUOTES
//    radio button for the Unescaped Quote msg box
// Return value:
//    TRUE if the event is handled; FALSE if Windows
//    needs to handle it
//
/////////////////////////////////////////////////////

BOOL OnRadioIncludeQuotes();

/////////////////////////////////////////////////////
//
// OnRadioRemoveQuotes
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles events related to the IDC_RADIO_REMOVE_QUOTES
//    radio button for the Unescaped Quote msg box
// Return value:
//    TRUE if the event is handled; FALSE if Windows
//    needs to handle it
//
/////////////////////////////////////////////////////

BOOL OnRadioRemoveQuotes();

/////////////////////////////////////////////////////
//
// OnRadioEditQuotes
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles events related to the IDC_RADIO_EDIT_QUOTES
//    radio button for the Unescaped Quote msg box
// Return value:
//    TRUE if the event is handled; FALSE if Windows
//    needs to handle it
//
/////////////////////////////////////////////////////

BOOL OnRadioEditQuotes();

/////////////////////////////////////////////////////
//
// OnUnescapedQuoteMessageBoxOK
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles clicks of the OK button for the Unescaped
//    Quotes msg box
// Return value:
//    TRUE if the event is handled; FALSE if Windows
//    needs to handle it
//
/////////////////////////////////////////////////////

BOOL OnUnescapedQuoteMessageBoxOK();

/////////////////////////////////////////////////////
//
// functions for Escaped Quote message boxes
//
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
//
// OnEscapedQuoteMsgBoxRadioRemoveBackslash
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles events related to the IDC_RADIO_REMOVE_BACKSLASH
//    radio button for the Escaped Quote msg box
// Return value:
//    TRUE if the event is handled; FALSE if Windows
//    needs to handle it
//
/////////////////////////////////////////////////////

BOOL OnEscapedQuoteMsgBoxRadioRemoveBackslash();

/////////////////////////////////////////////////////
//
// OnEscapedQuoteMsgBoxRadioIncludeBackslash
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles events related to the IDC_RADIO_INCLUDE_BACKSLASH
//    radio button for the Escaped Quote msg box
// Return value:
//    TRUE if the event is handled; FALSE if Windows
//    needs to handle it
//
/////////////////////////////////////////////////////

BOOL OnEscapedQuoteMsgBoxRadioIncludeBackslash();

/////////////////////////////////////////////////////
//
// OnEscapedQuoteMsgBoxRadioEditQuotes
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles events related to the IDC_RADIO_EDIT_QUOTES
//    radio button for the Escaped Quote msg box
// Return value:
//    TRUE if the event is handled; FALSE if Windows
//    needs to handle it
//
/////////////////////////////////////////////////////

BOOL OnEscapedQuoteMsgBoxRadioEditQuotes();

/////////////////////////////////////////////////////
//
// OnEscapedQuoteMessageBoxOK
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles clicks of the OK button for the Escaped
//    Quotes msg box
// Return value:
//    TRUE if the event is handled; FALSE if Windows
//    needs to handle it
//
/////////////////////////////////////////////////////

BOOL OnEscapedQuoteMsgBoxOK();


#endif // !defined(MESSAGE_BOXES_UI_H_INCLUDED)