/////////////////////////////////////////////////////
//
// MessageBoxes.h
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    defines the public interface for the BLG's
//    custom message boxes
//
// Portability information:
//    this file contains code written specifically
//    for a Windows version of the BLG
//
/////////////////////////////////////////////////////

// make sure this header can't be included twice
#if !defined(MESSAGE_BOXES_H_INCLUDED)
#define MESSAGE_BOXES_H_INCLUDED

#include <windows.h>

// the maximum string length for the pszControlName parameters that
// the custom message box functions can take
#define MAX_CONTROL_NAME_LEN 255

// return values related to the Unescaped Quote message box

// specifies that unescaped quotes should be converted to escaped quotes
#define UQMB_INCLUDE_QUOTES 100
// specifies that unescaped quotes should be deleted
#define UQMB_REMOVE_QUOTES  101
// specifies that the user wants to decide for themselves how to
// handle unescaped quotes
#define UQMB_USER_EDIT      IDCANCEL

/////////////////////////////////////////////////////
//
// UnescapedQuoteMessageBox
//
/////////////////////////////////////////////////////
//
// Purpose:
//    provides a somewhat abstract interface to the
//    Unescaped Quote msg box so that modules that need
//    to use this dialog don't have to worry about
//    any of the details of displaying the dialog box;
//    this function also takes care of the details of
//    applying changes when the user clicks OK and
//    discarding changes when the user clicks Cancel
// Parameter hwndParent:
//    the window handle of the window that is to become
//    the message box's parent
// Parameter pszControlName:
//    a null-terminated string specifying the name of the
//    control containing a string with unescaped quotes;
//    must not be NULL
// Return value:
//    one of the various UQMB values defined in MessageBoxes.h
//    that indicates how the user responded to the message box
// Remarks:
//    calling this function does not guarantee that a message
//    box will be displayed...if the user has checked the
//    "Don't ask again" option, then this function will simply
//    return the user's remembered response
//
/////////////////////////////////////////////////////

int UnescapedQuoteMessageBox(HWND hwndParent, PSTR pszControlName);

// return values related to the Escaped Quote message box

// specifies that escaped quotes should be converted to unescaped quotes
#define EQMB_REMOVE_BACKSLASH   100
// specifies that escaped quotes should be left as-is
#define EQMB_INCLUDE_BACKSLASH  101
// specifies that the user wants to decide for themselves how to handle
// escaped quotes
#define EQMB_USER_EDIT          IDCANCEL

/////////////////////////////////////////////////////
//
// EscapedQuoteMessageBox
//
/////////////////////////////////////////////////////
//
// Purpose:
//    provides a somewhat abstract interface to the
//    Escaped Quote msg box so that modules that need
//    to use this dialog don't have to worry about
//    any of the details of displaying the dialog box;
//    this function also takes care of the details of
//    applying changes when the user clicks OK and
//    discarding changes when the user clicks Cancel
// Parameter hwndParent:
//    the window handle of the window that is to become
//    the message box's parent
// Parameter pszControlName:
//    a null-terminated string specifying the name of the
//    control containing a string with unescaped quotes;
//    must not be NULL
// Return value:
//    one of the various EQMB values defined in MessageBoxes.h
//    that indicates how the user responded to the message box
// Remarks:
//    calling this function does not guarantee that a message
//    box will be displayed...if the user has checked the
//    "Don't ask again" option, then this function will simply
//    return the user's remembered response
//
/////////////////////////////////////////////////////

int EscapedQuoteMessageBox(HWND hwndParent, PSTR pszControlName);

#endif // !defined(MESSAGE_BOXES_H_INCLUDED)