/////////////////////////////////////////////////////
//
// EditDefineNameDlgUI.cpp
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    provides event handlers for user-interface
//    events such as button presses, etc., for the
//    Edit Define Name dialog; also provides functions
//    that update the user interface as necessary to
//    reflect the current state of the application
//
// Portability information:
//    this file contains code written specifically for
//    a Win32 build of the BLG
//
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
//
// includes
//
/////////////////////////////////////////////////////

#include "resource.h"
#include "BLGDefs.h"
#include "DefineNameList.h"
#include "EditDefineNameDlgUI.h"

/////////////////////////////////////////////////////
//
// global variables
//
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
// defined in EditDefineNameDlgEventHandlers.cpp
extern HWND g_hwndEditDefineNameDlg;
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
// defined in EditDefineNameDlg.cpp
extern char g_szDefineNameTemp[MAX_DEFINE_NAME_LEN + 1];
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
//
// OnEditDefineNameDlgOK
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles event for the Edit Define Name dialog's
//    OK button
// Return value:
//    TRUE if event is handled; FALSE otherwise
//
/////////////////////////////////////////////////////

BOOL OnEditDefineNameDlgOK()
{
    GetWindowText(GetDlgItem(g_hwndEditDefineNameDlg, IDC_EDIT_NEW_NAME),
                  g_szDefineNameTemp, MAX_DEFINE_NAME_LEN + 1);

    if (!CDefineNameList::IsValidDefineName(g_szDefineNameTemp))
    {
        MessageBox(g_hwndEditDefineNameDlg,
                   "Define names may contain only letters,\n"
                   "numbers, underscores, and periods and\n"
                   "may not contain spaces.",
                   "Define name error", MB_OK | MB_ICONEXCLAMATION);
        SetFocus(GetDlgItem(g_hwndEditDefineNameDlg, IDC_EDIT_NEW_NAME));
        return TRUE;
    }

    EndDialog(g_hwndEditDefineNameDlg, IDOK);

    return TRUE;
}