/////////////////////////////////////////////////////
//
// DefineNameDlgEventHandlers.h
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    prototypes for the Define Name dialog's
//    event handler functions
//
// Portability information:
//    this file contains code written specifically
//    for a Win32 build of the BLG
//
/////////////////////////////////////////////////////

// make sure this file can't be included twice
#if !defined(DEFINE_NAME_DLG_EVENT_HANDLERS_H_INCLUDED)
#define DEFINE_NAME_DLG_EVENT_HANDLERS_H_INCLUDED

#include "BLGDefs.h"

/////////////////////////////////////////////////////
//
// OnDefineNameDlgWMCommand
//
/////////////////////////////////////////////////////
//
// Purpose:
//    WM_COMMAND handler for the Define Name dialog
// Parameter hDlg:
//    the window handle of the dialog for which the
//    WM_COMMAND message needs to be handled
// Parameter wParam:
//    the wParam sent with the WM_COMMAND message
// Parameter lParam:
//    the lParam sent with the WM_COMMAND message
//
/////////////////////////////////////////////////////

BOOL OnDefineNameDlgWMCommand(HWND hDlg, WPARAM wParam, LPARAM lParam);

/////////////////////////////////////////////////////
//
// OnDefineNameDlgWMInitDialog
//
/////////////////////////////////////////////////////
//
// Purpose:
//    WM_INITDIALOG handler for the Define Name dialog
// Parameter hDlg:
//    the window handle of the dialog for which the
//    WM_INITDIALOG message needs to be handled
// Parameter wParam:
//    the wParam sent with the WM_INITDIALOG message
// Parameter lParam:
//    the lParam sent with the WM_INITDIALOG message
//
/////////////////////////////////////////////////////

BOOL OnDefineNameDlgWMInitDialog(HWND hDlg, WPARAM wParam, LPARAM lParam);

#endif // !defined(DEFINE_NAME_DLG_EVENT_HANDLERS_H_INCLUDED)