/////////////////////////////////////////////////////
//
// CommentsPropSheetPage.cpp
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    contains the property page procedure and dialog
//    box procedure for the Comments property page
//
// Portability information:
//    this file contains code written specifically
//    for a Win32 build of the BLG
//
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
//
// includes
//
/////////////////////////////////////////////////////

#include "BLGDefs.h"
#include "GeneralUI.h"
#include "CommentsDlgEventHandlers.h"
#include "CommentsPropSheetPage.h"

/////////////////////////////////////////////////////
//
// global variables
//
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
// defined in OptionsDlg.cpp
extern COptions g_optionsTemp;
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
//
// CommentsPageProc
//
/////////////////////////////////////////////////////
//
// Purpose:
//    property page procedure for the Comments property
//    page
// Parameters:
//    consult a Windows API reference for the meanings
//    of the parameters
// Return value:
//    tell ya the truth, I don't really know what it's
//    for
//
/////////////////////////////////////////////////////

UINT CALLBACK CommentsPageProc(HWND hwnd, UINT uiMsg, LPPROPSHEETPAGE ppsp)
{
    switch(uiMsg)
    {
    case PSPCB_CREATE:
        return TRUE;

    case PSPCB_RELEASE:
        return 0;
    }

    return 0;
}

/////////////////////////////////////////////////////
//
// CommentsDlgProc
//
/////////////////////////////////////////////////////
//
// Purpose:
//    dialog box procedure for Comments property page
// Parameters:
//    consult a Windows API reference for the meanings
//    of the parameters
// Return value:
//    TRUE if the BLG handled the event and Windows
//    doesn't need to; FALSE if Windows should handle
//    the event
// Remarks:
//    to prevent the window procedure from getting
//    too large, this function calls event handler
//    functions to handle specific messages
//
/////////////////////////////////////////////////////

BOOL CALLBACK CommentsDlgProc(HWND hDlg, UINT uiMsg, 
                              WPARAM wParam, LPARAM lParam)
{
    switch(uiMsg)
    {
    case WM_COMMAND:
        return OnCommentsDlgWMCommand(hDlg, wParam, lParam);
    case WM_INITDIALOG:
        return OnCommentsDlgWMInitDialog(hDlg, wParam, lParam);
    case WM_NOTIFY:
        return OnCommentsDlgWMNotify(hDlg, wParam, lParam);
    }

    return FALSE;
}
