/////////////////////////////////////////////////////
//
// CommentsDlgUI.cpp
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    provides event handlers for user-interface
//    events such as button presses, etc., for the
//    comments property page; also provides functions
//    that update the user interface as necessary to
//    reflect the current state of the application
//
// Portability information:
//    this file contains code written specifically for
//    a Win32 build of the BLG
//
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
//
// NOTE: 
//    none of the functions in this file should
//    be called if the comments property page is not
//    active in the context that the function is being
//    called
//
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
//
// includes
//
/////////////////////////////////////////////////////

#include "resource.h"
#include "BLGDefs.h"
#include "GeneralUI.h"
#include "CommentsDlgUI.h"

/////////////////////////////////////////////////////
//
// global variables
//
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
// defined in CommentsDlgEventHandlers.cpp
extern HWND g_hwndCommentsDlg;
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
//
// OnCommentsDlgComboHeaderComment
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles notifications from the Header Comment
//    combo box
// Parameter wParam:
//    the wParam value that contains the notification
//    code indicating what type of event has occurred
// Return value:
//    TRUE if the event is handled; FALSE if not
//
/////////////////////////////////////////////////////

BOOL OnCommentsDlgComboHeaderComment(WPARAM wParam)
{
    switch(HIWORD(wParam))
    {
    case CBN_SELCHANGE:
        return OnCommentsDlgComboHeaderCommentCBNSelChange();
    }

    return FALSE;
}

/////////////////////////////////////////////////////
//
// OnCommentsDlgComboHeaderCommentCBNSelChange
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles the CBN_SELCHANGE notification for
//    the Header Comment combo box
// Return value:
//    TRUE if event is handled; FALSE otherwise
//
/////////////////////////////////////////////////////

BOOL OnCommentsDlgComboHeaderCommentCBNSelChange()
{
    UpdateCommentSample();
    return TRUE;
}

/////////////////////////////////////////////////////
//
// OnCommentsDlgComboOneLineComment
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles notifications from the One Line Comment
//    combo box
// Parameter wParam:
//    the wParam value that contains the notification
//    code indicating what type of event has occurred
// Return value:
//    TRUE if the event is handled; FALSE if not
//
/////////////////////////////////////////////////////

BOOL OnCommentsDlgComboOneLineComment(WPARAM wParam)
{
    switch(HIWORD(wParam))
    {
    case CBN_SELCHANGE:
        return OnCommentsDlgComboOneLineCommentCBNSelChange();
    }

    return FALSE;
}

/////////////////////////////////////////////////////
//
// OnCommentsDlgComboOneLineCommentCBNSelChange
//
/////////////////////////////////////////////////////
//
// Purpose:
//    handles the CBN_SELCHANGE notification for
//    the Header Comment combo box
// Return value:
//    TRUE if event is handled; FALSE otherwise
//
/////////////////////////////////////////////////////

BOOL OnCommentsDlgComboOneLineCommentCBNSelChange()
{
    UpdateCommentSample();
    return TRUE;
}

/////////////////////////////////////////////////////
//
// UpdateCommentSample
//
/////////////////////////////////////////////////////
//
// Purpose:
//    refreshes the comment sample window; should
//    be called when other events cause a change
//    in settings that are sampled in the sample window
//
/////////////////////////////////////////////////////

void UpdateCommentSample()
{
    int nHeaderCommentStyle;
    int nOneLineCommentStyle;

    nHeaderCommentStyle = ComboBoxGetCurSel(g_hwndCommentsDlg,
                                            IDC_COMBO_HEADER_COMMENT);
    nOneLineCommentStyle = ComboBoxGetCurSel(g_hwndCommentsDlg,
                                             IDC_COMBO_ONE_LINE_COMMENT);

    PCSTR pszHeaderText = "Logic 0: main logic for the game";
    PCSTR pszOneLineText = "this is a one-line comment";
    char szSampleBuffer[MAX_COMMENT_SAMPLE_LEN];

    strcpy(szSampleBuffer, "");

    switch(nHeaderCommentStyle)
    {
    case OPT_HCS_BOUND_BY_STRING_OF_SLASHES:
        strcat(szSampleBuffer, 
               "/////////////////////////////////////////////////////");
        strcat(szSampleBuffer, STR_END_OF_LINE);
        strcat(szSampleBuffer, "//");
        strcat(szSampleBuffer, STR_END_OF_LINE);
        strcat(szSampleBuffer, "// ");
        strcat(szSampleBuffer, pszHeaderText);
        strcat(szSampleBuffer, STR_END_OF_LINE);
        strcat(szSampleBuffer, "//");
        strcat(szSampleBuffer, STR_END_OF_LINE);
        strcat(szSampleBuffer,
               "/////////////////////////////////////////////////////");
        strcat(szSampleBuffer, STR_END_OF_LINE);
        break;

    case OPT_HCS_BOUND_BY_MULTILINE:
        strcat(szSampleBuffer, "/*");
        strcat(szSampleBuffer, STR_END_OF_LINE);
        strcat(szSampleBuffer, STR_END_OF_LINE);
        strcat(szSampleBuffer, pszHeaderText);
        strcat(szSampleBuffer, STR_END_OF_LINE);
        strcat(szSampleBuffer, STR_END_OF_LINE);
        strcat(szSampleBuffer, "*/");
        strcat(szSampleBuffer, STR_END_OF_LINE);
        break;
        
    case OPT_HCS_BOUND_BY_DOUBLE_SLASH_THEN_ASTERISKS:
        strcat(szSampleBuffer,
               "// **************************************************");
        strcat(szSampleBuffer, STR_END_OF_LINE);
        strcat(szSampleBuffer, "//");
        strcat(szSampleBuffer, STR_END_OF_LINE);
        strcat(szSampleBuffer, "// ");
        strcat(szSampleBuffer, pszHeaderText);
        strcat(szSampleBuffer, STR_END_OF_LINE);
        strcat(szSampleBuffer, "//");
        strcat(szSampleBuffer, STR_END_OF_LINE);
        strcat(szSampleBuffer,
               "// **************************************************");
        strcat(szSampleBuffer, STR_END_OF_LINE);
        break;

    case OPT_HCS_START_WITH_DOUBLE_SLASH:
        strcat(szSampleBuffer, "//");
        strcat(szSampleBuffer, STR_END_OF_LINE);
        strcat(szSampleBuffer, "//");
        strcat(szSampleBuffer, STR_END_OF_LINE);
        strcat(szSampleBuffer, "// ");
        strcat(szSampleBuffer, pszHeaderText);
        strcat(szSampleBuffer, STR_END_OF_LINE);
        strcat(szSampleBuffer, "//");
        strcat(szSampleBuffer, STR_END_OF_LINE);
        strcat(szSampleBuffer, "//");
        strcat(szSampleBuffer, STR_END_OF_LINE);
        break;

    case OPT_HCS_START_WITH_LEFT_BRACKET:
        strcat(szSampleBuffer, "[");
        strcat(szSampleBuffer, STR_END_OF_LINE);
        strcat(szSampleBuffer, "[");
        strcat(szSampleBuffer, STR_END_OF_LINE);
        strcat(szSampleBuffer, "[ ");
        strcat(szSampleBuffer, pszHeaderText);
        strcat(szSampleBuffer, STR_END_OF_LINE);
        strcat(szSampleBuffer, "[");
        strcat(szSampleBuffer, STR_END_OF_LINE);
        strcat(szSampleBuffer, "[");
        strcat(szSampleBuffer, STR_END_OF_LINE);
        break;

    case OPT_HCS_ENCLOSE_WITH_MULTILINE:
        strcat(szSampleBuffer,
               "/*                                                 */");
        strcat(szSampleBuffer, STR_END_OF_LINE);
        strcat(szSampleBuffer,
               "/*                                                 */");
        strcat(szSampleBuffer, STR_END_OF_LINE);
        strcat(szSampleBuffer, "/* ");
        strcat(szSampleBuffer, pszHeaderText);
        strcat(szSampleBuffer, "                */");
        strcat(szSampleBuffer, STR_END_OF_LINE);
        strcat(szSampleBuffer,
               "/*                                                 */");
        strcat(szSampleBuffer, STR_END_OF_LINE);
        strcat(szSampleBuffer,
               "/*                                                 */");
        strcat(szSampleBuffer, STR_END_OF_LINE);
        break;

    case OPT_HCS_ONE_LINE_HEADER:
        switch(nOneLineCommentStyle)
        {
        case OPT_OLCS_DOUBLE_SLASH:
            strcat(szSampleBuffer, "// ");
            strcat(szSampleBuffer, pszHeaderText);
            strcat(szSampleBuffer, STR_END_OF_LINE);
            break;

        case OPT_OLCS_LEFT_BRACKET:
            strcat(szSampleBuffer, "[ ");
            strcat(szSampleBuffer, pszHeaderText);
            strcat(szSampleBuffer, STR_END_OF_LINE);
            break;

        case OPT_OLCS_MULTILINE:
            strcat(szSampleBuffer, "/* ");
            strcat(szSampleBuffer, pszHeaderText);
            strcat(szSampleBuffer, " */");
            strcat(szSampleBuffer, STR_END_OF_LINE);
            break;
        }
        break;
    }

    strcat(szSampleBuffer, STR_END_OF_LINE);

    switch(nOneLineCommentStyle)
    {
    case OPT_OLCS_DOUBLE_SLASH:
        strcat(szSampleBuffer, "// ");
        strcat(szSampleBuffer, pszOneLineText);
        break;

    case OPT_OLCS_LEFT_BRACKET:
        strcat(szSampleBuffer, "[ ");
        strcat(szSampleBuffer, pszOneLineText);
        break;

    case OPT_OLCS_MULTILINE:
        strcat(szSampleBuffer, "/* ");
        strcat(szSampleBuffer, pszOneLineText);
        strcat(szSampleBuffer, " */");
        break;
    }

    SetWindowText(GetDlgItem(g_hwndCommentsDlg, IDC_EDIT_COMMENT_SAMPLE),
                  szSampleBuffer);
}
