/////////////////////////////////////////////////////
//
// CommentsDlgEventHandlers.cpp
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    implementation of event handlers for the Comments
//    property page
//
// Portability information:
//    this file contains code written specifically
//    for a Win32 build of the BLG
//
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
//
// includes
//
/////////////////////////////////////////////////////

#include "resource.h"
#include "BLGDefs.h"
#include "GeneralUI.h"
#include "CommentsDlgUI.h"
#include "CommentsDlgEventHandlers.h"

/////////////////////////////////////////////////////
//
// global variables
//
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
// defined in OptionsDlg.cpp
extern COptions g_optionsTemp;
extern BOOL g_bOptionsDlgCentered;
/////////////////////////////////////////////////////

// the window handle of the Comments property page
HWND g_hwndCommentsDlg;

/////////////////////////////////////////////////////
//
// OnCommentsDlgWMCommand
//
/////////////////////////////////////////////////////
//
// Purpose:
//    WM_COMMAND handler for the Comments property
//    page
// Parameter hDlg:
//    the window handle of the dialog for which the
//    WM_COMMAND message needs to be handled
// Parameter wParam:
//    the wParam sent with the WM_COMMAND message
// Parameter lParam:
//    the lParam sent with the WM_COMMAND message
//
/////////////////////////////////////////////////////

BOOL OnCommentsDlgWMCommand(HWND hDlg, WPARAM wParam, LPARAM lParam)
{
    switch(LOWORD(wParam))
    {
    case IDC_COMBO_HEADER_COMMENT:
        return OnCommentsDlgComboHeaderComment(wParam);
    case IDC_COMBO_ONE_LINE_COMMENT:
        return OnCommentsDlgComboOneLineComment(wParam);
    }

    return FALSE;
}

/////////////////////////////////////////////////////
//
// OnCommentsDlgWMInitDialog
//
/////////////////////////////////////////////////////
//
// Purpose:
//    WM_INITDIALOG handler for the Comments property
//    page
// Parameter hDlg:
//    the window handle of the dialog for which the
//    WM_INITDIALOG message needs to be handled
// Parameter wParam:
//    the wParam sent with the WM_INITDIALOG message
// Parameter lParam:
//    the lParam sent with the WM_INITDIALOG message
//
/////////////////////////////////////////////////////

BOOL OnCommentsDlgWMInitDialog(HWND hDlg, WPARAM wParam, LPARAM lParam)
{
    HWND hwndCombo;
    HWND hwndEdit;
    LOGFONT lf;
    HFONT hfont;

    g_hwndCommentsDlg = hDlg;

    hwndEdit = GetDlgItem(hDlg, IDC_EDIT_COMMENT_SAMPLE);

    ZeroMemory(&lf, sizeof(lf));

    // create a 9-point Courier New font for the sample edit box

    // this equation sets the appropriate lfHeight field for a 9-pt font
    // in MM_TEXT mapping mode
    lf.lfHeight = -MulDiv(9, GetDeviceCaps(GetDC(hwndEdit), LOGPIXELSY),
                          72);

    lf.lfCharSet = DEFAULT_CHARSET;
    lf.lfPitchAndFamily |= FIXED_PITCH;
    strcpy(lf.lfFaceName, "Courier New");

    hfont = CreateFontIndirect(&lf);

    SendMessage(hwndEdit, WM_SETFONT, 
                reinterpret_cast<WPARAM>(hfont), 0);

    SetCheckboxChecked(hDlg, IDC_CHECK_GEN_HEADER,
                       g_optionsTemp.m_bGenerateHeader);
    SetCheckboxChecked(hDlg, IDC_CHECK_GEN_BASIC_COMMENTS,
                       g_optionsTemp.m_bGenerateBasicComments);
    SetCheckboxChecked(hDlg, IDC_CHECK_GEN_VERBOSE_COMMENTS,
                       g_optionsTemp.m_bGenerateVerboseComments);
    SetCheckboxChecked(hDlg, IDC_CHECK_GEN_TODO_COMMENTS,
                       g_optionsTemp.m_bGenerateTODOComments);
    SetCheckboxChecked(hDlg, IDC_CHECK_GEN_WARNING_COMMENTS,
                       g_optionsTemp.m_bGenerateWarningComments);

    hwndCombo = GetDlgItem(hDlg, IDC_COMBO_HEADER_COMMENT);
    ComboBoxAddString(hwndCombo, "Bounded by //////////");
    ComboBoxAddString(hwndCombo, "Bounded by /* */");
    ComboBoxAddString(hwndCombo, "Bounded by // *******");
    ComboBoxAddString(hwndCombo, "Start each line with //");
    ComboBoxAddString(hwndCombo, "Start each line with [");
    ComboBoxAddString(hwndCombo, "Enclose each line with /* */");
    ComboBoxAddString(hwndCombo, "One line");
    ComboBoxSetCurSel(hwndCombo, g_optionsTemp.m_nHeaderCommentStyle);

    hwndCombo = GetDlgItem(hDlg, IDC_COMBO_ONE_LINE_COMMENT);
    ComboBoxAddString(hwndCombo, "//");
    ComboBoxAddString(hwndCombo, "[");
    ComboBoxAddString(hwndCombo, "/* */");
    ComboBoxSetCurSel(hwndCombo, g_optionsTemp.m_nOneLineCommentStyle);

    UpdateCommentSample();
    return TRUE;
}

/////////////////////////////////////////////////////
//
// OnCommentsDlgWMNotify
//
/////////////////////////////////////////////////////
//
// Purpose:
//    WM_NOTIFY handler for the Comments property
//    page
// Parameter hDlg:
//    the window handle of the dialog for which the
//    WM_NOTIFY message needs to be handled
// Parameter wParam:
//    the wParam sent with the WM_NOTIFY message
// Parameter lParam:
//    the lParam sent with the WM_NOTIFY message
//
/////////////////////////////////////////////////////

BOOL OnCommentsDlgWMNotify(HWND hDlg, WPARAM wParam, LPARAM lParam)
{
    LPNMHDR pnmh = (LPNMHDR) lParam;

    switch(pnmh->code)
    {
    case PSN_APPLY:
        g_optionsTemp.m_bGenerateHeader =
            IsCheckboxChecked(hDlg, IDC_CHECK_GEN_HEADER);
        g_optionsTemp.m_bGenerateBasicComments =
            IsCheckboxChecked(hDlg, IDC_CHECK_GEN_BASIC_COMMENTS);
        g_optionsTemp.m_bGenerateVerboseComments =
            IsCheckboxChecked(hDlg, IDC_CHECK_GEN_VERBOSE_COMMENTS);
        g_optionsTemp.m_bGenerateTODOComments =
            IsCheckboxChecked(hDlg, IDC_CHECK_GEN_TODO_COMMENTS);
        g_optionsTemp.m_bGenerateWarningComments =
            IsCheckboxChecked(hDlg, IDC_CHECK_GEN_WARNING_COMMENTS);

        g_optionsTemp.m_nHeaderCommentStyle =
            ComboBoxGetCurSel(hDlg, IDC_COMBO_HEADER_COMMENT);
        g_optionsTemp.m_nOneLineCommentStyle =
            ComboBoxGetCurSel(hDlg, IDC_COMBO_ONE_LINE_COMMENT);
        break;
    case PSN_SETACTIVE:
        // see OptionsDlg.cpp for a description of what this does;
        // this is a bit of a kludge, but the API docs on property
        // sheets are about the worst I've ever seen; they don't
        // really tell you anything
        if (!g_bOptionsDlgCentered)
        {
            CenterDialogToParent(GetParent(hDlg));
            g_bOptionsDlgCentered = TRUE;
        }
        break;
    case PSN_KILLACTIVE:
        // in the case of a PSN_KILLACTIVE, if the changes are valid,
        // call SetWindowLong and set DWL_MSGRESULT to FALSE; if invalid,
        // set it to TRUE and notify user
        SetWindowLong(hDlg, DWL_MSGRESULT, FALSE);
        break;
    }

    return TRUE;
}
