/////////////////////////////////////////////////////
//
// AGIBLG.cpp
//
// Original author:
//    Joel McCormick
//
// Purpose of this file:
//    this file contains WinMain, the application
//    entry point; it also contains the dialog box 
//    procedure for the main window
//
// Portability information:
//    this file contains code for a Windows port of
//    the application; the code here merely serves
//    the purpose of getting a Windows version of
//    the BLG started
//
/////////////////////////////////////////////////////

/////////////////////////////////////////////////////
//
// includes
//
/////////////////////////////////////////////////////

#include <windows.h>

#include "resource.h"
#include "MainDlgEventHandlers.h"

/////////////////////////////////////////////////////
//
// global variables
//
/////////////////////////////////////////////////////

HINSTANCE g_hInstance;

/////////////////////////////////////////////////////
//
// function prototypes
//
/////////////////////////////////////////////////////

BOOL CALLBACK MainDlgProc(HWND, UINT, WPARAM, LPARAM);

/////////////////////////////////////////////////////
//
// WinMain
//
/////////////////////////////////////////////////////
//
// Purpose:
//    application entry point
// Parameters:
//    see a Windows API reference for the meanings
//    of the parameters
// Return value:
//    the code returned by DialogBox; usually IDCANCEL
//    or IDOK, but may be extended to return other things
//
/////////////////////////////////////////////////////

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
                   PSTR pszCmdLine, int nShowCmd)
{
    // save the instance handle to a global variable so that
    // DialogBox calls in other source files will have access
    // to it
    g_hInstance = hInstance;

//    MessageBox(NULL, pszCmdLine, "command line", MB_OK);

    // start the main dialog
    return DialogBox(hInstance, MAKEINTRESOURCE(IDD_DLG_MAIN),
                     NULL, MainDlgProc);
}

/////////////////////////////////////////////////////
//
// MainDlgProc
//
/////////////////////////////////////////////////////
//
// Purpose:
//    dialog box procedure for the main window
// Parameters:
//    see a Windows API reference for the meanings
//    of the parameters
// Return value:
//    TRUE if the BLG handled the event and Windows
//    doesn't need to; FALSE if Windows should handle
//    the event
// Remarks:
//    to prevent the window procedure from getting
//    too large, this function calls event handler
//    functions to handle specific messages
//
/////////////////////////////////////////////////////

BOOL CALLBACK MainDlgProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
    switch(uiMsg)
    {
    case WM_COMMAND:
        return OnMainDlgWMCommand(hDlg, wParam, lParam);

    case WM_INITDIALOG:
        return OnMainDlgWMInitDialog(hDlg, wParam, lParam);

    case WM_SYSCOMMAND:
        return OnMainDlgWMSysCommand(hDlg, wParam, lParam);
    }

    return FALSE;
}