{
    WordsEditGetGroupNum1.pas - Dialog box to get group number for WORDS.TOK editor
    Copyright (C) 1997-1999 Peter Kelly <peter@area51.org.au>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
}

unit WordsEditGetGroupNum1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, SRGrad;

type
  TWordsEditGetGroupNum = class(TForm)
    Label1: TLabel;
    NumberEdit: TEdit;
    OKBut: TButton;
    CancelBut: TButton;
    SRGradient1: TSRGradient;
    SRGradient4: TSRGradient;
    Bevel1: TBevel;
    procedure CancelButClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure OKButClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    WindowFunction : (WFAddGroup,WFChangeGroup);
    OldGroupIndex : word;
  end;

var
  WordsEditGetGroupNum: TWordsEditGetGroupNum;

implementation

{$R *.DFM}

uses WordsEditMain1;

{*************************************************************}
procedure TWordsEditGetGroupNum.CancelButClick(Sender: TObject);
{*************************************************************}
begin
  Close;
end;

{*************************************************************}
procedure TWordsEditGetGroupNum.FormShow(Sender: TObject);
{*************************************************************}
begin
  if WindowFunction = WFAddGroup then
    WordsEditGetGroupNum.Caption := 'Add group'
  else if WindowFunction = WFChangeGroup then
    WordsEditGetGroupNum.Caption := 'Change group number';
  NumberEdit.SetFocus;
  NumberEdit.SelectAll;
end;

{*************************************************************}
procedure TWordsEditGetGroupNum.OKButClick(Sender: TObject);
{*************************************************************}
var GroupNum : integer;
    code : integer;
begin
  Val(NumberEdit.Text,GroupNum,code);
  if Code <> 0 then
    ShowMessage('You must enter an integer from 0 to '+IntToStr(MaxGroupNum)+'.')
  else
  begin
    if (GroupNum < 0) or (GroupNum > MaxGroupNum) then
      ShowMessage('You must enter an integer from 0 to '+IntToStr(MaxGroupNum)+'.')
    else
    begin
      if WordsEditMain.GroupExists(GroupNum) then
        ShowMessage('Group '+IntToStr(GroupNum)+' already exists.')
      else
      begin
        Close;
        if WindowFunction = WFAddGroup then
          WordsEditMain.AddGroup(GroupNum)
        else if WindowFunction = WFChangeGroup then
          WordsEditMain.ChangeGroupNum(OldGroupIndex,GroupNum);
      end; {if not WordsEditMain.GroupExists(GroupNum)}
    end; {if not ((GroupNum < 0) or (GroupNum > MaxGroupNum))}
  end; {if Code = 0}
end;

end.
