/*-------------------------[ Various defines ]--------------------------------*/

#if defined(__TURBOC__)                     /* Turbo C */
    #if __STDC__
        #define _Cdecl
    #else
        #define _Cdecl  cdecl
    #endif
    #define _Near
#elif defined(M_I86)                        /* Microsoft C/QuickC */
    #if !defined(NO_EXT_KEYS)
        #define _Cdecl  cdecl
        #define _Near   near
    #else
        #define _Cdecl
        #define _Near
    #endif
#endif

#define UART 	0x3F
#define EOX		0xF7
#define RESET   0xFF
#define ESC  	0x1B
#define BRK		0x03

/*------------------------[ definition of NULL ]-----------------------------*/

#if !defined(NULL)
		#if defined(__TURBOC__)                     /* Turbo C */
        #if defined(__TINY__) || defined(__SMALL__) || defined(__MEDIUM__)
            #define NULL    0
        #else
            #define NULL    0L
        #endif
		#elif defined(M_I86)                      /* Microsoft C/QuickC */
        #if defined(M_I86SM) || defined(M_I86MM)
            #define NULL    0
        #else
            #define NULL    0L
        #endif
    #endif
#endif

/*--------------------------[ File redefinitions ]----------------------------*/

#if defined(M_I86)                      /* Microsoft C/QuickC */
    #define findfirst(a,b,c)  _dos_findfirst(a,c,b)
    #define findnext(a)       _dos_findnext(a)
    #define ffblk             find_t
    #define ff_name           name
    #define ff_attrib         attrib
    #define FA_DIREC          _A_SUBDIR
    static  int               tnumdrives;
#endif

/*------------------------[ Function Redefinitions ]--------------------------*/

#if defined(__TURBOC__)
    #define clrscr()    clrscr();
#elif defined(M_I86)                        /* Microsoft C/QuickC */
    #define clrscr()    _clearscreen();
#endif



/*------------------------[ Boolean logic conditions ]------------------------*/

#define NO      0
#define YES     1
#define FALSE   0
#define TRUE    1
#define OFF     0
#define ON      1
#define SUCCESS 1
#define FAIL    0
#define FAILURE 0



/*---------------------[ External Function prototypes ]-----------------------*/

int     _Cdecl  mpu_reset(void);            /* Resets the MPU                 */
void    _Cdecl  no_op(void);                /* A NULL routine                 */
void    _Cdecl  RecvSysx(void);    				        /*  Receives data from the ISR     */
void    _Cdecl  reset_ctrl_brk(void);       /* Set Ctrl-Brk vector            */
void    _Cdecl  reset_mpu_vector(void);     /* Resets back to the old vector  */
int     _Cdecl  second_8259(void);          /* Detects a second 8259          */
int     _Cdecl  send_command(int command);  /* Sends a command to the MPU     */
int     _Cdecl  send_data(int databyte);    /* Sends a data byte to the MPU   */
extern void    _Cdecl  set_ctrl_brk(void);         /* Set Ctrl-Brk vector            */
void    _Cdecl  set_handler(void (*address)(void)); /* Sets the data handler  */
                                                    /* routine                */
void    _Cdecl  set_mpu_vector(void);       /* Sets the MPU's ISR vector      */



/*----------------------------[ External Data ]-------------------------------*/

extern  int             mpu_data_port;      /* Mpu data port address          */
extern  int             mpu_command_port;   /* Mpu command port address       */
extern  int             mpu_status_port;    /* Mpu status port address        */
extern  char            mpu_irq;            /* Mpu interrupt level            */
extern  unsigned char   irq_mask;           /* 8259 mask for IRQ 2            */
extern  unsigned int    eoi;                /* End Of Interrupt mask          */
extern  int             data_in_handler;    /* Pointer to data handler        */
extern  char   huge     *pBuff;
extern  long            BuffEnd;
extern  char            SysxBegun;          /* Sysex receive flags            */
extern  char            SysxDone;

