; File Name   :	MT32.DRV
; Format      :	Binary file
; Base Address:	0000h Range: 0000h - 0C6Bh Loaded length: 0C6Bh

		.386
		.model flat

; ===========================================================================

; Segment type:	Pure code
seg000		segment	byte public 'CODE' use16
		assume cs:seg000
		assume es:nothing, ss:nothing, ds:nothing, fs:nothing, gs:nothing
		jmp	DriverEntry
; ---------------------------------------------------------------------------
		db    0
		db  21h	; !
		db  43h	; C
		db  65h	; e
		db  87h	; 
		db    1
		db    5
		db  6Dh	; m
		db  74h	; t
		db  64h	; d
		db  72h	; r
		db  76h	; v
		db  2Eh	; .
		db  52h	; R
		db  6Fh	; o
		db  6Ch	; l
		db  61h	; a
		db  6Eh	; n
		db  64h	; d
		db  20h
		db  4Dh	; M
		db  54h	; T
		db  2Dh	; -
		db  33h	; 3
		db  32h	; 2
		db  20h	; 
		db  2Bh ; +
		db  20h	;
		db  53h	; S
		db  6Fh	; o
		db  75h	; u
		db  6Eh	; n
		db  64h	; d
		db  62h	; b
		db  6Ch ; l
		db  61h	; a
		db  73h	; s
		db  74h	; t
		db  65h	; e
		db  72h	; r
		db  00h	; 
		db  00h	; 
		db  00h
		db  00h	; 
		db  00h	; 
		db  00h	; 
		db  00h	; 
		db  00h	; 
		db  00h	; 
		db  00h	; 
		db  00h
		db  00h	; 
		db  00h	; 
		db  00h
		db  00h	; 
		db  00h	; 
		db  00h	; 
		db  00h	; 
		db  00h	; 
		db 0F0h	; 
		db  41h	; A
		db  10h
		db  16h
		db  12h
		db  10h
		db    0
		db  16h
		db 0F0h	; 
		db  41h	; A
		db  10h
		db  16h
		db  12h
		db  10h
		db    0
		db  0Dh
		db 0F0h	; 
		db  41h	; A
		db  10h
		db  16h
		db  12h
		db    8
byte_54		db 0			; DATA XREF: sub_A43+Ew sub_A43+3Cw ...
byte_55		db 0			; DATA XREF: sub_A43+14w sub_A43+41w ...
		db 0F0h	; 
		db  41h	; A
		db  10h
		db  16h
		db  12h
		db    5
byte_5C		db 0			; DATA XREF: sub_9BD+70w
byte_5D		db 0			; DATA XREF: sub_9BD+62w sub_9BD+68r ...
		db 0F0h	; 
		db  41h	; A
		db  10h
		db  16h
		db  12h
		db    3
byte_64		db 1			; DATA XREF: sub_B7F+70w
byte_65		db 10h			; DATA XREF: sub_B7F+62w sub_B7F+68r ...
		db 0F0h	; 
		db  41h	; A
		db  10h
		db  16h
		db  12h
		db  10h
		db    0
		db    4
		db 0F0h	; 
		db  41h	; A
		db  10h
		db  16h
		db  12h
		db    3
		db    1
		db  43h	; C
		db    0
		db  39h	; 9
		db 0F7h	; 
		db 0F0h	; 
		db  41h	; A
		db  10h
		db  16h
		db  12h
		db  20h
		db    0
		db    0
		db 0F0h	; 
		db  41h	; A
		db  10h
		db  16h
		db  12h
		db  52h	; R
		db    0
		db  0Ah
		db  16h
		db  16h
		db  16h
		db  16h
		db  16h
		db  16h
		db  20h
		db 0F7h	; 
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
word_CD		dw 0			; DATA XREF: sub_60A+8r seg000:0985r
byte_CF		db 0			; DATA XREF: sub_1BC+BDr sub_1BC+C4r
		db 0F0h	; 
		db  41h	; A
		db  10h
		db  16h
		db  12h
		db  10h
		db    0
		db    1
byte_D8		db 0			; DATA XREF: sub_67C+Cw
byte_D9		db 0			; DATA XREF: sub_67C+16w
byte_DA		db 0			; DATA XREF: sub_67C+20w
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db  20h
		db  20h
		db  20h
		db  4Dh	; M
		db  50h	; P
		db  55h	; U
		db  20h
		db  49h	; I
		db  4Eh	; N
		db  49h	; I
		db  54h	; T
		db  20h
		db  45h	; E
		db  52h	; R
		db  52h	; R
		db  4Fh	; O
		db  52h	; R
		db  20h
		db  20h
		db  20h
byte_110	db 0			; DATA XREF: seg000:0170w
					; seg000:loc_187w ...
byte_111	db 0			; DATA XREF: sub_37A+2Cw sub_37A+33r ...
byte_112	db 0			; DATA XREF: sub_1BC+EAw
					; sub_3B7:loc_3F6r ...
byte_113	db 0			; DATA XREF: sub_3B7+E3r sub_3B7+109w
byte_114	db 0			; DATA XREF: sub_37A:loc_394r
					; sub_3B7+F1w ...
		db    0
byte_116	db 0			; DATA XREF: sub_3B7+E8r sub_3B7+114w
byte_117	db 0			; DATA XREF: sub_1BC+F0w sub_37A+Ar ...
byte_118	db 0			; DATA XREF: sub_3B7+DDw sub_3B7+FBw
byte_119	db 0			; DATA XREF: sub_1BC+10Bw sub_5D3+7w ...
byte_11A	db 0			; DATA XREF: sub_1BC:loc_274r
					; sub_66C+5r ...
word_11B	dw 0			; DATA XREF: sub_1BC+118w sub_5B6+Dw ...
word_11D	dw 0			; DATA XREF: sub_1BC+D4r sub_1BC+DBw ...
word_11F	dw 0			; DATA XREF: sub_1BC+FDw sub_712+2w ...
word_121	dw 0			; DATA XREF: sub_1BC+F6w sub_3B7+29r ...
word_123	dw 0			; DATA XREF: sub_1BC+104w sub_712+42r	...
word_125	dw 0			; DATA XREF: sub_1BC+111w sub_58B+1Dw	...
word_127	dw 0			; DATA XREF: sub_1BC:loc_29Fw
					; sub_3B7+Er ...
word_129	dw 0			; DATA XREF: seg000:014Fw sub_1BCr ...
word_12B	dw 0			; DATA XREF: sub_3B7+3Aw
					; sub_3B7:loc_57Br ...
word_12D	dw 0			; DATA XREF: sub_60A+1Ar seg000:098Ew
word_12F	dw 0			; DATA XREF: sub_312+12w sub_312+33w ...
word_131	dw 0			; DATA XREF: sub_2E0:loc_2FEr
					; sub_2E0+28w ...
		dw GetDeviceInfo
		dw InitDevice
		dw ShutdownDevice
		dw LoadSound
		dw DoSoundEvents
		dw SetVolume
		dw FadeOut
		dw StopSound
		dw PauseSound
		dw SeekSound
; ---------------------------------------------------------------------------

DriverEntry_MT32:
loc_147:				; CODE XREF: seg000:0000j
		pushf
		push	bp
		push	si
		push	di
		push	bx
		push	dx
		push	ds
		push	es
		mov	cs:word_129, si
		mov	bx, cs:[bp+133h]
		call	bx
		pop	es
		pop	ds
		pop	dx
		pop	bx
		pop	di
		pop	si
		pop	bp
		popf
		retf
; ---------------------------------------------------------------------------

ShutdownDevice:
		push	bx
		call	sub_789
		mov	bx, 0DFh ; ''
		call	sub_312
		xor	di, di
		mov	cs:byte_110, 1Dh

loc_176:				; CODE XREF: seg000:0182j
		mov	bl, cs:[di+46h]
		call	sub_367
		inc	di
		cmp	di, 8
		jl	short loc_176
		mov	bx, 1

loc_187:				; CODE XREF: seg000:0194j
		add	cs:byte_110, bl
		call	sub_367
		inc	bl
		cmp	bl, 0Ah
		jl	short loc_187
		neg	cs:byte_110
		and	cs:byte_110, 7Fh
		mov	bl, cs:byte_110
		call	sub_367
		mov	bl, 0F7h ; ''
		call	sub_367
		mov	cx, 0Fh
		call	sub_60A
		mov	bx, 0B9h ; ''
		call	sub_883
		pop	bx
		retn

; =============== S U B	R O U T	I N E =======================================

LoadSound_MT32:
sub_1BC		proc near		; CODE XREF: seg000:0837p
		mov	bx, cs:word_129
		mov	di, [bx+8]
		mov	si, [di]
		mov	es, word ptr [di+2]
		mov	word ptr [bx+10h], 1
		cmp	byte ptr es:[si], 0
		jz	short loc_1E3
		cmp	byte ptr es:[si], 2
		jz	short loc_1E3
		mov	word ptr [bx+10h], 3
		mov	ax, 3
		retn

; ---------------------------------------------------------------------------

loc_1E3:				; CODE XREF: sub_1BC+16j sub_1BC+1Cj
		push	cx
		mov	word ptr [bx+0Ch], 22h ; '"'
		mov	word ptr [bx+16h], 0
		add	si, 3
		call	sub_2E0
		jnb	short loc_261
		xor	di, di
		mov	cs:byte_110, 1Dh
		mov	bx, 0DFh ; ''
		call	sub_312

loc_204:				; CODE XREF: sub_1BC+54j
		mov	bl, cs:[di+46h]
		call	sub_367
		inc	di
		cmp	di, 8
		jl	short loc_204
		mov	di, 1

loc_215:				; CODE XREF: sub_1BC+75j
		inc	si
		mov	bl, es:[si]
		inc	si
		test	bl, 1
		jnz	short loc_223
		mov	bl, 10h
		jmp	short loc_225
; ---------------------------------------------------------------------------

loc_223:				; CODE XREF: sub_1BC+61j
		mov	bx, di

loc_225:				; CODE XREF: sub_1BC+65j
		add	cs:byte_110, bl
		call	sub_367
		inc	di
		cmp	di, 9
		jl	short loc_215
		mov	bl, es:[si]
		test	bl, 80h
		jnz	short loc_23F
		mov	bl, 10h
		jmp	short loc_241
; ---------------------------------------------------------------------------

loc_23F:				; CODE XREF: sub_1BC+7Dj
		mov	bl, 9

loc_241:				; CODE XREF: sub_1BC+81j
		add	cs:byte_110, bl
		call	sub_367
		neg	cs:byte_110
		and	cs:byte_110, 7Fh
		mov	bl, cs:byte_110
		call	sub_367
		mov	bl, 0F7h ; ''
		call	sub_367

loc_261:				; CODE XREF: sub_1BC+38j
		add	si, 0Fh
		mov	al, es:[si]
		and	al, 0F0h
		cmp	al, 0B0h ; ''
		jnz	short loc_274
		cmp	byte ptr es:[si+1], 50h	; 'P'
		jz	short loc_288

loc_274:				; CODE XREF: sub_1BC+AFj
		mov	bl, cs:byte_11A
		cmp	bl, cs:byte_CF
		jz	short loc_288
		mov	bl, cs:byte_CF
		call	sub_67C

loc_288:				; CODE XREF: sub_1BC+B6j sub_1BC+C2j
		mov	bx, cs:word_129
		mov	cx, [bx+18h]
		cmp	cx, cs:word_11D
		jz	short loc_29F
		mov	cs:word_11D, cx
		call	sub_60A

loc_29F:				; CODE XREF: sub_1BC+D9j
		mov	cs:word_127, 0
		mov	cs:byte_112, 2
		mov	cs:byte_117, 0
		mov	cs:word_121, 0
		mov	cs:word_11F, 8
		mov	cs:word_123, 0
		mov	cs:byte_119, 0
		mov	cs:word_125, 22h ; '"'
		mov	cs:word_11B, 7Fh ; ''
		mov	ax, 1
		pop	cx
		retn
sub_1BC		endp


; =============== S U B	R O U T	I N E =======================================


sub_2E0		proc near		; CODE XREF: sub_1BC+35p
		mov	ax, 1
		xor	bx, bx
		mov	cx, 8

loc_2E8:				; CODE XREF: sub_2E0+14j
		inc	si
		test	byte ptr es:[si], 1
		jz	short loc_2F1
		or	bx, ax

loc_2F1:				; CODE XREF: sub_2E0+Dj
		inc	si
		shl	ax, 1
		loop	loc_2E8
		test	byte ptr es:[si], 80h
		jz	short loc_2FE
		or	bx, ax

loc_2FE:				; CODE XREF: sub_2E0+1Aj
		cmp	bx, cs:word_131
		jz	short loc_310
		sub	si, 10h
		mov	cs:word_131, bx
		stc
		jmp	short locret_311
; ---------------------------------------------------------------------------

loc_310:				; CODE XREF: sub_2E0+23j
		clc

locret_311:				; CODE XREF: sub_2E0+2Ej
		retn
sub_2E0		endp


; =============== S U B	R O U T	I N E =======================================


sub_312		proc near		; CODE XREF: seg000:016Bp sub_1BC+45p	...
		push	cx
		push	dx
		mov	cx, 0FFFFh
		mov	dx, 331h

loc_31A:				; CODE XREF: sub_312+20j
		cmp	bp, 12h
		jz	short loc_32F
		cmp	cx, 0
		jnz	short loc_32E
		mov	cs:word_12F, 0FFFFh
		jmp	short loc_364
; ---------------------------------------------------------------------------
		db  90h	; 
; ---------------------------------------------------------------------------

loc_32E:				; CODE XREF: sub_312+10j
		dec	cx

loc_32F:				; CODE XREF: sub_312+Bj
		in	al, dx
		test	al, 40h
		jnz	short loc_31A
		cli
		mov	al, bl
		out	dx, al
		mov	cx, 0FFFFh

loc_33B:				; CODE XREF: sub_312+44j
		cmp	bp, 12h
		jz	short loc_351
		cmp	cx, 0
		jnz	short loc_350
		mov	cs:word_12F, 0FFFFh
		sti
		jmp	short loc_364
; ---------------------------------------------------------------------------
		db  90h	; 
; ---------------------------------------------------------------------------

loc_350:				; CODE XREF: sub_312+31j
		dec	cx

loc_351:				; CODE XREF: sub_312+2Cj
		in	al, dx
		rol	al, 1
		jnb	short loc_358
		jmp	short loc_33B
; ---------------------------------------------------------------------------

loc_358:				; CODE XREF: sub_312+42j
		mov	dx, 330h
		in	al, dx
		cmp	al, 0FEh ; ''
		jz	short loc_363
		mov	ax, 0FFFFh

loc_363:				; CODE XREF: sub_312+4Cj
		sti

loc_364:				; CODE XREF: sub_312+19j sub_312+3Bj
		pop	dx
		pop	cx
		retn
sub_312		endp


; =============== S U B	R O U T	I N E =======================================


sub_367		proc near		; CODE XREF: seg000:017Bp seg000:018Cp ...
		push	ax
		push	dx
		mov	dx, 331h

loc_36C:				; CODE XREF: sub_367+8j
		in	al, dx
		test	al, 40h
		jnz	short loc_36C
		mov	dx, 330h
		mov	al, bl
		out	dx, al
		pop	dx
		pop	ax
		retn
sub_367		endp


; =============== S U B	R O U T	I N E =======================================


sub_37A		proc near		; CODE XREF: sub_3B7+1AFp sub_3B7+1B8p
		push	bx
		or	al, ah
		push	ax
		mov	bl, 0D0h ; ''
		call	sub_312
		pop	ax
		cmp	cs:byte_117, al
		jz	short loc_394
		mov	bl, al
		call	sub_367
		mov	cs:byte_117, al

loc_394:				; CODE XREF: sub_37A+Fj
		mov	bl, cs:byte_114
		call	sub_367
		inc	si
		cmp	cx, 2
		jnz	short loc_3B5
		push	dx
		mov	dl, es:[si]
		mov	cs:byte_111, dl
		inc	si
		pop	dx
		mov	bl, cs:byte_111
		call	sub_367

loc_3B5:				; CODE XREF: sub_37A+26j
		pop	bx
		retn
sub_37A		endp


; =============== S U B	R O U T	I N E =======================================

DoSoundEvents_MT32:
sub_3B7		proc near		; CODE XREF: seg000:0841p
		cli
		mov	bx, cs:word_129
		mov	di, [bx+8]
		mov	es, word ptr [di+2]
		mov	si, [di]
		cmp	cs:word_127, 0
		jz	short loc_3ED
		cmp	bp, 12h
		jnz	short loc_3DB
		mov	cs:word_127, 0
		jmp	short loc_3EB
; ---------------------------------------------------------------------------

loc_3DB:				; CODE XREF: sub_3B7+19j
		dec	cs:word_127
		cmp	cs:word_121, 0
		jz	short loc_3EB
		call	sub_712

loc_3EB:				; CODE XREF: sub_3B7+22j sub_3B7+2Fj
		sti
		retn
; ---------------------------------------------------------------------------

loc_3ED:				; CODE XREF: sub_3B7+14j
		push	cx
		add	si, [bx+0Ch]
		mov	cs:word_12B, si

loc_3F6:				; CODE XREF: sub_3B7+7Aj sub_3B7+190j	...
		cmp	cs:byte_112, 1
		jnz loc_47A
		push	dx
		mov	dl, es:[si]
		mov	cs:byte_111, dl
		inc	si
		pop	dx
		cmp	cs:byte_111, 0FCh ; ''
		jnz	short loc_417
		call	sub_5EA
		jmp	loc_588
; ---------------------------------------------------------------------------

loc_417:				; CODE XREF: sub_3B7+58j
		cmp	cs:byte_111, 0F8h ; ''
		jnz	short loc_438
		mov	cs:word_127, 0F0h ; ''
		mov	cs:byte_112, 1
		cmp	bp, 12h
		jnz	short loc_435
		jmp	short loc_3F6
; ---------------------------------------------------------------------------
		db 0EBh	; 
		db    3
; ---------------------------------------------------------------------------

loc_435:				; CODE XREF: sub_3B7+78j
		jmp	loc_57B
; ---------------------------------------------------------------------------

loc_438:				; CODE XREF: sub_3B7+66j
		push	bx
		mov	cs:byte_112, 2
		mov	ax, cs:word_127
		mov	bl, cs:byte_111
		xor	bh, bh
		add	ax, bx
		mov	cs:word_127, ax
		pop	bx
		cmp	cs:word_127, 0
		jz	short loc_47A
		cmp	bp, 12h
		jnz	short loc_467
		mov	cs:word_127, 0
		jmp	short loc_477
; ---------------------------------------------------------------------------

loc_467:				; CODE XREF: sub_3B7+A5j
		dec	cs:word_127
		cmp	cs:word_121, 0
		jz	short loc_477
		call	sub_712

loc_477:				; CODE XREF: sub_3B7+AEj sub_3B7+BBj
		jmp	loc_57B
; ---------------------------------------------------------------------------

loc_47A:				; CODE XREF: sub_3B7+45j sub_3B7+A0j
		mov	cs:byte_112, 2
		push	dx
		mov	dl, es:[si]
		mov	cs:byte_111, dl
		inc	si
		pop	dx
		test	cs:byte_111, 80h
		jnz	short loc_4B1
		push	bx
		mov	cs:byte_118, 1
		mov	ah, cs:byte_113
		mov	al, cs:byte_116
		mov	bl, cs:byte_111
		mov	cs:byte_114, bl
		pop	bx
		dec	si
		jmp	short loc_4D8
; ---------------------------------------------------------------------------

loc_4B1:				; CODE XREF: sub_3B7+DAj
		push	bx
		mov	cs:byte_118, 0
		mov	ah, cs:byte_111
		and	ah, 0F0h
		mov	cs:byte_113, ah
		mov	al, cs:byte_111
		and	al, 0Fh
		mov	cs:byte_116, al
		mov	bl, es:[si]
		mov	cs:byte_114, bl
		pop	bx

loc_4D8:				; CODE XREF: sub_3B7+F8j
		cmp	ah, 0C0h ; ''
		jnz	short loc_4EC
		cmp	al, 0Fh
		jnz	short loc_4E9
		call	sub_58B
		jmp	loc_572
; ---------------------------------------------------------------------------
		db 0EBh	; 
		db    3
; ---------------------------------------------------------------------------

loc_4E9:				; CODE XREF: sub_3B7+128j
		jmp	loc_56C
; ---------------------------------------------------------------------------

loc_4EC:				; CODE XREF: sub_3B7+124j
		cmp	ah, 0B0h ; ''
		jnz	short loc_51B
		cmp	cs:byte_114, 50h ; 'P'
		jnz	short loc_4FF
		call	sub_66C
		jmp	short loc_572
; ---------------------------------------------------------------------------
		db  90h	; 
; ---------------------------------------------------------------------------

loc_4FF:				; CODE XREF: sub_3B7+140j
		cmp	cs:byte_114, 4Ch ; 'L'
		jnz	short loc_50D
		call	sub_5D3
		jmp	short loc_572
; ---------------------------------------------------------------------------
		db  90h	; 
; ---------------------------------------------------------------------------

loc_50D:				; CODE XREF: sub_3B7+14Ej
		cmp	cs:byte_114, 60h ; '`'
		jnz	short loc_51B
		call	sub_5B6
		jmp	short loc_572
; ---------------------------------------------------------------------------
		db  90h	; 
; ---------------------------------------------------------------------------

loc_51B:				; CODE XREF: sub_3B7+138j sub_3B7+15Cj
		cmp	ah, 0D0h ; ''
		jnz	short loc_523
		jmp	short loc_56C
; ---------------------------------------------------------------------------
		db  90h	; 
; ---------------------------------------------------------------------------

loc_523:				; CODE XREF: sub_3B7+167j
		cmp	ah, 0F0h ; ''
		jnz	short loc_54A
		cmp	al, 0Ch
		jnz	short loc_534
		call	sub_5EA
		jmp	short loc_588
; ---------------------------------------------------------------------------
		db  90h	; 
		db 0EBh	; 
		db  16h
; ---------------------------------------------------------------------------

loc_534:				; CODE XREF: sub_3B7+173j sub_3B7+18Ej
		push	dx
		mov	dl, es:[si]
		mov	cs:byte_111, dl
		inc	si
		pop	dx
		cmp	cs:byte_111, 0F7h ; ''
		jnz	short loc_534
		jmp	loc_3F6
; ---------------------------------------------------------------------------

loc_54A:				; CODE XREF: sub_3B7+16Fj
		cmp	bp, 12h
		jnz	short loc_563
		cmp	ah, 90h	; ''
		jnz	short loc_559
		inc	si
		inc	si
		jmp	short loc_572
; ---------------------------------------------------------------------------
		db  90h	; 
; ---------------------------------------------------------------------------

loc_559:				; CODE XREF: sub_3B7+19Bj
		cmp	ah, 80h	; ''
		jnz	short loc_563
		inc	si
		inc	si
		jmp	short loc_572
; ---------------------------------------------------------------------------
		db  90h	; 
; ---------------------------------------------------------------------------

loc_563:				; CODE XREF: sub_3B7+196j sub_3B7+1A5j
		mov	cx, 2
		call	sub_37A
		jmp	short loc_572
; ---------------------------------------------------------------------------
		db  90h	; 
; ---------------------------------------------------------------------------

loc_56C:				; CODE XREF: sub_3B7:loc_4E9j
					; sub_3B7+169j
		mov	cx, 1
		call	sub_37A

loc_572:				; CODE XREF: sub_3B7+12Dj sub_3B7+145j ...
		mov	cs:byte_112, 1
		jmp	loc_3F6
; ---------------------------------------------------------------------------

loc_57B:				; CODE XREF: sub_3B7:loc_435j
					; sub_3B7:loc_477j
		sub	si, cs:word_12B
		mov	bx, cs:word_129
		add	[bx+0Ch], si

loc_588:				; CODE XREF: sub_3B7+5Dj sub_3B7+178j
		pop	cx
		sti
		retn
sub_3B7		endp


; =============== S U B	R O U T	I N E =======================================


sub_58B		proc near		; CODE XREF: sub_3B7+12Ap
		push	ax
		push	bx
		inc	si
		xor	ah, ah
		mov	al, cs:byte_114
		mov	bx, cs:word_129
		cmp	al, 7Fh	; ''
		jnz	short loc_5B0
		push	si
		sub	si, cs:word_12B
		add	si, [bx+0Ch]
		dec	si
		dec	si
		mov	cs:word_125, si
		pop	si
		jmp	short loc_5B3
; ---------------------------------------------------------------------------

loc_5B0:				; CODE XREF: sub_58B+10j
		mov	[bx+16h], ax

loc_5B3:				; CODE XREF: sub_58B+23j
		pop	bx
		pop	ax
		retn
sub_58B		endp


; =============== S U B	R O U T	I N E =======================================


sub_5B6		proc near		; CODE XREF: sub_3B7+15Ep
		push	ax
		push	bx
		inc	si
		xor	ah, ah
		mov	al, es:[si]
		mov	bx, cs:word_129
		add	cs:word_11B, ax
		mov	ax, cs:word_11B
		mov	[bx+16h], ax
		inc	si
		pop	bx
		pop	ax
		retn
sub_5B6		endp


; =============== S U B	R O U T	I N E =======================================


sub_5D3		proc near		; CODE XREF: sub_3B7+150p
		inc	si
		cmp	byte ptr es:[si], 0
		jnz	short loc_5E2
		mov	cs:byte_119, 0
		jmp	short loc_5E8
; ---------------------------------------------------------------------------

loc_5E2:				; CODE XREF: sub_5D3+5j
		mov	cs:byte_119, 1

loc_5E8:				; CODE XREF: sub_5D3+Dj
		inc	si
		retn
sub_5D3		endp


; =============== S U B	R O U T	I N E =======================================


sub_5EA		proc near		; CODE XREF: sub_3B7+5Ap sub_3B7+175p	...
		mov	bx, cs:word_129
		mov	word ptr [bx+16h], 0FFFFh
		mov	dx, cs:word_125
		mov	[bx+0Ch], dx
		mov	cs:word_127, 0
		mov	cs:byte_112, 2
		retn
sub_5EA		endp


; =============== S U B	R O U T	I N E =======================================


sub_60A		proc near		; CODE XREF: seg000:01B1p sub_1BC+E0p	...
		push	di
		push	bx
		push	cx
		cmp	cx, 0Fh
		jl	short loc_619
		mov	cx, cs:word_CD
		jmp	short loc_62D
; ---------------------------------------------------------------------------

loc_619:				; CODE XREF: sub_60A+6j
		cmp	cx, 0
		jle	short loc_62D
		push	ax
		push	dx
		xor	dx, dx
		mov	ax, cx
		mul	cs:word_12D
		mov	cx, ax
		pop	dx
		pop	ax

loc_62D:				; CODE XREF: sub_60A+Dj sub_60A+12j
		mov	bx, 0DFh ; ''
		call	sub_312
		xor	di, di
		mov	cs:byte_110, 26h ; '&'

loc_63B:				; CODE XREF: sub_60A+3Dj
		mov	bl, cs:[di+3Eh]
		call	sub_367
		inc	di
		cmp	di, 8
		jl	short loc_63B
		mov	bx, cx
		add	cs:byte_110, bl
		call	sub_367
		neg	cs:byte_110
		mov	bl, cs:byte_110
		and	bl, 7Fh
		call	sub_367
		mov	bl, 0F7h ; ''
		call	sub_367
		pop	cx
		pop	bx
		pop	di
		retn
sub_60A		endp


; =============== S U B	R O U T	I N E =======================================


sub_66C		proc near		; CODE XREF: sub_3B7+142p
		inc	si
		mov	bl, es:[si]
		inc	si
		cmp	bl, cs:byte_11A
		jz	short locret_67B
		call	sub_67C

locret_67B:				; CODE XREF: sub_66C+Aj
		retn
sub_66C		endp


; =============== S U B	R O U T	I N E =======================================


sub_67C		proc near		; CODE XREF: sub_1BC+C9p sub_66C+Cp
		xor	bh, bh
		mov	cs:byte_11A, bl
		mov	cl, cs:[bx+0DBh]
		mov	cs:byte_D8, cl
		mov	cl, cs:[bx+0E6h]
		mov	cs:byte_D9, cl
		mov	cl, cs:[bx+0F1h]
		mov	cs:byte_DA, cl
		mov	bx, 0DFh ; ''
		call	sub_312
		xor	di, di

loc_6A9:				; CODE XREF: sub_67C+39j
		mov	bl, cs:[di+0D0h]
		call	sub_367
		inc	di
		cmp	di, 5
		jl	short loc_6A9
		mov	cs:byte_110, 0

loc_6BD:				; CODE XREF: sub_67C+52j
		mov	bl, cs:[di+0D0h]
		add	cs:byte_110, bl
		call	sub_367
		inc	di
		cmp	di, 0Bh
		jl	short loc_6BD
		neg	cs:byte_110
		and	cs:byte_110, 7Fh
		mov	bl, cs:byte_110
		call	sub_367
		mov	bl, 0F7h ; ''
		call	sub_367
		mov	cs:byte_117, 0
		retn
sub_67C		endp

; ---------------------------------------------------------------------------
		
SetVolume_MT32:
		cmp	cs:word_121, 0
		jnz	short locret_711

		push	bx
		push	cx

		mov	bx, cs:word_129
		mov	cx, [bx+18h]
		mov	cs:word_11D, cx


		call	sub_60A
		mov	cs:byte_117, 0
		pop	cx
		pop	bx

locret_711:				; CODE XREF: seg000:06F5j
		retn

; =============== S U B	R O U T	I N E =======================================


sub_712		proc near		; CODE XREF: sub_3B7+31p sub_3B7+BDp
		push	bx
		push	cx
		dec	cs:word_11F
		cmp	cs:word_11F, 0
		jnz	short loc_764
		dec	cs:word_121
		cmp	cs:word_121, 0
		jnz	short loc_740
		mov	bx, cs:word_129
		mov	word ptr [bx+0Ah], 0
		call	sub_789
		call	sub_5EA
		jmp	short loc_764
; ---------------------------------------------------------------------------

loc_740:				; CODE XREF: sub_712+1Aj
		mov	cx, cs:word_121
		mov	cs:word_11D, cx
		call	sub_60A
		mov	cs:word_11F, 8
		mov	cx, cs:word_123
		add	cs:word_11F, cx
		add	cs:word_123, 2

loc_764:				; CODE XREF: sub_712+Dj sub_712+2Cj
		pop	cx
		pop	bx
		retn
sub_712		endp

; ---------------------------------------------------------------------------

FadeOut_MT32:
		push	bx
		push	cx
		mov	bx, cs:word_129
		mov	cx, [bx+18h]
		mov	cs:word_121, cx
		cmp	cx, 0
		jnz	short loc_786
		mov	word ptr [bx+0Ah], 0
		call	sub_789
		call	sub_5EA

loc_786:				; CODE XREF: seg000:0779j
		pop	cx
		pop	bx
		retn

; =============== S U B	R O U T	I N E =======================================


PauseSound_MT32:
StopSound_MT32:
sub_789		proc near		; CODE XREF: seg000:0165p sub_712+26p	...
		push	cx
		mov	cs:byte_117, 0
		mov	di, 1
		xor	bh, bh

loc_795:				; CODE XREF: sub_789+70j
		mov	bl, 0D0h ; ''
		call	sub_312
		cmp	cs:word_12F, 0FFFFh
		jnz	short loc_7A4
		pop	cx
		retn
; ---------------------------------------------------------------------------

loc_7A4:				; CODE XREF: sub_789+17j
		mov	bl, 0B0h ; ''
		add	bx, di
		call	sub_367
		mov	bl, 7Bh	; '{'
		call	sub_367
		xor	bl, bl
		call	sub_367
		mov	bl, 0D0h ; ''
		call	sub_312
		mov	bl, 0B0h ; ''
		add	bx, di
		call	sub_367
		mov	bl, 40h	; '@'
		call	sub_367
		xor	bl, bl
		call	sub_367
		mov	bl, 0D0h ; ''
		call	sub_312
		mov	bl, 1
		call	sub_367
		xor	bl, bl
		call	sub_367
		cmp	bp, 10h
		jz	short loc_7F5
		mov	bl, 0D0h ; ''
		call	sub_312
		mov	bl, 0E0h ; ''
		add	bx, di
		call	sub_367
		xor	bl, bl
		call	sub_367
		mov	bl, 40h	; '@'
		call	sub_367

loc_7F5:				; CODE XREF: sub_789+54j
		inc	di
		cmp	di, 0Ah
		jl	short loc_795
		cmp	bp, 0Eh
		jnz	short loc_803
		call	sub_5EA

loc_803:				; CODE XREF: sub_789+75j
		cmp	bp, 10h
		jnz	short loc_82A
		cmp	cs:byte_119, 0
		jz	short loc_82A
		mov	bx, cs:word_129
		mov	cx, cs:word_125
		mov	[bx+0Ch], cx
		mov	cs:word_127, 0
		mov	cs:byte_112, 2

loc_82A:				; CODE XREF: sub_789+7Dj sub_789+85j
		pop	cx
		retn
sub_789		endp

; ---------------------------------------------------------------------------

SeekSound:
		cli
		push	cx
		mov	bx, cs:word_129
		mov	cx, [bx+0Ch]
		push	si
		call	sub_1BC
		pop	si
		cmp	ax, 1
		jnz	short loc_87A

loc_840:				; CODE XREF: seg000:0878j
		push	si
		call	sub_3B7
		pop	si
		mov	bx, cs:word_129
		cmp	cs:byte_119, 0
		jz	short loc_86C
		cmp	cs:word_125, 22h ; '"'
		jz	short loc_86C
		mov	cs:word_127, 0
		mov	cs:byte_112, 2
		mov	cx, cs:word_125

loc_86C:				; CODE XREF: seg000:0850j seg000:0858j
		cmp	word ptr [bx+16h], 0FFFFh
		jnz	short loc_875
		mov	cx, [bx+0Ch]

loc_875:				; CODE XREF: seg000:0870j
		cmp	[bx+0Ch], cx
		jb	short loc_840

loc_87A:				; CODE XREF: seg000:083Ej
		mov	cs:byte_117, 0
		pop	cx
		sti
		retn

; =============== S U B	R O U T	I N E =======================================


sub_883		proc near		; CODE XREF: seg000:01B7p seg000:0907p ...
		push	di
		push	cx
		push	bx
		mov	bx, 0DFh ; ''
		call	sub_312
		mov	cs:byte_110, 20h ; ' '
		xor	di, di

loc_894:				; CODE XREF: sub_883+1Dj
		mov	bl, cs:[di+79h]
		call	sub_367
		inc	di
		cmp	di, 8
		jl	short loc_894
		pop	bx
		xor	di, di

loc_8A5:				; CODE XREF: sub_883+35j
		mov	cl, cs:[bx+di]
		push	bx
		mov	bl, cl
		add	cs:byte_110, bl
		call	sub_367
		pop	bx
		inc	di
		cmp	di, 14h
		jl	short loc_8A5
		neg	cs:byte_110
		and	cs:byte_110, 7Fh
		mov	bl, cs:byte_110
		call	sub_367
		mov	bl, 0F7h ; ''
		call	sub_367
		pop	cx
		pop	di
		retn
sub_883		endp

;======================================================================
;======================================================================
;======================================================================
;======================================================================
;======================================================================
;======================================================================
;======================================================================
;======================================================================
;======================================================================
;======================================================================
;======================================================================
;======================================================================
;======================================================================
;======================================================================

; "GM on MPU-401 driver for SCI0"
;
;
; byte_20A6 = pcm play state (0 = stop, 1 = ready, 2 = playing, 4 = paused)
; byte_20A7 = sb dma pass
; word_20B0 = ptrparam - saves the original si parameter to DriverInterface
;
;
; sound info structure
; +08h = SND_RESPTR (far ptr to data)
; +0Ah = SND_UNK
; +0Ch = SND_POS (play offset)
; +10h = SND_STATE (1 = okay)
; +16h = SND_SIGNAL (0 = ready?, FFFF = stop)
; +18h = SND_VOLUME


; Soundblaster vars
; word_2025 = i/o port
; byte_2027 = dma irq
; word_2028 = dma busy (0 = idle, 1 = active)



word_2025 dw 220h
byte_2027	db 00h
word_2028 dw 00h

byte_202C db 00h
word_202D dw 00h
word_202F dw 00h
word_2031 dw 00h




byte_20A6 db 00h
byte_20A7 db 00h


word_20B0 dw 00h
word_20B4 dw 00h
	dw 00h




; interrupt vectors - 2/3/5/7
word_irqh	dw 0
	dw 0
word_irq2	dw 0
	dw 0
word_irq5	dw 0
	dw 0
word_irq3	dw 0
	dw 0
word_irq7 dw 0
	dw 0


byte_sbvol db 0



byte_2459	db 0			; DATA XREF: sub_26CA+36r sub_26CA+4Cw ...
word_245A	dw 0			; DATA XREF: sub_26CA:loc_26DFr
					; sub_26CA+3Br	...
word_245C	dw 0			; DATA XREF: sub_26CA+1Aw sub_26CA+3Fr ...
byte_245E	db 0			; DATA XREF: sub_26CA+3r sub_26CA+Bw ...
word_245F	dw 0			; DATA XREF: sub_26CA+22w sub_27A6+65w
word_2461	dw 0			; DATA XREF: sub_26CA+27w
					; sub_26CA:loc_26F9w ...
word_2463	dw 0			; DATA XREF: sub_26CA+10r sub_27A6+7Fw

; ---------------------------------------------------------------------------

; NOTE:
; - preserve original driver code + code order
; - 'external' jmps to bypass missing hard-coded ptrs


DriverEntry:
		; sblaster - data ptr
		mov cs:word_20B0, si

		jmp DriverEntry_MT32

; ---------------------------------------------------------------------------


LoadSound:
		mov	bx, cs:word_20B0
		mov	di, [bx+8]
		mov	si, [di]
		mov	es, word ptr [di+2]
		mov	word ptr [bx+10h], 1


		; sblaster - no pcm data
		mov	cs:byte_20A6, 0


		cmp	byte ptr es:[si], 2
		jne	LoadSound_MT32

		jmp	LoadSound_SB


; =============== S U B	R O U T	I N E =======================================


LoadSound_SB:
sub_1920	proc near		; CODE XREF: sub_177D:loc_17B2.p
					; sub_19B3+31.p
		mov	ax, es:[si+1Fh]
		xchg	ah, al
		or	ax, ax
		jnz	short loc_193E

		; 0000 = find PCM header

		; skip MIDI header
		add	si, 21h	; '!'

loc_192D:				; CODE XREF: sub_1920+12.j
		; look for $FC MIDI stop byte
		inc	si
		cmp	byte ptr es:[si], 0FCh ; ''
		jnz	short loc_192D

		; look for $FC PCM pad
		cmp	byte ptr es:[si+1], 0FCh ; ''
		jnz	short loc_193C
		inc	si

loc_193C:				; CODE XREF: sub_1920+19.j
		jmp	short loc_1940
; ---------------------------------------------------------------------------

loc_193E:				; CODE XREF: sub_1920+8.j
		; use PCM offset value
		add	si, ax

loc_1940:				; CODE XREF: sub_1920:loc_193C.j
		; check frequency
		mov	cx, es:[si+0Fh]
		cmp	cx, 0F34h
		jge	short loc_1953

		mov	cs:byte_202C, 0
		jmp	short loc_1964
; ---------------------------------------------------------------------------
		db  90h	; 
; ---------------------------------------------------------------------------

loc_1953:				; CODE XREF: sub_1920+28.j
		; 1000000d = timer compute
		mov	dx, 0Fh
		mov	ax, 4240h
		div	cx
		mov	ah, 0
		sub	ah, al
		mov	cs:byte_202C, ah

loc_1964:				; CODE XREF: sub_1920+30.j
		mov	ax, es:[si+21h]
		mov	cs:word_2031, ax
		add	si, 2Dh	; '-'
		mov	cs:word_202D, es
		mov	cs:word_202F, si
		mov	cs:word_20B4, si
		mov	bx, cs:word_20B0
		mov	[bx+0Ch], si
		mov	word ptr [bx+16h], 0

		mov	ax, [bx+18h]
		or	al, al
		jz	short loc_1994
		mov	al, 1

loc_1994:				; CODE XREF: sub_1920+70.j
		cmp	cs:byte_20A7, al
		jz	short loc_19A2
		mov	cs:byte_20A7, al
		call	sub_2788

loc_19A2:				; CODE XREF: sub_1920+79.j
		mov	cs:byte_20A6, 1
		mov	cs:word_2028, 0
		mov	ax, 1
		retn
sub_1920	endp

; =============== S U B	R O U T	I N E =======================================


DoSoundEvents:
		mov	bx, cs:word_20B0
		mov	di, [bx+8]
		mov	es, word ptr [di+2]
		mov	si, [di]



		; 0 = pcm n/a
		cmp	cs:byte_20A6, 0
		je DoSoundEvents_MT32



		; 1 = pcm ready
		cmp	cs:byte_20A6, 1
		jnz	short loc_19D3

		; start sb dma
		call	sub_27A6


loc_19D3:				; CODE XREF: sub_19B3+1B.j
		cmp	cs:word_2028, 0
		jne	short loc_19F8

		; dma not active - check replay
		cmp	word ptr [bx+0Ah], 1
		jle	short loc_19EC


		; replay sound = reload + send dma
		dec	word ptr [bx+0Ah]
		call	sub_1920
		call	sub_27A6
		retn
; ---------------------------------------------------------------------------

loc_19EC:				; CODE XREF: sub_19B3+2C.j
		; terminate pcm
		mov	word ptr [bx+16h], 0FFFFh
		mov	cs:byte_20A6, 0
		retn
; ---------------------------------------------------------------------------

loc_19F8:				; CODE XREF: sub_19B3+26.j
		; restart pcm if paused
		cmp	cs:byte_20A6, 4
		jnz	short locret_1A03

		call	sub_2892

locret_1A03:				; CODE XREF: sub_19B3+4B.j
		retn

; ---------------------------------------------------------------------------


SetVolume:
		push ax
		push bx

		mov	bx, cs:word_20B0
		mov	al, [bx+18h]
		mov cs:byte_sbvol, al
		call SetVolume_SB

		pop bx
		pop ax


		jmp SetVolume_MT32

; ---------------------------------------------------------------------------

SetVolume_SB:
		push ax
		push bx
		push dx


		; volume (0-F, 0-F)
		; - sbpro = 3-bits used (xxx-)
		; - sb16 = 4-bits (xxxx)
		mov bl, cs:byte_sbvol
		and bl, 0Eh


		; sbpro dac volume register
		mov	dx, cs:word_2025
		add	dx, 04h
		mov al, 04h
		out dx, al

		mov	dx, cs:word_2025
		add	dx, 05h
		mov al, bl
		shl al, 4
		or al, bl
		out dx, al

; ---------------------------------------------------------------------------

		; check if pcm playing
		cmp	cs:byte_20A6, 2
		jne SetVolume_end


		; check active pcm
		mov	bx, cs:word_20B0
		cmp	word ptr [bx+18h], 0
		jnz	short loc_2A3F

		xor	al, al
		jmp	short loc_2A41

; ---------------------------------------------------------------------------

loc_2A3F:				; CODE XREF: seg000:2A39.j
		mov	al, 1

loc_2A41:				; CODE XREF: seg000:2A3D.j
		call	sub_2788


SetVolume_end:
		pop dx
		pop bx
		pop ax

		retn


; =============== S U B	R O U T	I N E =======================================


FadeOut:
		cmp	cs:word_2028, 0
		je FadeOut_MT32


		push bx
		push cx

		; stop dma
		call	sub_2843

		; stop pcm
		mov	cs:byte_20A6, 0
		mov	bx, cs:word_20B0
		mov	word ptr [bx+16h], 0FFFFh
		mov	word ptr [bx+0Ah], 0

		pop cx
		pop bx
		retn

; =============== S U B	R O U T	I N E =======================================


StopSound:
		cmp	cs:word_2028, 0
		je StopSound_MT32


		push bx
		push cx

		; stop sb dma
		call	sub_2843

		mov	cs:byte_20A6, 0
		mov	bx, cs:word_20B0
		mov	word ptr [bx+16h], 0FFFFh

		pop cx
		pop bx
		retn

; =============== S U B	R O U T	I N E =======================================


PauseSound:
		cmp	cs:word_2028, 1
		jne	PauseSound_MT32



		push bx
		push cx

		; active pcm play - check pause / stop
		cmp	bp, 10h
		jnz	short loc_2B0A

		; pause dma
		call	sub_286D
		mov	cs:byte_20A6, 4
		jmp PauseSound_End

; ---------------------------------------------------------------------------

loc_2B0A:				; CODE XREF: sub_2AF2+B.j
		; stop sb dma
		call	sub_2843

		; stop pcm play
		mov	cs:byte_20A6, 0
		mov	bx, cs:word_20B0
		mov	word ptr [bx+16h], 0FFFFh


PauseSound_End:
		pop cx
		pop bx
		retn

; ---------------------------------------------------------------------------

sb_irqHandler:
		push	ds
		push	es
		push	ax
		push	bx
		push	cx
		push	dx
		push	di
		push	si
		push	bp
		cli
		cld
		mov	ax, cs
		mov	ds, ax
		mov	es, ax
		mov	al, 20h	; ' '
		out	20h, al		; Interrupt controller,	8259A.


		mov	ax, cs:word_245F
		or	ax, ax
		jnz	short loc_26B3
		call	sub_273F
		jmp	short loc_26B6
; ---------------------------------------------------------------------------

loc_26B3:				; CODE XREF: seg000:26AC.j
		call	sub_26CA

loc_26B6:				; CODE XREF: seg000:26B1.j
		mov	dx, cs:word_2025
		add	dl, 0Eh
		in	al, dx
		sti
		pop	bp
		pop	si
		pop	di
		pop	dx
		pop	cx
		pop	bx
		pop	ax
		pop	es
		pop	ds
		iret

; =============== S U B	R O U T	I N E =======================================


sub_2496	proc near		; CODE XREF: sub_250D+2F.p sub_250D+34.p ...
		mov	ah, al

loc_2498:				; CODE XREF: sub_2496+5.j
		in	al, dx
		or	al, al
		js	short loc_2498
		mov	al, ah
		out	dx, al
		retn
sub_2496	endp


; =============== S U B	R O U T	I N E =======================================


sub_259E	proc near		; CODE XREF: sub_2843+16.p sub_286D+15.p
		mov	dx, cs:word_2025
		add	dl, 0Ch
		mov	al, 0D0h ; ''
		call	sub_2496

loc_25AB:				; CODE XREF: sub_259E+10.j
		in	al, dx
		or	al, al
		js	short loc_25AB
		retn
sub_259E	endp


; =============== S U B	R O U T	I N E =======================================


sub_25B1	proc near		; CODE XREF: sub_250D+22.p sub_26CA+44.p
		push	bx
		mov	bx, ax
		mov	al, 5
		out	0Ah, al		; DMA controller, 8237A-5.
					; single mask bit register
					; 0-1: select channel (00=0; 01=1; 10=2; 11=3)
					; 2: 1=set mask	for channel; 0=clear mask (enable)
		xor	al, al
		out	0Ch, al		; DMA controller, 8237A-5.
					; clear	byte pointer flip-flop.
		mov	al, dh
		out	0Bh, al		; DMA 8237A-5. mode register bits:
					; 0-1: channel (00=0; 01=1; 10=2; 11=3)
					; 2-3: transfer	type (00=verify=Nop; 01=write; 10=read)
					; 4: 1=enable auto-initialization
					; 5: 1=address increment; 0=address decrement
					; 6-7: 00=demand mode; 01=single; 10=block; 11=cascade
		mov	al, bl
		out	2, al		; DMA controller, 8237A-5.
					; channel 1 base address
					; (also	sets current address)
		mov	al, bh
		out	2, al		; DMA controller, 8237A-5.
					; channel 1 base address
					; (also	sets current address)
		mov	al, cl
		out	3, al		; DMA controller, 8237A-5.
					; channel 1 base address and word count
		mov	al, ch
		out	3, al		; DMA controller, 8237A-5.
					; channel 1 base address and word count
		mov	al, dl
		out	83h, al		; DMA page register 74LS612:
					; Channel 1 (address bits 16-23)
		mov	al, 1
		out	0Ah, al		; DMA controller, 8237A-5.
					; single mask bit register
					; 0-1: select channel (00=0; 01=1; 10=2; 11=3)
					; 2: 1=set mask	for channel; 0=clear mask (enable)
		pop	bx
		retn
sub_25B1	endp


; =============== S U B	R O U T	I N E =======================================


sub_25DA	proc near		; CODE XREF: sub_250D+1B.p sub_27A6+54.p
		push	cx
		mov	cl, 4
		rol	dx, cl
		mov	cx, dx
		and	dx, 0Fh
		and	cx, 0FFF0h
		add	ax, cx
		adc	dx, 0
		pop	cx
		retn
sub_25DA	endp


; =============== S U B	R O U T	I N E =======================================


sub_25EE	proc near		; CODE XREF: sub_250D+8.p sub_250D+13.p	...
		push	bx
		push	cx
		push	dx
		cli
		mov	cl, al
		add	al, 8
		cbw
		shl	al, 1
		shl	al, 1
		mov	di, ax
		push	es
		xor	ax, ax
		mov	es, ax
		mov	ax, es:[di]
		mov	cs:[bx], ax
		mov	es:[di], dx
		mov	ax, es:[di+2]
		mov	cs:[bx+2], ax
		mov	word ptr es:[di+2], cs
		pop	es
		mov	ah, 1
		shl	ah, cl
		not	ah
		in	al, 21h		; Interrupt controller,	8259A.
		and	al, ah
		out	21h, al		; Interrupt controller,	8259A.
		sti
		pop	dx
		pop	cx
		pop	bx
		retn
sub_25EE	endp

; =============== S U B	R O U T	I N E =======================================


sub_2629	proc near		; CODE XREF: sub_250D+5E.p sub_250D+66.p ...
		cli
		mov	cl, al
		add	al, 8
		cbw
		shl	al, 1
		shl	al, 1
		mov	di, ax
		push	es
		xor	ax, ax
		mov	es, ax
		mov	ax, cs:[bx]
		mov	es:[di], ax
		mov	ax, cs:[bx+2]
		mov	es:[di+2], ax
		pop	es
		mov	ah, 1
		shl	ah, cl
		in	al, 21h		; Interrupt controller,	8259A.
		or	al, ah
		out	21h, al		; Interrupt controller,	8259A.
		sti
		retn
sub_2629	endp


; =============== S U B	R O U T	I N E =======================================


sub_26CA	proc near		; CODE XREF: sub_27A6+8Dp
		mov	cx, 0FFFFh
		cmp	cs:byte_245E, 0
		jnz	short loc_26DF
		inc	cs:byte_245E
		mov	cx, cs:word_2463

loc_26DF:				; CODE XREF: sub_26CA+9j
		sub	cx, cs:word_245A
		mov	cs:word_245C, cx
		inc	cx
		jz	short loc_26F9
		sub	cs:word_245F, cx
		sbb	cs:word_2461, 0
		jmp	short loc_26FE
; ---------------------------------------------------------------------------

loc_26F9:				; CODE XREF: sub_26CA+20j
		dec	cs:word_2461

loc_26FE:				; CODE XREF: sub_26CA+2Dj
		mov	dh, 49h	; 'I'
		mov	dl, cs:byte_2459
		mov	ax, cs:word_245A
		mov	cx, cs:word_245C
		call	sub_25B1
		dec	cs:byte_245E
		inc	cs:byte_2459
		mov	cs:word_245A, 0
		mov	cx, cs:word_245C
		mov	dx, cs:word_2025
		add	dl, 0Ch
		mov	al, 14h
		call	sub_2496
		mov	al, cl
		call	sub_2496
		mov	al, ch
		call	sub_2496
		retn
sub_26CA	endp


; =============== S U B	R O U T	I N E =======================================


sub_273F	proc near		; CODE XREF: sub_2843+19p
		mov	al, 5
		out	0Ah, al		; DMA controller, 8237A-5.
					; single mask bit register
					; 0-1: select channel (00=0; 01=1; 10=2; 11=3)
					; 2: 1=set mask	for channel; 0=clear mask (enable)

		; restore old irq
		mov	al, cs:byte_2027
		mov	bx, offset word_irqh
		call	sub_2629

		; dma active = no
		mov	cs:word_2028, 0

		mov	dx, cs:word_2025
		add	dl, 0Eh
		in	al, dx
		retn
sub_273F	endp


; =============== S U B	R O U T	I N E =======================================


sub_2788	proc near		; CODE XREF: sub_1920+7Fp
					; seg000:loc_2A41p
		push	ds
		call	sub_278E
		pop	ds
		retn
sub_2788	endp


; =============== S U B	R O U T	I N E =======================================


sub_278E	proc near		; CODE XREF: sub_275E+20.p sub_2788+1.p
		mov	dx, cs:word_2025
		add	dx, 0Ch
		mov	ah, 0D1h ; ''
		or	al, al
		jnz	short loc_279E
		mov	ah, 0D3h ; ''

loc_279E:				; CODE XREF: sub_278E+C.j
		mov	al, ah
		call	sub_2496
		xor	ax, ax
		retn
sub_278E	endp



; =============== S U B	R O U T	I N E =======================================


sub_2843	proc near		; CODE XREF: seg000:2A99.p sub_2AD5+8.p	...
		push	bx
		push	ds
		push	es
		push	di
		push	si
		mov	ax, cs
		mov	ds, ax
		mov	es, ax
		mov	ax, 1
		cmp	cs:word_2028, 0
		jz	short loc_2867

		; sb dma active = stop
		call	sub_259E
		call	sub_273F
		mov	cs:byte_20A6, 0
		xor	ax, ax

loc_2867:				; CODE XREF: sub_2843+14.j
		pop	si
		pop	di
		pop	es
		pop	ds
		pop	bx
		retn
sub_2843	endp


; =============== S U B	R O U T	I N E =======================================


sub_286D	proc near		; CODE XREF: sub_2AF2+D.p
		push	ds
		push	es
		push	di
		push	si
		mov	ax, cs
		mov	ds, ax
		mov	es, ax
		mov	ax, 1
		cmp	cs:word_2028, 1
		jnz	short loc_288D

		; sb dma active = set pause state
		call	sub_259E
		mov	cs:byte_20A6, 4
		xor	ax, ax

loc_288D:				; CODE XREF: sub_286D+13.j
		pop	si
		pop	di
		pop	es
		pop	ds
		retn
sub_286D	endp

; =============== S U B	R O U T	I N E =======================================


sub_27A6	proc near		; CODE XREF: sub_19B3+1D.p sub_19B3+34.p
		push	ds
		push	es
		push	di
		push	si
		mov	ax, cs
		mov	ds, ax
		mov	es, ax


		cmp	cs:word_2028, 0
		jz	short loc_27BE

		; sb dma active = skip
		mov	ax, 1
		jmp	loc_283E
; ---------------------------------------------------------------------------

loc_27BE:				; CODE XREF: sub_27A6+10.j
		; start sb dma
		mov	cs:word_2028, 1

		mov	dx, cs:word_2025
		add	dl, 0Ch
		mov	cl, cs:byte_202C
		mov	dx, cs:word_2025
		add	dl, 0Ch
		mov	al, 40h	; '@'
		call	sub_2496
		mov	al, cl
		call	sub_2496
		mov	al, cs:byte_2027
		mov	dx, offset sb_irqHandler
		mov	bx, offset word_irqh
		call	sub_25EE
		mov	dx, cs:word_202D
		mov	ax, cs:word_202F
		call	sub_25DA
		mov	cs:byte_2459, dl
		mov	cs:word_245A, ax
		mov	cx, cs:word_2031
		mov	cs:word_245F, cx
		mov	cs:word_2461, 0
		add	ax, cs:word_2031
		adc	dl, 0
		sub	ax, 1
		sbb	dl, 0
		mov	cs:word_2463, ax
		sub	dl, cs:byte_2459
		mov	cs:byte_245E, dl
		call	sub_26CA
		mov	cs:byte_20A6, 2
		xor	ax, ax



loc_283E:				; CODE XREF: sub_27A6+15.j
		pop	si
		pop	di
		pop	es
		pop	ds
		retn
sub_27A6	endp

; =============== S U B	R O U T	I N E =======================================

sub_2892	proc near		; CODE XREF: sub_19B3+4D.p
		push	ds
		push	es
		push	di
		push	si
		mov	ax, cs
		mov	ds, ax
		mov	es, ax
		mov	ax, 1


		cmp	cs:word_2028, 1
		jnz	short loc_28BC


		; restart pcm
		mov	dx, cs:word_2025
		add	dl, 0Ch
		mov	al, 0D4h ; ''
		call	sub_2496
		mov	cs:byte_20A6, 2
		xor	ax, ax

loc_28BC:				; CODE XREF: sub_2892+13.j
		pop	si
		pop	di
		pop	es
		pop	ds
		retn
sub_2892	endp

;======================================================================
;======================================================================
;======================================================================
;======================================================================
;======================================================================
;======================================================================
;======================================================================
;======================================================================
;======================================================================
;======================================================================
;======================================================================
;======================================================================
;======================================================================
;======================================================================


driver_end:

; free space
; - MT-32 = loc_8D5+


; ---------------------------------------------------------------------------

GetDeviceInfo:
		mov	ax, 1
		mov	cx, 20h	; ' '
		retn

; ---------------------------------------------------------------------------

InitDevice:
		call InitDevice_MT32

		call InitDevice_SB
		cmp ax,0
		jnz loc_InitDevice_fail


		; success = reclaim memory
		mov	cs:byte_20A7, 1
		mov ax,driver_end
		mov	bx, 2
		xor cx, cx

		jmp loc_InitDevice_done


loc_InitDevice_fail:
		mov ax,0FFFFh


loc_InitDevice_done:
		retn

; =============== S U B	R O U T	I N E =======================================

InitDevice_MT32:
loc_8D5:
		mov	bx, cs:word_129
		mov	di, [bx+8]
		mov	es, word ptr [di+2]
		mov	si, [di]
		mov	cx, 6Bh	; 'k'
		xor	di, di

loc_8E7:				; CODE XREF: seg000:08F1.j
		mov	bl, es:[si]
		mov	cs:[di+91h], bl
		inc	si
		inc	di
		loop	loc_8E7
		mov	bx, 0FFh
		call	sub_312
		call	sub_789
		cmp	cs:word_12F, 0FFFFh
		jnz	short loc_910
		mov	bx, 0FCh ; ''
		call	sub_883
		xor	cx, cx
		mov	ax, 0FFFFh
		retn
; ---------------------------------------------------------------------------

loc_910:				; CODE XREF: seg000:0902.j
		mov	bl, 0B9h ; ''
		call	sub_312
		mov	bl, 98h	; ''
		call	sub_312
		mov	bl, 9Ah	; ''
		call	sub_312
		mov	bl, 9Ch	; ''
		call	sub_312
		mov	bl, 9Eh	; ''
		call	sub_312
		mov	bx, 0A5h ; ''
		call	sub_883
		call	sub_C50
		call	sub_9BD
		call	sub_C50
		call	sub_A43
		call	sub_C50
		mov	bx, es:[si]
		xchg	bh, bl
		inc	si
		inc	si
		cmp	bx, 0ABCDh
		jnz	short loc_958
		call	sub_9BD
		call	sub_C50
		mov	bx, es:[si]
		xchg	bh, bl
		inc	si
		inc	si

loc_958:				; CODE XREF: seg000:0949.j
		cmp	bx, 0DCBAh
		jnz	short loc_964
		call	sub_B7F
		call	sub_C50

loc_964:				; CODE XREF: seg000:095C.j
		mov	bx, 91h	; ''
		call	sub_883
		call	sub_C50
		mov	bx, 0DFh ; ''
		call	sub_312
		mov	cx, 10h
		xor	di, di

loc_978:				; CODE XREF: seg000:0981.j
		mov	bl, cs:[di+81h]
		call	sub_367
		inc	di
		loop	loc_978
		xor	dx, dx
		mov	ax, cs:word_CD
		mov	bx, 0Fh
		div	bx
		mov	cs:word_12D, ax
		mov	cs:word_121, 0
		mov	cs:byte_11A, 0FFh
		mov	cs:word_11D, 0FFFFh
		mov	cs:word_131, 0

		mov	bx, 2
		mov	word ptr cs:[bx+133h], ShutdownDevice
		mov	ax, driver_end
		xor	cx, cx
		retn

; =============== S U B	R O U T	I N E =======================================


InitDevice_SB:
sub_275E	proc near		; CODE XREF: seg000:2BF7.p
		push	ds
		push	es
		push	di
		push	si
		mov	ax, cs
		mov	ds, ax
		mov	es, ax
		call	sub_24B7
		jnz	short loc_2783
		call	sub_24E4
		jnz	short loc_2783
		call	sub_257A
		jnz	short loc_2783
		call	sub_250D
		jnz	short loc_2783

		mov	al, 1
		call	sub_278E


		; setup sb dac volume
		mov cs:byte_sbvol, 13
		call SetVolume_SB


		xor	ax, ax

loc_2783:				; CODE XREF: sub_275E+D.j sub_275E+12.j	...
		pop	si
		pop	di
		pop	es
		pop	ds
		retn
sub_275E	endp


; =============== S U B	R O U T	I N E =======================================


sub_9BD		proc near		; CODE XREF: seg000:0932.p seg000:094B.p
		push	dx
		push	di
		xor	dx, dx

loc_9C1:				; CODE XREF: sub_9BD+81.j
		push	bx
		mov	bx, 0DFh ; ''
		call	sub_312
		mov	cs:byte_110, 0
		xor	di, di

loc_9D0:				; CODE XREF: sub_9BD+1F.j
		mov	bl, cs:[di+56h]
		call	sub_367
		inc	di
		cmp	di, 5
		jl	short loc_9D0

loc_9DE:				; CODE XREF: sub_9BD+32.j
		mov	bl, cs:[di+56h]
		add	cs:byte_110, bl
		call	sub_367
		inc	di
		cmp	di, 8
		jl	short loc_9DE
		pop	bx
		xor	di, di

loc_9F4:				; CODE XREF: sub_9BD+48.j
		mov	bl, es:[si]
		add	cs:byte_110, bl
		call	sub_367
		inc	dx
		inc	si
		inc	di
		cmp	di, 8
		jl	short loc_9F4
		neg	cs:byte_110
		and	cs:byte_110, 7Fh
		mov	bl, cs:byte_110
		call	sub_367
		mov	bl, 0F7h ; ''
		call	sub_367
		add	cs:byte_5D, 8
		cmp	cs:byte_5D, 7Fh	; ''
		jbe	short loc_A38
		inc	cs:byte_5C
		sub	cs:byte_5D, 80h	; ''

loc_A38:				; CODE XREF: sub_9BD+6E.j
		cmp	dx, 180h
		jnb	short loc_A40
		jmp	short loc_9C1
; ---------------------------------------------------------------------------

loc_A40:				; CODE XREF: sub_9BD+7F.j
		pop	di
		pop	dx
		retn
sub_9BD		endp


; =============== S U B	R O U T	I N E =======================================


sub_A43		proc near		; CODE XREF: seg000:0938.p
		push	cx
		push	dx
		push	di
		mov	dl, es:[si]
		inc	si
		cmp	dl, 0
		jz	short loc_A91
		xor	cl, cl
		mov	cs:byte_54, 0
		mov	cs:byte_55, 0

loc_A5D:				; CODE XREF: sub_A43+4C.j
		call	sub_A95
		call	sub_C50
		call	sub_B0A
		call	sub_C50
		call	sub_B0A
		call	sub_C50
		call	sub_B0A
		call	sub_C50
		call	sub_B0A
		call	sub_C50
		inc	cl
		inc	cl
		mov	cs:byte_54, cl
		mov	cs:byte_55, 0
		dec	dl
		cmp	dl, 0
		ja	short loc_A5D

loc_A91:				; CODE XREF: sub_A43+A.j
		pop	di
		pop	dx
		pop	cx
		retn
sub_A43		endp


; =============== S U B	R O U T	I N E =======================================


sub_A95		proc near		; CODE XREF: sub_A43:loc_A5D.p
		mov	bx, 0DFh ; ''
		call	sub_312
		mov	cs:byte_110, 0
		xor	di, di

loc_AA3:				; CODE XREF: sub_A95+1A.j
		mov	bl, cs:[di+4Eh]
		call	sub_367
		inc	di
		cmp	di, 5
		jl	short loc_AA3

loc_AB1:				; CODE XREF: sub_A95+2D.j
		mov	bl, cs:[di+4Eh]
		add	cs:byte_110, bl
		call	sub_367
		inc	di
		cmp	di, 8
		jl	short loc_AB1
		xor	di, di

loc_AC6:				; CODE XREF: sub_A95+41.j
		mov	bl, es:[si]
		add	cs:byte_110, bl
		call	sub_367
		inc	si
		inc	di
		cmp	di, 0Eh
		jl	short loc_AC6
		neg	cs:byte_110
		and	cs:byte_110, 7Fh
		mov	bl, cs:byte_110
		call	sub_367
		mov	bl, 0F7h ; ''
		call	sub_367
		add	cs:byte_55, 0Eh
		cmp	cs:byte_55, 7Fh	; ''
		jbe	short locret_B09
		inc	cs:byte_54
		sub	cs:byte_55, 80h	; ''

locret_B09:				; CODE XREF: sub_A95+67.j
		retn
sub_A95		endp


; =============== S U B	R O U T	I N E =======================================


sub_B0A		proc near		; CODE XREF: sub_A43+20.p sub_A43+26.p ...
		mov	bx, 0DFh ; ''
		call	sub_312
		mov	cs:byte_110, 0
		xor	di, di

loc_B18:				; CODE XREF: sub_B0A+1A.j
		mov	bl, cs:[di+4Eh]
		call	sub_367
		inc	di
		cmp	di, 5
		jl	short loc_B18

loc_B26:				; CODE XREF: sub_B0A+2D.j
		mov	bl, cs:[di+4Eh]
		add	cs:byte_110, bl
		call	sub_367
		inc	di
		cmp	di, 8
		jl	short loc_B26
		xor	di, di

loc_B3B:				; CODE XREF: sub_B0A+41.j
		mov	bl, es:[si]
		add	cs:byte_110, bl
		call	sub_367
		inc	si
		inc	di
		cmp	di, 3Ah	; ':'
		jl	short loc_B3B
		neg	cs:byte_110
		and	cs:byte_110, 7Fh
		mov	bl, cs:byte_110
		call	sub_367
		mov	bl, 0F7h ; ''
		call	sub_367
		add	cs:byte_55, 3Ah	; ':'
		cmp	cs:byte_55, 7Fh	; ''
		jbe	short locret_B7E
		inc	cs:byte_54
		sub	cs:byte_55, 80h	; ''

locret_B7E:				; CODE XREF: sub_B0A+67.j
		retn
sub_B0A		endp


; =============== S U B	R O U T	I N E =======================================


sub_B7F		proc near		; CODE XREF: seg000:095E.p
		push	dx
		push	di
		xor	dx, dx

loc_B83:				; CODE XREF: sub_B7F+81.j
		push	bx
		mov	bx, 0DFh ; ''
		call	sub_312
		mov	cs:byte_110, 0
		xor	di, di

loc_B92:				; CODE XREF: sub_B7F+1F.j
		mov	bl, cs:[di+5Eh]
		call	sub_367
		inc	di
		cmp	di, 5
		jl	short loc_B92

loc_BA0:				; CODE XREF: sub_B7F+32.j
		mov	bl, cs:[di+5Eh]
		add	cs:byte_110, bl
		call	sub_367
		inc	di
		cmp	di, 8
		jl	short loc_BA0
		pop	bx
		xor	di, di

loc_BB6:				; CODE XREF: sub_B7F+48.j
		mov	bl, es:[si]
		add	cs:byte_110, bl
		call	sub_367
		inc	dx
		inc	si
		inc	di
		cmp	di, 4
		jl	short loc_BB6
		neg	cs:byte_110
		and	cs:byte_110, 7Fh
		mov	bl, cs:byte_110
		call	sub_367
		mov	bl, 0F7h ; ''
		call	sub_367
		add	cs:byte_65, 4
		cmp	cs:byte_65, 7Fh	; ''
		jbe	short loc_BFA
		inc	cs:byte_64
		sub	cs:byte_65, 80h	; ''

loc_BFA:				; CODE XREF: sub_B7F+6E.j
		cmp	dx, 100h
		jnb	short loc_C02
		jmp	short loc_B83
; ---------------------------------------------------------------------------

loc_C02:				; CODE XREF: sub_B7F+7F.j
		call	sub_C50
		mov	bx, 0DFh ; ''
		call	sub_312
		xor	di, di
		mov	cs:byte_110, 14h

loc_C13:				; CODE XREF: sub_B7F+A0.j
		mov	bl, cs:[di+66h]
		call	sub_367
		inc	di
		cmp	di, 8
		jl	short loc_C13
		xor	di, di

loc_C23:				; CODE XREF: sub_B7F+B4.j
		mov	bl, es:[si]
		add	cs:byte_110, bl
		call	sub_367
		inc	di
		inc	si
		cmp	di, 9
		jl	short loc_C23
		neg	cs:byte_110
		and	cs:byte_110, 7Fh
		mov	bl, cs:byte_110
		call	sub_367
		mov	bl, 0F7h ; ''
		call	sub_367
		pop	di
		pop	dx
		retn
sub_B7F		endp


; =============== S U B	R O U T	I N E =======================================


sub_C50		proc near		; CODE XREF: seg000:092F.p seg000:0935.p ...
		push	ax
		push	dx
		push	di
		mov	dx, 331h
		xor	di, di

loc_C58:				; CODE XREF: sub_C50+E.j
		in	al, dx
		inc	di
		cmp	di, 2500h
		jb	short loc_C58
		pop	di
		pop	dx
		pop	ax
		retn
sub_C50		endp


; =============== S U B	R O U T	I N E =======================================


sub_2465	proc near		; CODE XREF: sub_24E4+D.p sub_24E4+14.p
		mov	cx, 200h
		mov	ah, al

loc_246A:				; CODE XREF: sub_2465+A.j
		in	al, dx
		or	al, al
		jns	short loc_2474
		loop	loc_246A
		stc
		jmp	short locret_2478
; ---------------------------------------------------------------------------

loc_2474:				; CODE XREF: sub_2465+8.j
		mov	al, ah
		out	dx, al
		clc

locret_2478:				; CODE XREF: sub_2465+D.j
		retn
sub_2465	endp


; =============== S U B	R O U T	I N E =======================================


sub_2479	proc near		; CODE XREF: sub_24B7:loc_24CF.p
					; sub_24E4+19.p
		push	dx
		mov	dx, cs:word_2025
		add	dl, 0Eh
		mov	cx, 200h

loc_2485:				; CODE XREF: sub_2479+11.j
		in	al, dx
		or	al, al
		js	short loc_248F
		loop	loc_2485
		stc
		jmp	short loc_2494
; ---------------------------------------------------------------------------

loc_248F:				; CODE XREF: sub_2479+F.j
		sub	dl, 4
		in	al, dx
		clc

loc_2494:				; CODE XREF: sub_2479+14.j
		pop	dx
		retn
sub_2479	endp



; ---------------------------------------------------------------------------

sb_irq2:
		push	ds
		push	ax
		push	dx
		mov	ax, cs
		mov	ds, ax
		mov	dx, cs:word_2025
		add	dx, 0Eh
		in	al, dx
		mov	cs:byte_2027, 2
		mov	al, 20h	; ' '
		out	20h, al		; Interrupt controller,	8259A.
		pop	dx
		pop	ax
		pop	ds
		iret
; ---------------------------------------------------------------------------

sb_irq3:
		push	ds
		push	ax
		push	dx
		mov	ax, cs
		mov	ds, ax
		mov	dx, cs:word_2025
		add	dx, 0Eh
		in	al, dx
		mov	cs:byte_2027, 3
		mov	al, 20h	; ' '
		out	20h, al		; Interrupt controller,	8259A.
		pop	dx
		pop	ax
		pop	ds
		iret
; ---------------------------------------------------------------------------

sb_irq5:
		push	ds
		push	ax
		push	dx
		mov	ax, cs
		mov	ds, ax
		mov	dx, cs:word_2025
		add	dx, 0Eh
		in	al, dx
		mov	cs:byte_2027, 5
		mov	al, 20h	; ' '
		out	20h, al		; Interrupt controller,	8259A.
		pop	dx
		pop	ax
		pop	ds
		iret
; ---------------------------------------------------------------------------

sb_irq7:
		push	ds
		push	ax
		push	dx
		mov	ax, cs
		mov	ds, ax
		mov	dx, cs:word_2025
		add	dx, 0Eh
		in	al, dx
		mov	cs:byte_2027, 7
		mov	al, 20h	; ' '
		out	20h, al		; Interrupt controller,	8259A.
		pop	dx
		pop	ax
		pop	ds
		iret

; =============== S U B	R O U T	I N E =======================================


sub_24A1	proc near		; CODE XREF: sub_257A+D.p sub_257A+12.p
		push	dx
		mov	dx, cs:word_2025
		add	dl, 0Eh
		xor	al, al

loc_24AC:				; CODE XREF: sub_24A1+E.j
		in	al, dx
		or	al, al
		jns	short loc_24AC
		sub	dl, 4
		in	al, dx
		pop	dx
		retn
sub_24A1	endp


; =============== S U B	R O U T	I N E =======================================

sub_24B7	proc near		; CODE XREF: sub_275E+A.p
		mov	dx, cs:word_2025
		add	dl, 6
		mov	al, 1
		out	dx, al
		in	al, dx
		in	al, dx
		in	al, dx
		in	al, dx
		in	al, dx
		in	al, dx
		in	al, dx
		in	al, dx
		xor	al, al
		out	dx, al
		mov	cl, 20h	; ' '

loc_24CF:				; CODE XREF: sub_24B7+21.j
		call	sub_2479
		cmp	al, 0AAh ; ''
		jz	short loc_24DF
		dec	cl
		jnz	short loc_24CF
		mov	ax, 2
		jmp	short loc_24E1
; ---------------------------------------------------------------------------

loc_24DF:				; CODE XREF: sub_24B7+1D.j
		xor	ax, ax

loc_24E1:				; CODE XREF: sub_24B7+26.j
		or	ax, ax
		retn
sub_24B7	endp


; =============== S U B	R O U T	I N E =======================================


sub_24E4	proc near		; CODE XREF: sub_275E+F.p
		mov	bx, 2
		mov	al, 0E0h ; ''
		mov	dx, cs:word_2025
		add	dx, 0Ch
		call	sub_2465
		jb	short loc_2508
		mov	al, 0AAh ; ''
		call	sub_2465
		jb	short loc_2508
		call	sub_2479
		jb	short loc_2508
		cmp	al, 55h	; 'U'
		jnz	short loc_2508
		xor	bx, bx

loc_2508:				; CODE XREF: sub_24E4+10.j sub_24E4+17.j ...
		mov	ax, bx
		or	ax, ax
		retn
sub_24E4	endp


; =============== S U B	R O U T	I N E =======================================

sub_250D	proc near		; CODE XREF: sub_275E+19.p
		; save IRQs
		mov	al, 2
		mov	dx, offset sb_irq2
		mov	bx, offset word_irq2
		call	sub_25EE

		mov	al, 3
		mov	dx, offset sb_irq3
		mov	bx, offset word_irq3
		call	sub_25EE

		mov	al, 5
		mov	dx, offset sb_irq5
		mov	bx, offset word_irq5
		call	sub_25EE

		mov	al, 7
		mov	dx, offset sb_irq7
		mov	bx, offset word_irq7
		call	sub_25EE

		mov	dx, cs
		mov	ax, offset sub_250D
		call	sub_25DA

		xor	cx, cx
		mov	dh, 49h	; 'I'
		call	sub_25B1
		mov	dx, cs:word_2025
		add	dx, 0Ch
		mov	al, 40h	; '@'
		call	sub_2496
		mov	al, 64h	; 'd'
		call	sub_2496
		mov	al, 14h
		call	sub_2496
		xor	al, al
		call	sub_2496
		xor	al, al
		call	sub_2496
		xor	ax, ax
		mov	cx, 200h

loc_2558:				; CODE XREF: sub_250D+53.j
		; fast cpu hack
		hlt

		cmp	cs:byte_2027, 0
		jnz	short loc_2565
		loop	loc_2558
		mov	ax, 3

loc_2565:				; CODE XREF: sub_250D+51.j
		push	ax

		; restore IRQs
		mov	al, 2
		mov	bx, offset word_irq2
		call	sub_2629

		mov	al, 3
		mov	bx, offset word_irq3
		call	sub_2629

		mov	al, 5
		mov	bx, offset word_irq5
		call	sub_2629

		mov	al, 7
		mov	bx, offset word_irq7
		call	sub_2629

		pop	ax
		or	ax, ax
		retn
sub_250D	endp


; =============== S U B	R O U T	I N E =======================================


sub_257A	proc near		; CODE XREF: sub_275E+14.p
		mov	al, 0E1h ; ''
		mov	dx, cs:word_2025
		add	dl, 0Ch
		call	sub_2496
		call	sub_24A1
		mov	ah, al
		call	sub_24A1
		mov	bx, 1
		cmp	ax, 101h
		jb	short loc_2599
		xor	bx, bx

loc_2599:				; CODE XREF: sub_257A+1B.j
		mov	ax, bx
		or	ax, ax
		retn
sub_257A	endp





seg000		ends


		end
