/*  Princed V3 - Prince of Persia Level Editor for PC Version
    Copyright (C) 2003 Princed Development Team

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    The authors of this program may be contacted at http://forum.princed.org
*/

/*
wave.c: Princed Resources : 

 Copyright 2006 Princed Development Team
  Created: 19 Feb 2006

  Author: Enrique Calot <ecalot.cod@princed.org>
  Version: 1.01 (2006-Feb-09)

 Note:
  DO NOT remove this copyright notice
*/

/***************************************************************\
|                  I M P L E M E N T A T I O N                  |
\***************************************************************/

#include "binary.h" /* tBinary */
#include "common.h"
#include "wav.h" 
#include <stdlib.h>
#include <string.h> /* memcpy */
#include "dat.h" 
#include "reslist.h" 
#include "sound.h"

/***************************************************************\
|                         Binary Object                         |
\***************************************************************/

void* objWaveCreate(tBinary cont, int *error) { /* use get like main.c */
	tWave* r;
	*error=PR_RESULT_SUCCESS;
	
	if (cont.data[7] != 8) {
		/* probably compressed */
		*error = PR_RESULT_ERR_EXTRACTION;
		return NULL;
	}

	r=(tWave*)malloc(sizeof(tWave));
	r->samples.data=cont.data+8;
	r->samples.size=cont.size-8;
	r->samplerate = (cont.data[2] << 8) | cont.data[1];
	return (void*)r;
}

void* objMidiCreate(tBinary cont, int *error) {
	tBinary* r;
	*error=PR_RESULT_SUCCESS;
	
	r=(tBinary*)malloc(sizeof(tBinary));
	r->data=cont.data+1;
	r->size=cont.size-1;
	return (void*)r;
}

/* Should we cut the first byte? */
void* objPcspeakerCreate(tBinary cont, int *error) {
	tBinary* r;
	*error=PR_RESULT_SUCCESS;
	
	r=(tBinary*)malloc(sizeof(tBinary));
	r->data=cont.data+1;
	r->size=cont.size-1;
	return (void*)r;
}

/* Is this used at all?
int objSoundWrite(void* o, const char* file, int write(const char* file,tBinary* data,int optionflag, const char* backupExtension), int optionflag, const char* backupExtension) {
	return write(file,(tBinary*)o,optionflag,backupExtension);
}
*/

int objWaveWrite(void* o, const char* file, int optionflag, const char* backupExtension) {
	return writeWav(file,(tWave*)o,optionflag,backupExtension);
}

/*void* objSoundRead(const char* file, int read(const char* file, tBinary* c, int *pchannels, long *psamplerate, long *pbps), int *result, int *pchannels, long *psamplerate, long *pbps) {
	tBinary* o=(tBinary*)malloc(sizeof(tBinary));
	*result=read(file,o);
	return (void*)o;
}*/

void* objWaveRead(const char* file, int *result) {
	int  channels;
	long samplerate;
 	long bps;
	tWave* o=(tWave*)malloc(sizeof(tWave));
	
	*result=readWav(file,&(o->samples),&channels,&samplerate,&bps);

	if (*result==PR_RESULT_SUCCESS) {
		if (bps!=8)            *result=PR_RESULT_WAV_UNSUPPORTED_BITRATE;
/*		if (samplerate!=11025) *result=PR_RESULT_WAV_UNSUPPORTED_SAMPLERATE;*/
		if (channels!=1)     *result=PR_RESULT_WAV_UNSUPPORTED_STEREO;
		o->samplerate = samplerate;
	}
	if (*result!=PR_RESULT_SUCCESS) {
		free(o->samples.data);
		free(o);
		return NULL;
	}
	
	return (void*)o;
}

/* TODO: factorize */
int objWaveSet(void* o,tResource* res) {
	tWave* wave=o;
	res->content.size=wave->samples.size+8;
	res->content.data=malloc(wave->samples.size+8);
	/* TODO: set loop flag if needed */
	res->content.data[0]=0x01; /* TODO: use WAVE_MAGIC */
	res->content.data[1] = wave->samplerate & 0xFF;
	res->content.data[2] = (wave->samplerate >> 8) & 0xFF;
	res->content.data[3] = wave->samples.size & 0xFF;
	res->content.data[4] = (wave->samples.size >> 8) & 0xFF;
	res->content.data[5] = 0;
	res->content.data[6] = 0;
	res->content.data[7] = 8;
	memcpy(res->content.data+8,wave->samples.data,wave->samples.size);
	mWriteFileInDatFile(res);
	return PR_RESULT_SUCCESS;
}

int objMidiSet(void* o,tResource* res) {
	tBinary* midi=o;
	res->content.size=midi->size+1;
	res->content.data=malloc(midi->size+1);
	res->content.data[0]=0x02; /* TODO: use MIDI_MAGIC */
	memcpy(res->content.data+1,midi->data,midi->size);
	mWriteFileInDatFile(res);
	return PR_RESULT_SUCCESS;
}

int objPcspeakerSet(void* o,tResource* res) {
	tBinary* pcspeaker=o;
	res->content.size=pcspeaker->size+1;
	res->content.data=malloc(pcspeaker->size+1);
	res->content.data[0]=0x00; /* TODO: use PCSPEAKER_MAGIC */
	memcpy(res->content.data+1,pcspeaker->data,pcspeaker->size);
	mWriteFileInDatFile(res);
	return PR_RESULT_SUCCESS;
}

