/* f1gpprn.c - printer code code

   Copyright (C) 1994 David P Gymer

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation,
   675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <string.h>

#include "f1gpprn.h"

static struct
{
  const char *name, *desc;
  const char *half, *before, *after;
} printers[] = {
  { "DEFAULT", 0, 0, 0, "\014", },
  { "pcl", "LaserJet/DeskJet",
    "\033=", "\033&l1O\033(s15H", "\033(s10H\014\033&l0O" },
  { 0, 0, 0, 0, 0 }
};

static int printer = 0;
  
int
prn_select (const char *name)
{
  printer = 0;
  if (!name)
    return 0;
  while (printers[++printer].name)
    {
      if (!strcmp (printers[printer].name, name))
      	return 0;
    }
  printer = 0;
  return 1;
}

void
prn_list (FILE *fp, const char *leader)
{
  int i = 0;

  while (printers[++i].name)
    fprintf (fp, "%s%s (%s)\n", leader, printers[i].name, printers[i].desc);
}

static void
maybe_print (const char *s, FILE *fp)
{
  if (s)
    fputs (s, fp);
}

void
prn_code (enum prn_codes code, FILE *fp)
{
  const char *s;

  switch (code)
    {
    case PRN_CLOSE:
      s = printers[printer].after;
      break;
     case PRN_OPEN:
      s = printers[printer].before;
      break;
    case PRN_HALF:
      s = printers[printer].half;
      break;
    default:
      s = 0;
    }
  maybe_print (s, fp);
}
