// EditBestLineSegmentDialog.cpp : implementation file
//

#include "stdafx.h"
#include "TrackEd.h"
#include "EditBestLineSegmentDialog.h"
#include "TrackPropertiesView.h"
#include "Track.h"
#include "BestLineSeg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CEditBestLineSegmentDialog dialog


CEditBestLineSegmentDialog::CEditBestLineSegmentDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CEditBestLineSegmentDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CEditBestLineSegmentDialog)
	m_strA1 = _T("");
	m_strA2 = _T("");
	m_strA3 = _T("");
	m_nLength = 0;
	m_strType = _T("");
	//}}AFX_DATA_INIT

	m_pTrackPropertiesView = reinterpret_cast<CTrackPropertiesView *>(pParent);
}


void CEditBestLineSegmentDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CEditBestLineSegmentDialog)
	DDX_Text(pDX, IDC_EDIT_A1, m_strA1);
	DDX_Text(pDX, IDC_EDIT_A2, m_strA2);
	DDX_Text(pDX, IDC_EDIT_A3, m_strA3);
	DDX_Text(pDX, IDC_EDIT_LENGTH, m_nLength);
	DDX_Text(pDX, IDC_EDIT_TYPE, m_strType);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CEditBestLineSegmentDialog, CDialog)
	//{{AFX_MSG_MAP(CEditBestLineSegmentDialog)
	ON_BN_CLICKED(ID_APPLY, OnApply)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEditBestLineSegmentDialog message handlers

void CEditBestLineSegmentDialog::OnOK() 
{
	// transfer data to the best line segment
	UpdateSegment();
	
	CDialog::OnOK();
}

void CEditBestLineSegmentDialog::SetBestLineSeg(CBestLineSeg *pBl)
{
	m_pBestLineSeg = pBl;
}

BOOL CEditBestLineSegmentDialog::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	if ( m_pBestLineSeg != NULL )
	{
		m_strType.Format( "%02X", m_pBestLineSeg->type );
		m_nLength = m_pBestLineSeg->tlu;
		// Other Parameters
		m_strA1.Format( "%d", m_pBestLineSeg->a1 );
		m_strA2.Format( "%d", m_pBestLineSeg->a2 );
		m_strA3.Format( "%d", m_pBestLineSeg->a3 );

		UpdateData( FALSE );
	}
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CEditBestLineSegmentDialog::OnApply() 
{
	UpdateSegment();

	if ( m_pTrackPropertiesView == NULL )
		return;

	m_pTrackPropertiesView->GetDocument()->SetModifiedFlag();
	m_pTrackPropertiesView->GetDocument()->RefreshCCLine();
	m_pTrackPropertiesView->UpdateCCLine();
	m_pTrackPropertiesView->GetDocument()->UpdateAllViews( NULL );	
}

/// Transfer the data from from dialog to segment instance

void CEditBestLineSegmentDialog::UpdateSegment()
{
	if ( m_pBestLineSeg != NULL )
	{
		UpdateData( TRUE );
		int iType;
		sscanf( m_strType, "%X", &iType );
		m_pBestLineSeg->type = (byte) iType;
		m_pBestLineSeg->tlu = m_nLength;

		m_pBestLineSeg->a1 = atoi( m_strA1 );
		m_pBestLineSeg->a2 = atoi( m_strA2 );
		m_pBestLineSeg->a3 = atoi( m_strA3 );
	}
}
