/* ----------------------- intctl.c ----------------------------------------- */
/* void i_enable (int pnum);						      */
/* void i_disable();							      */
/* short comcli (void);							      */
/* void comsti (short flags);						      */
/*									      */

#include <conio.h>

#include "portio.h"
#include "com.h"

extern void far
i_enable (int port)
{
	register int	c;
	short		iflags;
	CCB		near *ccp;

	if (port < 1 || port > 4)
		return;
	ccp = &ccb[port-1];
	if (!ccp->flags & On)
		return;

	iflags = comcli ();

	c = inp (MCR) | MC_INT;
	outp (MCR, c);

	if (ccp->odata)
		outp (IER, RX_INT|TX_INT);
	else
		outp (IER, RX_INT);

	c = inp (IMR) & ~(1 << ccp->irq);
	outp (IMR, c);

	comsti (iflags);
}

extern void far
i_disable (int port)
{
	register int	c;
	short		iflags;
	CCB		near *ccp;

	if (port < 1 || port > 4)
		return;
	ccp = &ccb[port-1];

	iflags = comcli ();

	c = inp (IMR) | (1 << ccp->irq);
	outp (IMR, c);

	outp (IER, 0);

	c = inp (MCR) & ~MC_INT;
	outp (MCR, c);

	comsti (iflags);
}

extern short far
comcli (void)
{
	short	i;

	_asm {
		pushf
		pop	i
		cli
	}
	return (i);
}

extern void far
comsti (short i)
{
	_asm {
		push	i
		popf
	}
}
